/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CRLDistributionPointsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.CRLDistributionPoints";
    public static final String NAME = "CRLDistributionPoints";
    public static final String DISTRIBUTION_PTS = "distribution_pts";
    private DistributionPoint[] dPoints = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CRLDistributionPointsExtension";

    public CRLDistributionPointsExtension(boolean bl, DistributionPoint[] distributionPointArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLDistributionPointsExtension", new Boolean(bl), distributionPointArray);
        }
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = bl;
        this.dPoints = (DistributionPoint[])distributionPointArray.clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    public CRLDistributionPointsExtension(boolean bl, byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLDistributionPointsExtension", new Boolean(bl), byArray);
        }
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = bl;
        this.extensionValue = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.extensionValue, 0, byArray.length);
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    public CRLDistributionPointsExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLDistributionPointsExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "CRLDistributionPointsExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    public CRLDistributionPointsExtension(DerValue derValue) throws IOException {
        super(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CRLDistributionPointsExtension", derValue);
        }
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLDistributionPointsExtension");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DISTRIBUTION_PTS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(DISTRIBUTION_PTS)) {
            if (!(object instanceof DistributionPoint[])) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type DistributionPoint[].");
                }
                throw new IOException("Attribute value should be of type DistributionPoint[].");
            }
            DistributionPoint[] distributionPointArray = (DistributionPoint[])object;
            this.dPoints = new DistributionPoint[distributionPointArray.length];
            for (int i = 0; i < distributionPointArray.length; ++i) {
                DerOutputStream derOutputStream = new DerOutputStream();
                distributionPointArray[i].encode(derOutputStream);
                this.dPoints[i] = new DistributionPoint(derOutputStream.toByteArray());
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(DISTRIBUTION_PTS)) {
            if (this.dPoints != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.dPoints.clone());
                }
                return this.dPoints.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(DISTRIBUTION_PTS)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPoints.");
        }
        this.dPoints = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        String string;
        block8: {
            if (debug != null) {
                debug.entry(16384L, className, "toString");
            }
            string = super.toString();
            string = string + this.getName() + " [\r\n";
            if (this.dPoints == null) {
                try {
                    this.decodeThis();
                }
                catch (Exception exception) {
                    if (debug == null) break block8;
                    debug.exception(16384L, className, "toString", exception);
                }
            }
        }
        if (this.dPoints == null) {
            string = string + "No distribution points\r\n";
        } else {
            string = string + this.dPoints.length + " CRL Distribution Points:\r\n";
            for (int i = 0; i < this.dPoints.length; ++i) {
                string = string + this.dPoints[i].toString();
            }
        }
        string = string + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] distributionPointArray = null;
        if (debug != null) {
            debug.entry(16384L, className, "getDistributionPoints");
        }
        try {
            if (this.dPoints == null || this.dPoints.length == 0) {
                if (this.extensionValue == null || this.extensionValue.length == 0) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getDistributionPoints_1", null);
                    }
                    return null;
                }
                this.decodeThis();
            }
            distributionPointArray = new DistributionPoint[this.dPoints.length];
            for (int i = 0; i < this.dPoints.length; ++i) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.dPoints[i].encode(derOutputStream);
                DerValue derValue = new DerValue(derOutputStream.toByteArray());
                distributionPointArray[i] = new DistributionPoint(derValue.toByteArray());
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getDistributionPoints", iOException);
                debug.exit(16384L, (Object)className, "getDistributionPoints_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDistributionPoints_3", distributionPointArray);
        }
        return distributionPointArray;
    }

    @Override
    public byte[] getExtensionValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtensionValue");
        }
        byte[] byArray = null;
        if (this.extensionValue == null || this.extensionValue.length == 0) {
            if (this.dPoints == null || this.dPoints.length == 0) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
                }
                return null;
            }
            try {
                this.encodeThis();
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getExtensionValue", iOException);
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
        }
        int n = this.extensionValue.length;
        byArray = new byte[n];
        System.arraycopy(this.extensionValue, 0, byArray, 0, n);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getExtensionValue_3", byArray);
        }
        return byArray;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.dPoints == null || this.dPoints.length == 0) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.dPoints.length; ++i) {
            this.dPoints[i].encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    private void decodeThis() throws IOException {
        DerValue derValue;
        if (debug != null) {
            debug.entry(16384L, className, "decodeThis");
        }
        if ((derValue = new DerValue(this.extensionValue)).getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decodeThis", "CRLDistributionPointsExtension parsing error: not a SEQUENCE.");
            }
            throw new IOException("CRLDistributionPointsExtension parsing error: not a SEQUENCE.");
        }
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decodeThis", "No data available in DER encoded value.");
            }
            throw new IOException("No data available in DER encoded value.");
        }
        ArrayList<DistributionPoint> arrayList = new ArrayList<DistributionPoint>();
        while (derValue.getData() != null && derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            DistributionPoint distributionPoint = new DistributionPoint(derValue2.toByteArray());
            arrayList.add(distributionPoint);
        }
        if (arrayList.size() > 0) {
            this.dPoints = new DistributionPoint[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.dPoints[i] = (DistributionPoint)arrayList.get(i);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decodeThis");
        }
    }
}

