/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private static boolean initOidTable = false;
    private static Map<String, ObjectIdentifier> oidTable;
    private String provider;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    protected DerValue params;
    private static Debug debug;
    private static String className;
    private static final int[] MD2_data;
    private static final int[] MD5_data;
    private static final int[] SHA1_OIW_data;
    private static final int[] SHA256_data;
    private static final int[] SHA384_data;
    private static final int[] SHA512_data;
    private static final int[] HmacSHA1_data;
    private static final int[] PasswordBasedMac_data;
    public static ObjectIdentifier MD2_oid;
    public static ObjectIdentifier MD5_oid;
    public static ObjectIdentifier SHA_oid;
    public static ObjectIdentifier SHA256_oid;
    public static ObjectIdentifier SHA384_oid;
    public static ObjectIdentifier SHA512_oid;
    public static ObjectIdentifier HmacSHA1_oid;
    public static ObjectIdentifier PasswordBasedMac_oid;
    private static final int[] DH_data;
    private static final int[] DH_PKIX_data;
    private static final int[] DSA_OIW_data;
    private static final int[] DSA_PKIX_data;
    private static final int[] RSA_data;
    private static final int[] RSAEncryption_data;
    public static ObjectIdentifier DH_oid;
    public static ObjectIdentifier DH_PKIX_oid;
    public static ObjectIdentifier DSA_OIW_oid;
    public static ObjectIdentifier DSA_oid;
    public static ObjectIdentifier RSA_oid;
    public static ObjectIdentifier RSAEncryption_oid;
    private static final int[] md2WithRSAEncryption_data;
    private static final int[] md5WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_OIW_data;
    private static final int[] sha256WithRSAEncryption_data;
    private static final int[] sha384WithRSAEncryption_data;
    private static final int[] sha512WithRSAEncryption_data;
    private static final int[] shaWithDSA_OIW_data;
    private static final int[] sha1WithDSA_OIW_data;
    private static final int[] dsaWithSHA1_PKIX_data;
    private static final int[] DESCBC_data;
    private static final int[] tripleDESCBC_data;
    private static final int[] RC2CBC_data;
    private static final int[] AES128CBC_data;
    private static final int[] AES192CBC_data;
    private static final int[] AES256CBC_data;
    public static ObjectIdentifier md2WithRSAEncryption_oid;
    public static ObjectIdentifier md5WithRSAEncryption_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_OIW_oid;
    public static ObjectIdentifier sha256WithRSAEncryption_oid;
    public static ObjectIdentifier sha384WithRSAEncryption_oid;
    public static ObjectIdentifier sha512WithRSAEncryption_oid;
    public static ObjectIdentifier shaWithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_oid;
    public static ObjectIdentifier DESCBC_oid;
    public static ObjectIdentifier tripleDESCBC_oid;
    public static ObjectIdentifier RC2CBC_oid;
    public static ObjectIdentifier AES128CBC_oid;
    public static ObjectIdentifier AES192CBC_oid;
    public static ObjectIdentifier AES256CBC_oid;

    public AlgorithmId(DerValue derValue) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgorithmId", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AlgorithmId", "algid parse error: not a sequence");
            }
            throw new IOException("algid parse error: not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.algid = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            this.params = null;
        } else {
            this.params = derInputStream.getDerValue();
            if (this.params.getTag() == 5) {
                this.params = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(DerValue derValue, String string) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", derValue, string);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AlgorithmId", "algid parse error: not a sequence");
            }
            throw new IOException("algid parse error: not a sequence");
        }
        if (string != null) {
            this.provider = new String(string);
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.algid = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            this.params = null;
        } else {
            this.params = derInputStream.getDerValue();
            if (this.params.getTag() == 5) {
                this.params = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", objectIdentifier, byArray);
        }
        this.algid = objectIdentifier;
        if (byArray != null && byArray.length != 0) {
            this.params = new DerValue(byArray);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier, byte[] byArray, String string) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, byArray, string};
            debug.entry(16384L, (Object)className, "AlgorithmId", objectArray);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.algid = objectIdentifier;
        if (byArray != null && byArray.length != 0) {
            this.params = new DerValue(byArray);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(String string, byte[] byArray) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", string, byArray);
        }
        try {
            this.algid = new ObjectIdentifier(string);
        }
        catch (Exception exception) {
            this.algid = null;
        }
        if (byArray != null && byArray.length != 0) {
            this.params = new DerValue(byArray);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(String string, byte[] byArray, String string2) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] objectArray = new Object[]{string, byArray, string2};
            debug.entry(16384L, (Object)className, "AlgorithmId", objectArray);
        }
        if (string2 != null) {
            this.provider = new String(string2);
        }
        try {
            this.algid = new ObjectIdentifier(string);
        }
        catch (Exception exception) {
            this.algid = null;
        }
        if (byArray != null && byArray.length != 0) {
            this.params = new DerValue(byArray);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier, AlgorithmParameters algorithmParameters) {
        block4: {
            this.provider = null;
            if (debug != null) {
                debug.entry(16384L, className, "AlgorithmId", objectIdentifier, algorithmParameters);
            }
            this.algid = objectIdentifier;
            this.algParams = algorithmParameters;
            try {
                this.params = this.algParams != null ? new DerValue(this.algParams.getEncoded()) : null;
            }
            catch (Exception exception) {
                this.params = null;
                if (debug == null) break block4;
                debug.exception(16384L, className, "AlgorithmId", exception);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public static AlgorithmId getAlgorithmId(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAlgorithmId", string);
            debug.exit(16384L, (Object)className, "getAlgorithmId", AlgorithmId.get(string));
        }
        return AlgorithmId.get(string);
    }

    public AlgorithmParameters getAlgParameters() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgParameters");
            debug.exit(16384L, (Object)className, "getAlgParameters", this.algParams);
        }
        return this.algParams;
    }

    public byte[] getParameters() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getParameters");
        }
        if (this.params != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getParameters_1", this.params.toByteArray());
            }
            return this.params.toByteArray();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getParameters_2", null);
        }
        return null;
    }

    public static AlgorithmId get(AlgorithmParameters algorithmParameters) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier = null;
        String string = algorithmParameters.getAlgorithm();
        objectIdentifier = AlgorithmId.algOID(string);
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier, algorithmParameters);
    }

    public static AlgorithmId get(String string) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "get", string);
        }
        if ((objectIdentifier = AlgorithmId.algOID(string)) == null) {
            if (debug != null) {
                debug.text(49152L, className, "get", "unrecognized algorithm name: " + string);
            }
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "get", new AlgorithmId(objectIdentifier));
        }
        return new AlgorithmId(objectIdentifier);
    }

    public static AlgorithmId get(String string, String string2) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier;
        if (debug != null) {
            debug.entry(49152L, className, "get", string, string2);
        }
        if ((objectIdentifier = AlgorithmId.algOID(string)) == null) {
            if (debug != null) {
                debug.text(49152L, className, "get", "unrecognized algorithm name: " + string);
            }
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "get", new AlgorithmId(objectIdentifier, string2));
        }
        return new AlgorithmId(objectIdentifier, string2);
    }

    public static AlgorithmId parse(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "parse", derValue);
            debug.exit(49152L, className, "parse");
        }
        return AlgorithmId.parse(derValue, null);
    }

    public static AlgorithmId parse(DerValue derValue, String string) throws IOException {
        DerValue derValue2;
        if (debug != null) {
            debug.entry(49152L, className, "parse", derValue, string);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(49152L, className, "parse", "algid parse error, not a sequence");
            }
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            derValue2 = null;
        } else {
            derValue2 = derInputStream.getDerValue();
            if (derValue2.getTag() == 5) {
                derValue2 = null;
            }
        }
        AlgorithmId algorithmId = new AlgorithmId(objectIdentifier, derValue2, string);
        if (derValue2 != null) {
            algorithmId.decodeParams();
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "parse", algorithmId);
        }
        return algorithmId;
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier) {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgorithmId", objectIdentifier);
        }
        this.algid = objectIdentifier;
        this.algParams = null;
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier, String string) {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", objectIdentifier, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.algid = objectIdentifier;
        this.algParams = null;
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    private AlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", objectIdentifier, derValue);
        }
        this.algid = objectIdentifier;
        this.params = derValue;
        if (this.params != null) {
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    private AlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue, String string) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, derValue, string};
            debug.entry(16384L, (Object)className, "AlgorithmId", objectArray);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.algid = objectIdentifier;
        this.params = derValue;
        if (this.params != null) {
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    protected void decodeParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "decodeParams");
        }
        if (this.params == null) {
            this.algParams = null;
            if (debug != null) {
                debug.exit(16384L, className, "decodeParams_1");
            }
            return;
        }
        try {
            this.algParams = this.provider != null ? AlgorithmParameters.getInstance(this.algid.toString(), this.provider) : AlgorithmParameters.getInstance(this.algid.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams_1", noSuchAlgorithmException.toString());
            }
            try {
                this.algParams = this.provider != null ? AlgorithmParameters.getInstance(this.algName(), this.provider) : AlgorithmParameters.getInstance(this.algName());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                if (debug != null) {
                    debug.text(16384L, className, "decodeParams_2", noSuchAlgorithmException2.toString());
                    debug.exit(16384L, className, "decodeParams_2");
                }
                this.algParams = null;
                return;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (debug != null) {
                    debug.text(16384L, className, "decodeParams_3", noSuchProviderException.toString());
                    debug.exit(16384L, className, "decodeParams_3");
                }
                this.algParams = null;
                return;
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams_4", noSuchProviderException.toString());
                debug.exit(16384L, className, "decodeParams_4");
            }
            this.algParams = null;
            return;
        }
        this.algParams.init(this.params.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "decodeParams_5");
        }
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        this.derEncode(derOutputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        derOutputStream.putOID(this.algid);
        if (this.params == null && this.algParams != null) {
            this.params = new DerValue(this.algParams.getEncoded());
        }
        if (this.params == null) {
            derOutputStream.putNull();
        } else {
            derOutputStream.putDerValue(this.params);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public final byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        derOutputStream2.putOID(this.algid);
        if (this.params == null) {
            derOutputStream2.putNull();
        } else {
            derOutputStream2.putDerValue(this.params);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        byte[] byArray = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", byArray);
        }
        return byArray;
    }

    private static ObjectIdentifier algOID(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "algOID", string);
        }
        if (string.indexOf(46) != -1) {
            if (string.startsWith("OID.")) {
                ObjectIdentifier objectIdentifier = null;
                try {
                    objectIdentifier = new ObjectIdentifier(string.substring("OID.".length()));
                }
                catch (Exception exception) {
                    objectIdentifier = null;
                }
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "algOID_1", objectIdentifier);
                }
                return objectIdentifier;
            }
            ObjectIdentifier objectIdentifier = null;
            try {
                objectIdentifier = new ObjectIdentifier(string);
            }
            catch (Exception exception) {
                objectIdentifier = null;
            }
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_2", objectIdentifier);
            }
            return objectIdentifier;
        }
        if (string.equalsIgnoreCase("DES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_3", DESCBC_oid);
            }
            return DESCBC_oid;
        }
        if (string.equalsIgnoreCase("tripleDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_4", tripleDESCBC_oid);
            }
            return tripleDESCBC_oid;
        }
        if (string.equalsIgnoreCase("3DES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_5", tripleDESCBC_oid);
            }
            return tripleDESCBC_oid;
        }
        if (string.equalsIgnoreCase("DESede")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_6", tripleDESCBC_oid);
            }
            return tripleDESCBC_oid;
        }
        if (string.equalsIgnoreCase("RC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_7", RC2CBC_oid);
            }
            return RC2CBC_oid;
        }
        if (string.equalsIgnoreCase("PBEWithMD2AndDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_8", PKCSOID.PBEWITHMD2ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHMD2ANDDES_CBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithMD2AndRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_9", PKCSOID.PBEWITHMD2ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHMD2ANDRC2_CBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithMD5AndDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_10", PKCSOID.PBEWITHMD5ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHMD5ANDDES_CBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithMD5AndRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_11", PKCSOID.PBEWITHMD5ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHMD5ANDRC2_CBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHA1AndDES") || string.equalsIgnoreCase("PBEWithSHA1AndDES")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_12", PKCSOID.PBEWITHSHA1ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHSHA1ANDDES_CBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHA1AndRC2") || string.equalsIgnoreCase("PBEWithSHA1AndRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_13", PKCSOID.PBEWITHSHA1ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHSHA1ANDRC2_CBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHAAnd40BitRC4") || string.equalsIgnoreCase("PBEWithSHA1And40BitRC4") || string.equalsIgnoreCase("PBEWithSHA-1And40BitRC4")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_14", PKCSOID.PBEWITHSHAAND40BITRC4_OID);
            }
            return PKCSOID.PBEWITHSHAAND40BITRC4_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHAAnd128BitRC4") || string.equalsIgnoreCase("PBEWithSHA1And128BitRC4") || string.equalsIgnoreCase("PBEWithSHA-1And128BitRC4")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_15", PKCSOID.PBEWITHSHAAND128BITRC4_OID);
            }
            return PKCSOID.PBEWITHSHAAND128BITRC4_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHAAnd3KeyTripleDes") || string.equalsIgnoreCase("PBEWithSHA1And3KeyTripleDes") || string.equalsIgnoreCase("PBEWithSHA-1And3KeyTripleDes")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_16", PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHAAnd2KeyTripleDes") || string.equalsIgnoreCase("PBEWithSHA1And2KeyTripleDes") || string.equalsIgnoreCase("PBEWithSHA-1And2KeyTripleDes")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_17", PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHAAnd40BitRC2") || string.equalsIgnoreCase("PBEWithSHA1And40BitRC2") || string.equalsIgnoreCase("PBEWithSHA-1And40BitRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_18", PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID;
        }
        if (string.equalsIgnoreCase("PBEWithSHAAnd128BitRC2") || string.equalsIgnoreCase("PBEWithSHA1And128BitRC2") || string.equalsIgnoreCase("PBEWithSHA-1And128BitRC2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_19", PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID;
        }
        if (string.equalsIgnoreCase("MD5")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_20", MD5_oid);
            }
            return MD5_oid;
        }
        if (string.equalsIgnoreCase("MD2")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_21", MD2_oid);
            }
            return MD2_oid;
        }
        if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA1") || string.equalsIgnoreCase("SHA-1")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_22", SHA_oid);
            }
            return SHA_oid;
        }
        if (string.equalsIgnoreCase("SHA-256") || string.equalsIgnoreCase("SHA256")) {
            return SHA256_oid;
        }
        if (string.equalsIgnoreCase("SHA-384") || string.equalsIgnoreCase("SHA384")) {
            return SHA384_oid;
        }
        if (string.equalsIgnoreCase("SHA-512") || string.equalsIgnoreCase("SHA512")) {
            return SHA512_oid;
        }
        if (string.equalsIgnoreCase("RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_23", RSAEncryption_oid);
            }
            return RSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("Diffie-Hellman") || string.equalsIgnoreCase("DH")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_24", DH_oid);
            }
            return DH_oid;
        }
        if (string.equalsIgnoreCase("DSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_25", DSA_oid);
            }
            return DSA_oid;
        }
        if (string.equalsIgnoreCase("MD5withRSA") || string.equalsIgnoreCase("MD5/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_26", md5WithRSAEncryption_oid);
            }
            return md5WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("MD2withRSA") || string.equalsIgnoreCase("MD2/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_27", md2WithRSAEncryption_oid);
            }
            return md2WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("SHAwithDSA") || string.equalsIgnoreCase("SHA1withDSA") || string.equalsIgnoreCase("SHA/DSA") || string.equalsIgnoreCase("SHA1/DSA") || string.equalsIgnoreCase("DSAWithSHA1")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_28", sha1WithDSA_oid);
            }
            return sha1WithDSA_oid;
        }
        if (string.equalsIgnoreCase("SHA1WithRSA") || string.equalsIgnoreCase("SHA1/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_29", sha1WithRSAEncryption_oid);
            }
            return sha1WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("SHAWithRSA") || string.equalsIgnoreCase("SHA/RSA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_30", sha1WithRSAEncryption_oid);
            }
            return sha1WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("HmacSHA1") || string.equalsIgnoreCase("HmacSHA")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_31", HmacSHA1_oid);
            }
            return HmacSHA1_oid;
        }
        if (string.equalsIgnoreCase("PBM") || string.equalsIgnoreCase("PasswordBasedMac")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_32", PasswordBasedMac_oid);
            }
            return PasswordBasedMac_oid;
        }
        if (string.equalsIgnoreCase("AES128")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_33", AES128CBC_oid);
            }
            return AES128CBC_oid;
        }
        if (string.equalsIgnoreCase("AES192")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_34", AES192CBC_oid);
            }
            return AES192CBC_oid;
        }
        if (string.equalsIgnoreCase("AES256")) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algOID_35", AES256CBC_oid);
            }
            return AES256CBC_oid;
        }
        if (!initOidTable) {
            Provider[] providerArray = Security.getProviders();
            block6: for (int i = 0; i < providerArray.length; ++i) {
                Enumeration<Object> enumeration = providerArray[i].keys();
                while (enumeration.hasMoreElements()) {
                    int n;
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.toUpperCase().startsWith("ALG.ALIAS") || (n = string2.toUpperCase().indexOf("OID.", 0)) == -1) continue;
                    if ((n += "OID.".length()) == string2.length()) continue block6;
                    if (oidTable == null) {
                        oidTable = new HashMap<String, ObjectIdentifier>(11);
                    }
                    String string3 = string2.substring(n);
                    String string4 = providerArray[i].getProperty(string2).toUpperCase();
                    if (oidTable.get(string4) != null) continue;
                    try {
                        oidTable.put(string4, new ObjectIdentifier(string3));
                    }
                    catch (Exception exception) {
                        oidTable.put(string4, null);
                    }
                }
            }
            initOidTable = true;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "algOID_33", oidTable.get(string.toUpperCase()));
        }
        return oidTable.get(string.toUpperCase());
    }

    private String algName() {
        if (debug != null) {
            debug.entry(8192L, className, "algName");
        }
        if (this.algid.equals(DESCBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_1", "DES");
            }
            return "DES";
        }
        if (this.algid.equals(tripleDESCBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_2", "DESede");
            }
            return "DESede";
        }
        if (this.algid.equals(RC2CBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_3", "RC2");
            }
            return "RC2";
        }
        if (this.algid.equals(MD5_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_4", "MD5");
            }
            return "MD5";
        }
        if (this.algid.equals(MD2_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_5", "MD2");
            }
            return "MD2";
        }
        if (this.algid.equals(SHA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_6", "SHA");
            }
            return "SHA";
        }
        if (this.algid.equals(RSAEncryption_oid) || this.algid.equals(RSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_7", "RSA");
            }
            return "RSA";
        }
        if (this.algid.equals(DH_oid) || this.algid.equals(DH_PKIX_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_8", "Diffie-Hellman");
            }
            return "Diffie-Hellman";
        }
        if (this.algid.equals(DSA_oid) || this.algid.equals(DSA_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_9", "DSA");
            }
            return "DSA";
        }
        if (this.algid.equals(md5WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_10", "MD5withRSA");
            }
            return "MD5withRSA";
        }
        if (this.algid.equals(md2WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_11", "MD2withRSA");
            }
            return "MD2withRSA";
        }
        if (this.algid.equals(sha1WithDSA_oid) || this.algid.equals(sha1WithDSA_OIW_oid) || this.algid.equals(shaWithDSA_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_12", "SHA1withDSA");
            }
            return "SHA1withDSA";
        }
        if (this.algid.equals(sha1WithRSAEncryption_oid) || this.algid.equals(sha1WithRSAEncryption_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_13", "SHA1withRSA");
            }
            return "SHA1withRSA";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD2ANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_14", "PBEWithMD2AndDES");
            }
            return "PBEWithMD2AndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD2ANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_15", "PBEWithMD2AndRC2");
            }
            return "PBEWithMD2AndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD5ANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_16", "PBEWithMD5AndDES");
            }
            return "PBEWithMD5AndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD5ANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_17", "PBEWithMD5AndRC2");
            }
            return "PBEWithMD5AndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_18", "PBEWithSHAAndDES");
            }
            return "PBEWithSHAAndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_19", "PBEWithSHAAndRC2");
            }
            return "PBEWithSHAAndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND40BITRC4_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_20", "PBEWithSHAAnd40BitRC4");
            }
            return "PBEWithSHAAnd40BitRC4";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND128BITRC4_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_21", "PBEWithSHAAnd128BitRC4");
            }
            return "PBEWithSHAAnd128BitRC4";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_22", "PBEWithSHAAnd3KeyTripleDES");
            }
            return "PBEWithSHAAnd3KeyTripleDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_23", "PBEWithSHAAnd2KeyTripleDES");
            }
            return "PBEWithSHAAnd2KeyTripleDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_24", "PBEWithSHAAnd40BitRC2");
            }
            return "PBEWithSHAAnd40BitRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_25", "PBEWithSHAAnd128BitRC2");
            }
            return "PBEWithSHAAnd128BitRC2";
        }
        if (this.algid.equals(HmacSHA1_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_26", "HmacSHA1");
            }
            return "HmacSHA1";
        }
        if (this.algid.equals(PasswordBasedMac_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_27", "PasswordBasedMac");
            }
            return "PasswordBasedMac";
        }
        if (this.algid.equals(AES128CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_28", "AES128");
        }
        if (this.algid.equals(AES192CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_29", "AES192");
        }
        if (this.algid.equals(AES256CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_30", "AES256");
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "algName_28", this.algid.toString());
        }
        return this.algid.toString();
    }

    public final ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.algid);
        }
        return this.algid;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", this.algName());
        }
        return this.algName();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.algName() + this.paramsToString());
        }
        return this.algName() + this.paramsToString();
    }

    public byte[] getEncodedParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedParams");
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedParams_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncodedParams_2", this.params.toByteArray());
        }
        return this.params.toByteArray();
    }

    protected String paramsToString() {
        if (debug != null) {
            debug.entry(16384L, className, "paramsToString");
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "paramsToString_1", "");
            }
            return "";
        }
        if (this.algParams != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "paramsToString_2", this.algParams.toString());
            }
            return this.algParams.toString();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "paramsToString_3", ", params unparsed");
        }
        return ", params unparsed";
    }

    public boolean equals(AlgorithmId algorithmId) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", algorithmId);
        }
        if (!this.algid.equals(algorithmId.algid)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (this.params == null && algorithmId.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", this.params.equals(algorithmId.params));
        }
        return this.params.equals(algorithmId.params);
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof AlgorithmId) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((AlgorithmId)object));
            }
            return this.equals((AlgorithmId)object);
        }
        if (object instanceof ObjectIdentifier) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", this.equals((ObjectIdentifier)object));
            }
            return this.equals((ObjectIdentifier)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", false);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", objectIdentifier);
            debug.exit(16384L, (Object)className, "equals", this.algid.equals(objectIdentifier));
        }
        return this.algid.equals(objectIdentifier);
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.algid.toString());
        stringBuilder.append(this.paramsToString());
        return stringBuilder.toString().hashCode();
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.x509.AlgorithmId";
        MD2_data = new int[]{1, 2, 840, 113549, 2, 2};
        MD5_data = new int[]{1, 2, 840, 113549, 2, 5};
        SHA1_OIW_data = new int[]{1, 3, 14, 3, 2, 26};
        SHA256_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 1};
        SHA384_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 2};
        SHA512_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 3};
        HmacSHA1_data = new int[]{1, 3, 6, 1, 5, 5, 8, 1, 2};
        PasswordBasedMac_data = new int[]{1, 2, 840, 113533, 7, 66, 13};
        DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
        DH_PKIX_data = new int[]{1, 2, 840, 10046, 2, 1};
        DSA_OIW_data = new int[]{1, 3, 14, 3, 2, 12};
        DSA_PKIX_data = new int[]{1, 2, 840, 10040, 4, 1};
        RSA_data = new int[]{1, 2, 5, 8, 1, 1};
        RSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
        md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
        md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
        sha1WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 5};
        sha1WithRSAEncryption_OIW_data = new int[]{1, 3, 14, 3, 2, 29};
        sha256WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 11};
        sha384WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 12};
        sha512WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 13};
        shaWithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 13};
        sha1WithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 27};
        dsaWithSHA1_PKIX_data = new int[]{1, 2, 840, 10040, 4, 3};
        DESCBC_data = new int[]{1, 3, 14, 3, 2, 7};
        tripleDESCBC_data = new int[]{1, 2, 840, 113549, 3, 7};
        RC2CBC_data = new int[]{1, 2, 840, 113549, 3, 2};
        AES128CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 2};
        AES192CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 22};
        AES256CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 42};
        try {
            MD2_oid = new ObjectIdentifier(MD2_data);
            MD5_oid = new ObjectIdentifier(MD5_data);
            SHA_oid = new ObjectIdentifier(SHA1_OIW_data);
            SHA256_oid = new ObjectIdentifier(SHA256_data);
            SHA384_oid = new ObjectIdentifier(SHA384_data);
            SHA512_oid = new ObjectIdentifier(SHA512_data);
            HmacSHA1_oid = new ObjectIdentifier(HmacSHA1_data);
            PasswordBasedMac_oid = new ObjectIdentifier(PasswordBasedMac_data);
            DH_oid = new ObjectIdentifier(DH_data);
            DH_PKIX_oid = new ObjectIdentifier(DH_PKIX_data);
            DSA_OIW_oid = new ObjectIdentifier(DSA_OIW_data);
            DSA_oid = new ObjectIdentifier(DSA_PKIX_data);
            RSA_oid = new ObjectIdentifier(RSA_data);
            RSAEncryption_oid = new ObjectIdentifier(RSAEncryption_data);
            md2WithRSAEncryption_oid = new ObjectIdentifier(md2WithRSAEncryption_data);
            md5WithRSAEncryption_oid = new ObjectIdentifier(md5WithRSAEncryption_data);
            sha1WithRSAEncryption_oid = new ObjectIdentifier(sha1WithRSAEncryption_data);
            sha1WithRSAEncryption_OIW_oid = new ObjectIdentifier(sha1WithRSAEncryption_OIW_data);
            sha256WithRSAEncryption_oid = new ObjectIdentifier(sha256WithRSAEncryption_data);
            sha384WithRSAEncryption_oid = new ObjectIdentifier(sha384WithRSAEncryption_data);
            sha512WithRSAEncryption_oid = new ObjectIdentifier(sha512WithRSAEncryption_data);
            shaWithDSA_OIW_oid = new ObjectIdentifier(shaWithDSA_OIW_data);
            sha1WithDSA_OIW_oid = new ObjectIdentifier(sha1WithDSA_OIW_data);
            sha1WithDSA_oid = new ObjectIdentifier(dsaWithSHA1_PKIX_data);
            DESCBC_oid = new ObjectIdentifier(DESCBC_data);
            tripleDESCBC_oid = new ObjectIdentifier(tripleDESCBC_data);
            RC2CBC_oid = new ObjectIdentifier(RC2CBC_data);
            AES128CBC_oid = new ObjectIdentifier(AES128CBC_data);
            AES192CBC_oid = new ObjectIdentifier(AES192CBC_data);
            AES256CBC_oid = new ObjectIdentifier(AES256CBC_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

