/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.smime.SMIME;
import com.ibm.security.smime.SMIMEMessage;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public final class SMIMESender
implements Cloneable {
    private ContentInfo contentInfo;
    private CertificationRequest certRequest;
    private Certificate[] recipientCerts;
    private static int msgcounter = 0;
    private static final int SMTP_PORT = 25;
    private String mailhost;
    private String provider = null;
    private boolean oldTypes = true;
    private static String oldPKCS7Signature = "application/x-pkcs7-signature";
    private static String oldPKCS7MIME = "application/x-pkcs7-mime";
    private static String oldPKCS10 = "application/x-pkcs10";
    private static String newPKCS7Signature = "application/pkcs7-signature";
    private static String newPKCS7MIME = "application/pkcs7-mime";
    private static String newPKCS10 = "application/pkcs10";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.SMIMESender";

    public SMIMESender() {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender");
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", (Object)byArray);
        }
        this.contentInfo = new ContentInfo(byArray, this.provider);
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(byte[] byArray, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", byArray, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.contentInfo = new ContentInfo(byArray, this.provider);
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(ContentInfo contentInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", contentInfo);
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(ContentInfo contentInfo, String string) {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", contentInfo, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        this.certRequest = null;
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(CertificationRequest certificationRequest) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", certificationRequest);
        }
        this.contentInfo = null;
        this.certRequest = (CertificationRequest)certificationRequest.clone();
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(CertificationRequest certificationRequest, String string) {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", certificationRequest, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.contentInfo = null;
        this.certRequest = (CertificationRequest)certificationRequest.clone();
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(SMIMEMessage sMIMEMessage) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMESender", sMIMEMessage);
        }
        if (sMIMEMessage == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message must be specified.");
            }
            throw new IOException("message must be specified.");
        }
        byte[] byArray = sMIMEMessage.getContentInfoBytes();
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message does not contain a contentInfo object.");
            }
            throw new IOException("message does not contain a contentInfo object.");
        }
        byArray = sMIMEMessage.getBytes();
        this.contentInfo = new ContentInfo(PKCSOID.DATA_OID, byArray, this.provider);
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public SMIMESender(SMIMEMessage sMIMEMessage, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMESender", sMIMEMessage, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (sMIMEMessage == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message must be specified.");
            }
            throw new IOException("message must be specified.");
        }
        byte[] byArray = sMIMEMessage.getContentInfoBytes();
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "SMIMESender", "message does not contain a contentInfo object.");
            }
            throw new IOException("message does not contain a contentInfo object.");
        }
        byArray = sMIMEMessage.getBytes();
        this.contentInfo = new ContentInfo(PKCSOID.DATA_OID, byArray, this.provider);
        this.recipientCerts = null;
        if (debug != null) {
            debug.exit(16384L, className, "SMIMESender");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            SMIMESender sMIMESender = new SMIMESender(this.provider);
            sMIMESender.oldTypes = this.oldTypes;
            if (this.contentInfo != null) {
                sMIMESender.setContentInfo((ContentInfo)this.contentInfo.clone());
            }
            if (this.certRequest != null) {
                sMIMESender.setCertificationRequest((CertificationRequest)this.certRequest.clone());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", sMIMESender);
            }
            return sMIMESender;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void addRecipientCertificate(Certificate certificate) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addRecipientCertificate", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[1];
            this.recipientCerts[0] = certificate;
        } else {
            int n = this.recipientCerts.length;
            Certificate[] certificateArray = new Certificate[n + 1];
            for (int i = 0; i < n; ++i) {
                certificateArray[i] = this.recipientCerts[i];
            }
            certificateArray[n] = certificate;
            this.recipientCerts = certificateArray;
        }
        if (debug != null) {
            debug.exit(8192L, className, "addRecipientCertificate_2");
        }
    }

    public boolean hasRecipientCertificate() {
        if (debug != null) {
            debug.entry(16384L, className, "hasRecipientCertificate");
            debug.exit(16384L, (Object)className, "hasRecipientCertificate", this.recipientCerts != null && this.recipientCerts.length > 0);
        }
        return this.recipientCerts != null && this.recipientCerts.length > 0;
    }

    public void addRecipientCertificate(Certificate[] certificateArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipientCertificate", certificateArray);
        }
        if (certificateArray == null || certificateArray.length == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                this.recipientCerts[i] = certificateArray[i];
            }
        } else {
            int n;
            int n2 = this.recipientCerts.length;
            Certificate[] certificateArray2 = new Certificate[n2 + certificateArray.length];
            for (n = 0; n < n2; ++n) {
                certificateArray2[n] = this.recipientCerts[n];
            }
            for (n = 0; n < certificateArray.length; ++n) {
                certificateArray2[n2 + n] = certificateArray[n];
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipientCertificate_2");
        }
    }

    private void setRecipientCertificate(Certificate certificate) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setRecipientCertificate", certificate);
        }
        if (certificate == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(8192L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(certificate);
        if (debug != null) {
            debug.exit(8192L, className, "setRecipientCertificate_2");
        }
    }

    public void setRecipientCertificate(Certificate[] certificateArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setRecipientCertificate", certificateArray);
        }
        if (certificateArray == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(16384L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(certificateArray);
        if (debug != null) {
            debug.exit(16384L, className, "setRecipientCertificate_2");
        }
    }

    private void setCertificateOnly(Certificate certificate) throws IOException {
        ContentInfo contentInfo;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCertificateOnly", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(8192L, className, "setCertificateOnly", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        Certificate[] certificateArray = new Certificate[]{certificate};
        SignedData signedData = new SignedData(certificateArray, null, this.provider);
        this.contentInfo = contentInfo = new ContentInfo(signedData, this.provider);
        this.certRequest = null;
        if (debug != null) {
            debug.exit(8192L, className, "setCertificateOnly");
        }
    }

    public void setCertificateOnly(Certificate[] certificateArray) throws IOException, PKCSException {
        ContentInfo contentInfo;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificateOnly", certificateArray);
        }
        if (certificateArray == null || certificateArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "Certificates not specified.");
            }
            throw new IllegalArgumentException("Certificates not specified.");
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        SignedData signedData = new SignedData(certificateArray, null, this.provider);
        this.contentInfo = contentInfo = new ContentInfo(signedData, this.provider);
        this.certRequest = null;
        if (debug != null) {
            debug.exit(16384L, className, "setCertificateOnly");
        }
    }

    public void setContentInfo(ContentInfo contentInfo) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setContentInfo", contentInfo);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setContentInfo", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setContentInfo", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "setContentInfo", "ContentInfo not specified.");
            }
            throw new IllegalArgumentException("ContentInfo not specified.");
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        this.certRequest = null;
        if (debug != null) {
            debug.exit(16384L, className, "setContentInfo");
        }
    }

    public ContentInfo getContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", (ContentInfo)this.contentInfo.clone());
        }
        return (ContentInfo)this.contentInfo.clone();
    }

    public void setCertificationRequest(CertificationRequest certificationRequest) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificationRequest", certificationRequest);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        if (certificationRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "certRequest not specified.");
            }
            throw new IllegalArgumentException("certRequest not specified.");
        }
        this.contentInfo = null;
        this.certRequest = (CertificationRequest)certificationRequest.clone();
        if (debug != null) {
            debug.exit(16384L, className, "setCertificationRequest");
        }
    }

    public CertificationRequest getCertificationRequest() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
            debug.exit(16384L, (Object)className, "getCertificationRequest", this.certRequest);
        }
        return this.certRequest;
    }

    public void setMailhost(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setMailhost", string);
            debug.exit(16384L, className, "setMailhost");
        }
        this.mailhost = string;
    }

    public String getMailhost() {
        if (debug != null) {
            debug.entry(16384L, className, "getMailhost");
            debug.exit(16384L, className, "getMailhost");
        }
        return this.mailhost;
    }

    public void setMessageWithHeader(String string) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setMessageWithHeader", string);
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "setMessageWithHeader", "ContentInfo value already set.");
            }
            throw new PKCSException("ContentInfo value already set.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "setMessageWithHeader", "CertificationRequest value already set.");
            }
            throw new PKCSException("CertificationRequest value already set.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "setMessageWithHeader", "Message not specified.");
            }
            throw new IllegalArgumentException("Message not specified.");
        }
        String string2 = "Content-Type: text/plain; charset=\"us-ascii\"\r\n\r\n";
        String string3 = string2 + string;
        Data data = new Data(this.provider);
        try {
            data.setData(string3.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "setMessageWithHeader", unsupportedEncodingException);
            }
            data.setData(string3.getBytes());
        }
        this.contentInfo = new ContentInfo(data, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "setMessageWithHeader");
        }
    }

    public void setSMIMEContentType(boolean bl) {
        this.oldTypes = bl;
    }

    public boolean getSMIMEContentType() {
        return this.oldTypes;
    }

    public byte[] encrypt(int n) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encrypt", new Integer(n));
        }
        String string = SMIME.getEncryptionAlgorithm(n);
        int n2 = SMIME.getEncryptionKeySize(n);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encrypt", this.encrypt(string, n2));
        }
        return this.encrypt(string, n2);
    }

    public byte[] encrypt(String string, int n) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", string, new Integer(n));
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "ContentInfo must be specified.");
            }
            throw new PKCSException("ContentInfo must be specified.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "CertificationRequest must not be specified.");
            }
            throw new PKCSException("CertificationRequest must not be specified.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "encryptionAlgorithm not specified.");
            }
            throw new IllegalArgumentException("encryptionAlgorithm not specified.");
        }
        if (!this.hasRecipientCertificate()) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "One or more recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("One or more recipient certificates must be specified.");
        }
        if (!this.contentInfo.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
            }
            throw new PKCSException("ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
        }
        this.contentInfo = this.contentInfo.encrypt(this.recipientCerts, string, n);
        String string2 = "smime.p7m";
        String string3 = this.createMessageHeader(string2);
        byte[] byArray = null;
        try {
            byArray = string3.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", unsupportedEncodingException);
            }
            byArray = string3.getBytes();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(this.getBase64Content());
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encrypt", byArray2);
        }
        return byArray2;
    }

    public byte[] sign(Certificate certificate, String string, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] objectArray = new Object[]{certificate, string, privateKey};
            debug.entry(16384L, (Object)className, "sign", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "digestSignatureAlgorithm not specified.");
            }
            throw new IllegalArgumentException("digestSignatureAlgorithm not specified.");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "ContentInfo must be specified.");
            }
            throw new PKCSException("ContentInfo must be specified.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "CertificationRequest must not be specified.");
            }
            throw new PKCSException("CertificationRequest must not be specified.");
        }
        if (!this.contentInfo.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
            }
            throw new PKCSException("ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
        }
        boolean bl = false;
        this.contentInfo = this.contentInfo.sign(certificate, string, privateKey, bl);
        String string2 = "smime.p7m";
        String string3 = this.createMessageHeader(string2);
        byte[] byArray = null;
        try {
            byArray = string3.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", unsupportedEncodingException);
            }
            byArray = string3.getBytes();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(this.getBase64Content());
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", byArray2);
        }
        return byArray2;
    }

    public byte[] signSignatureOnly(Certificate certificate, String string, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        return this.signSignatureOnly(certificate, string, privateKey, true);
    }

    public byte[] signSignatureOnly(Certificate certificate, String string, PrivateKey privateKey, boolean bl) throws PKCSException, IOException, NoSuchAlgorithmException {
        ContentInfo contentInfo;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificate, string, privateKey};
            debug.entry(16384L, (Object)className, "signSignatureOnly", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "digestSignatureAlgorithm must be specified.");
            }
            throw new IllegalArgumentException("digestSignatureAlgorithm must be specified.");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "ContentInfo must be specified.");
            }
            throw new PKCSException("ContentInfo must be specified.");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "CertificationRequest must not be specified.");
            }
            throw new PKCSException("CertificationRequest must not be specified.");
        }
        if (!this.contentInfo.isData()) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
            }
            throw new PKCSException("ContentInfo must be of the Data type.  Instead it is of type " + this.contentInfo.getContentTypeString() + ".");
        }
        objectArray = (Data)this.contentInfo.getContent();
        boolean bl2 = false;
        SignedData signedData = new SignedData(certificate, this.contentInfo, string, privateKey, bl2, this.provider);
        signedData.removeContent();
        this.contentInfo = contentInfo = new ContentInfo(signedData, this.provider);
        String string2 = "smime.p7s";
        String string3 = this.createBoundary();
        String string4 = "\r\n--" + string3 + "\r\n";
        byte[] byArray = null;
        try {
            byArray = string4.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", unsupportedEncodingException);
            }
            byArray = string4.getBytes();
        }
        String string5 = PKCS7.getDigestAlgorithm(string);
        String string6 = this.createMultipartMessageHeader(string5, string3);
        if (bl) {
            string6 = string6 + "This is a cryptographically signed message in MIME format.\r\n";
        }
        byte[] byArray2 = null;
        try {
            byArray2 = string6.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", unsupportedEncodingException);
            }
            byArray2 = string6.getBytes();
        }
        String string7 = this.createMultipartMessageFileHeader(string2);
        byte[] byArray3 = null;
        try {
            byArray3 = string7.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", unsupportedEncodingException);
            }
            byArray3 = string7.getBytes();
        }
        String string8 = "\r\n--" + string3 + "--\r\n";
        byte[] byArray4 = null;
        try {
            byArray4 = string8.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "signSignatureOnly", unsupportedEncodingException);
            }
            byArray4 = string8.getBytes();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(objectArray.getData());
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(this.getBase64Content());
        byteArrayOutputStream.write(byArray4);
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "signSignatureOnly", byArray5);
        }
        return byArray5;
    }

    private String createBoundary() {
        if (debug != null) {
            debug.entry(8192L, className, "createBoundary");
        }
        Calendar calendar = Calendar.getInstance();
        long l = calendar.get(13);
        long l2 = calendar.get(14);
        String string = "----boundary" + l + l2 + msgcounter++;
        if (debug != null) {
            debug.exit(8192L, (Object)className, "createBoundary", string);
        }
        return string;
    }

    public byte[] getBase64Content() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getBase64Content");
        }
        if (this.contentInfo != null) {
            this.contentInfo.encode(derOutputStream);
        } else {
            this.certRequest.encode(derOutputStream);
        }
        byte[] byArray = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getBase64Content", this.getBase64(byArray));
        }
        return this.getBase64(byArray);
    }

    private byte[] getBase64(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getBase64", (Object)byArray);
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        bASE64Encoder.encode(byArray, (OutputStream)byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getBase64", byArray2);
        }
        return byArray2;
    }

    private String createMultipartMessageHeader(String string, String string2) {
        String string3 = string;
        if (debug != null) {
            debug.entry(8192L, className, "createMultipartMessageHeader", string, string2);
        }
        if (string3.equalsIgnoreCase("md5")) {
            string3 = "md5";
        } else if (string3.equalsIgnoreCase("sha") || string3.equalsIgnoreCase("sha1") || string3.equalsIgnoreCase("sha-1")) {
            string3 = "sha1";
        }
        String string4 = "Content-Type: multipart/signed;";
        string4 = this.oldTypes ? string4 + " protocol=\"" + oldPKCS7Signature + "\";" : string4 + " protocol=\"" + newPKCS7Signature + "\";";
        string4 = string4 + " micalg=" + string3 + ";" + " boundary=\"" + string2 + "\"\r\n";
        string4 = string4 + "\r\n";
        if (debug != null) {
            debug.exit(8192L, (Object)className, "createMultipartMessageHeader", string4);
        }
        return string4;
    }

    private String createMultipartMessageFileHeader(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "createMultipartMessageFileHeader", string);
        }
        String string2 = "Content-Type: ";
        string2 = this.oldTypes ? string2 + oldPKCS7Signature + ";" : string2 + newPKCS7Signature + ";";
        string2 = string2 + " name=\"" + string + "\"\r\n";
        string2 = string2 + "Content-Transfer-Encoding: base64\r\n";
        string2 = string2 + "Content-Disposition: attachment; filename=\"" + string + "\"\r\n";
        if (string.equals("smime.p7s")) {
            string2 = string2 + "Content-Description: S/MIME Cryptographic Signature\r\n";
        }
        string2 = string2 + "\r\n";
        if (debug != null) {
            debug.exit(8192L, (Object)className, "createMultipartMessageFileHeader", string2);
        }
        return string2;
    }

    private String createMessageHeader(String string) {
        String string2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "createMessageHeader", string);
        }
        if (this.certRequest != null) {
            string2 = "Content-Type: ";
            string2 = this.oldTypes ? string2 + oldPKCS10 + "; name=" + string + "\r\n" : string2 + newPKCS10 + "; name=" + string + "\r\n";
            string2 = string2 + "Content-Transfer-Encoding: base64\r\n";
            string2 = string2 + "Content-Disposition: attachment; filename=" + string + "\r\n";
        } else {
            String string3 = this.getSMIMEType();
            string2 = "Content-Type: ";
            string2 = this.oldTypes ? string2 + oldPKCS7MIME + ";" : string2 + newPKCS7MIME + ";";
            string2 = string2 + " smime-type=";
            string2 = string2 + string3;
            string2 = string2 + ";";
            string2 = string2 + " name=\"";
            string2 = string2 + string;
            string2 = string2 + "\"\r\n";
            string2 = string2 + "Content-Transfer-Encoding: base64\r\n";
            string2 = string2 + "Content-Disposition: attachment; filename=\"" + string + "\"\r\n";
            if (this.contentInfo.isEnvelopedData()) {
                string2 = string2 + "Content-Description: S/MIME Encrypted Message\r\n";
            }
        }
        string2 = string2 + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "createMessageHeader", string2);
        }
        return string2;
    }

    public String getSMIMEType() {
        if (debug != null) {
            debug.entry(16384L, className, "getSMIMEType");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSMIMEType_1", null);
            }
            return null;
        }
        if (this.contentInfo.isSignedData()) {
            SignedData signedData = (SignedData)this.contentInfo.getContent();
            if (signedData.hasCertificatesOnly()) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getSMIMEType_2", "certs-only");
                }
                return "certs-only";
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSMIMEType_3", "signed-data");
            }
            return "signed-data";
        }
        if (this.contentInfo.isEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSMIMEType_4", "enveloped-data");
            }
            return "enveloped-data";
        }
        if (debug != null) {
            debug.text(16384L, className, "getSMIMEType", "Unknown/Unsupported smime-type for ContentInfo of type " + this.contentInfo.getContentTypeString());
        }
        throw new IllegalArgumentException("Unknown/Unsupported smime-type for ContentInfo of type " + this.contentInfo.getContentTypeString());
    }

    public String getFileName() {
        if (debug != null) {
            debug.entry(16384L, className, "getFileName");
        }
        if (this.certRequest != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFileName_1", "smime.p10");
            }
            return "smime.p10";
        }
        if (this.contentInfo.isSignedData()) {
            SignedData signedData = (SignedData)this.contentInfo.getContent();
            if (!signedData.hasSignerInfos()) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getFileName_2", "smime.p7c");
                }
                return "smime.p7c";
            }
            if (!signedData.hasContent()) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getFileName_3", "smime.p7s");
                }
                return "smime.p7s";
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFileName_4", "smime.p7m");
            }
            return "smime.p7m";
        }
        if (this.contentInfo.isEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFileName_5", "smime.p7m");
            }
            return "smime.p7m";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getFileName_6", "smime.dat");
        }
        return "smime.dat";
    }

    private Vector getEmailAddress(String string, byte[] byArray) throws PKCSException, IOException {
        ContentInfo contentInfo = null;
        if (debug != null) {
            debug.entry(8192L, className, "getEmailAddress", string, byArray);
        }
        if (byArray != null) {
            SMIMEMessage sMIMEMessage = new SMIMEMessage(byArray, this.provider);
            contentInfo = sMIMEMessage.getContentInfo();
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getEmailAddress", this.getEmailAddress(string, contentInfo));
        }
        return this.getEmailAddress(string, contentInfo);
    }

    private Vector getEmailAddress(String string, ContentInfo contentInfo) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getEmailAddress", string, contentInfo);
        }
        Vector<String> vector = new Vector<String>();
        boolean bl = contentInfo != null && contentInfo.isEnvelopedData();
        boolean bl2 = false;
        int n = 0;
        if (this.recipientCerts != null) {
            n = this.recipientCerts.length;
        }
        for (int i = 0; i < n; ++i) {
            Certificate certificate = this.recipientCerts[i];
            String string2 = this.getEmailAddress(certificate);
            if (string2 == null) continue;
            vector.add(string2);
            if (string == null || !string.equalsIgnoreCase(string2)) continue;
            bl2 = true;
        }
        if (string != null && !bl2 && !bl) {
            vector.add(string);
            bl2 = true;
        }
        if (string == null || bl2) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEmailAddress", vector);
            }
            return vector;
        }
        if (debug != null) {
            debug.text(8192L, className, "getEmailAddress", "Could not find " + string + " in the e-mail addresses for the certificates stored with this EnvelopedData object.");
        }
        throw new PKCSException("Could not find " + string + " in the e-mail addresses for the certificates stored with this EnvelopedData object.");
    }

    private String getEmailAddress(Certificate certificate) throws PKCSException, IOException {
        GeneralName generalName;
        String string;
        block22: {
            GeneralNames generalNames;
            block21: {
                Object object;
                byte[] byArray;
                block20: {
                    string = null;
                    if (debug != null) {
                        debug.entry(8192L, (Object)className, "getEmailAddress", certificate);
                    }
                    if (certificate == null) {
                        if (debug != null) {
                            debug.exit(8192L, (Object)className, "getEmailAddress_1", string);
                        }
                        return string;
                    }
                    if (!(certificate instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(8192L, className, "getEmailAddress", "cert must be of type X509Certificate");
                        }
                        throw new PKCSException("cert must be of type X509Certificate");
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    X500Name x500Name = new X500Name(x509Certificate.getSubjectDN().getName());
                    string = x500Name.getEmail();
                    if (string != null) {
                        if (debug != null) {
                            debug.exit(8192L, (Object)className, "getEmailAddress_2", string);
                        }
                        return string;
                    }
                    byArray = null;
                    try {
                        object = (X509CertImpl)certificate;
                        byArray = ((X509CertImpl)object).getExtensionValue("2.5.29.17");
                    }
                    catch (Exception exception) {
                        if (debug == null) break block20;
                        debug.exception(8192L, className, "getEmailAddress", exception);
                    }
                }
                if (byArray == null) {
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "getEmailAddress_3", string);
                    }
                    return string;
                }
                object = new DerValue(byArray);
                generalNames = null;
                try {
                    generalNames = new GeneralNames((DerValue)object);
                }
                catch (GeneralNamesException generalNamesException) {
                    if (debug == null) break block21;
                    debug.exception(8192L, className, "getEmailAddress", generalNamesException);
                }
            }
            if (generalNames == null) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "getEmailAddress_4", string);
                }
                return string;
            }
            generalName = null;
            try {
                generalName = generalNames.getGeneralName(1);
            }
            catch (GeneralNamesException generalNamesException) {
                if (debug == null) break block22;
                debug.exception(8192L, className, "getEmailAddress", generalNamesException);
            }
        }
        if (generalName == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEmailAddress_5", string);
            }
            return string;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getEmailAddress_6", generalName.toString());
        }
        return generalName.toString();
    }

    public void mail(String string, String string2, String string3) throws PKCSException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{string, string2, string3};
            debug.entry(16384L, (Object)className, "mail", objectArray);
        }
        if (this.mailhost == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "mailhost must be specified.");
            }
            throw new PKCSException("mailhost must be specified.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (this.contentInfo == null && this.certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "ContentInfo or CertificationRequest must be specified.");
            }
            throw new PKCSException("ContentInfo or CertificationRequest must be specified.");
        }
        if (!this.hasRecipientCertificate() && string2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        objectArray = this.getBase64Content();
        String string4 = this.getFileName();
        Vector vector = this.getEmailAddress(string2, this.contentInfo);
        if (vector == null || vector.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            Socket socket = new Socket(this.mailhost, 25);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("HELO " + this.mailhost);
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("MAIL FROM:<" + string + ">");
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("RCPT TO:<" + string5 + ">");
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("DATA");
            this.checkSMTPReturn(bufferedReader);
            String string6 = this.getMailHeader(string, string5, string3);
            printWriter.print(string6);
            printWriter.print(this.createMessageHeader(string4));
            try {
                printWriter.write(new String((byte[])objectArray, "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "mail", unsupportedEncodingException);
                }
                printWriter.write(new String((byte[])objectArray));
            }
            printWriter.println();
            printWriter.println(".");
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("QUIT");
            this.checkSMTPReturn(bufferedReader);
            printWriter.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "mail");
        }
    }

    public void mail(byte[] byArray, String string, String string2, String string3) throws PKCSException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, string, string2, string3};
            debug.entry(16384L, (Object)className, "mail", objectArray);
        }
        if (this.mailhost == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "mailhost must be specified.");
            }
            throw new PKCSException("mailhost must be specified.");
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "message must be specified.");
            }
            throw new IllegalArgumentException("message must be specified.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (!this.hasRecipientCertificate() && string2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        objectArray = this.getEmailAddress(string2, byArray);
        if (objectArray == null || objectArray.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "mail", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration enumeration = objectArray.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            Socket socket = new Socket(this.mailhost, 25);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("HELO " + this.mailhost);
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("MAIL FROM:<" + string + ">");
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("RCPT TO:<" + string4 + ">");
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("DATA");
            this.checkSMTPReturn(bufferedReader);
            String string5 = this.getMailHeader(string, string4, string3);
            printWriter.print(string5);
            try {
                printWriter.write(new String(byArray, "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "mail", unsupportedEncodingException);
                }
                printWriter.write(new String(byArray));
            }
            printWriter.println();
            printWriter.println(".");
            this.checkSMTPReturn(bufferedReader);
            printWriter.println("QUIT");
            this.checkSMTPReturn(bufferedReader);
            printWriter.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "mail");
        }
    }

    private void checkSMTPReturn(BufferedReader bufferedReader) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "checkSMTPReturn", bufferedReader);
        }
        String string = bufferedReader.readLine();
        if (debug != null) {
            debug.exit(8192L, className, "checkSMTPReturn");
        }
    }

    private String getMailHeader(String string, String string2, String string3) {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{string, string2, string3};
            debug.entry(8192L, (Object)className, "getMailHeader", objectArray);
        }
        objectArray = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String string4 = simpleDateFormat.format((Date)objectArray);
        String string5 = new String();
        string5 = string5 + "Date: " + string4 + "\r\n";
        string5 = string5 + "From: <" + string + ">\r\n";
        string5 = string5 + "X-Mailer: IBM Security Software Development Kit SMIMESender\r\n";
        string5 = string5 + "X-Accept-Language: en\r\n";
        string5 = string5 + "MIME-Version: 1.0\r\n";
        string5 = string5 + "To: <" + string2 + ">\r\n";
        if (string3 != null) {
            string5 = string5 + "Subject: " + string3 + "\r\n";
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getMailHeader", string5);
        }
        return string5;
    }

    public void writeMailToFile(String string, String string2, String string3, String string4) throws PKCSException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{string, string2, string3, string4};
            debug.entry(16384L, (Object)className, "writeMailToFile", objectArray);
        }
        if (string2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (!this.hasRecipientCertificate() && string3 == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "filename must be specified.");
            }
            throw new IllegalArgumentException("filename must be specified.");
        }
        if (this.contentInfo == null && this.certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "ContentInfo or CertificationRequest must be specified.");
            }
            throw new PKCSException("ContentInfo or CertificationRequest must be specified.");
        }
        objectArray = this.getBase64Content();
        String string5 = this.getFileName();
        Vector vector = this.getEmailAddress(string3, this.contentInfo);
        if (vector == null || vector.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            String string7 = this.getMailHeader(string2, string6, string4);
            string7 = string7 + this.createMessageHeader(string5);
            byte[] byArray = null;
            try {
                byArray = string7.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "writeMailToFile", unsupportedEncodingException);
                }
                byArray = string7.getBytes();
            }
            FileOutputStream fileOutputStream = null;
            fileOutputStream = vector.size() == 1 ? new FileOutputStream(string) : new FileOutputStream(string + "." + n++);
            fileOutputStream.write(byArray);
            fileOutputStream.write((byte[])objectArray);
            fileOutputStream.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeMailToFile");
        }
    }

    public void writeMailToFile(byte[] byArray, String string, String string2, String string3, String string4) throws PKCSException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, string, string2, string3, string4};
            debug.entry(16384L, (Object)className, "writeMailToFile", objectArray);
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "message must be specified.");
            }
            throw new IllegalArgumentException("message must be specified.");
        }
        if (string2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "senderAddress must be specified.");
            }
            throw new IllegalArgumentException("senderAddress must be specified.");
        }
        if (!this.hasRecipientCertificate() && string3 == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "recipientAddress or recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("recipientAddress or recipient certificates must be specified.");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "filename must be specified.");
            }
            throw new IllegalArgumentException("filename must be specified.");
        }
        objectArray = this.getEmailAddress(string3, byArray);
        if (objectArray == null || objectArray.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, className, "writeMailToFile", "No recipientAddresses found to mail.");
            }
            throw new PKCSException("No recipientAddresses found to mail.");
        }
        Enumeration enumeration = objectArray.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            String string6 = this.getMailHeader(string2, string3, string4);
            byte[] byArray2 = null;
            try {
                byArray2 = string6.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "writeMailToFile", unsupportedEncodingException);
                }
                byArray2 = string6.getBytes();
            }
            FileOutputStream fileOutputStream = null;
            fileOutputStream = objectArray.size() == 1 ? new FileOutputStream(string) : new FileOutputStream(string + "." + n++);
            fileOutputStream.write(byArray2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeMailToFile");
        }
    }

    public String toString() {
        String string = "SMIMESender ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.certRequest != null) {
            string = string + "PKCS #10:\r\n";
            string = string + this.certRequest;
        } else if (this.contentInfo != null) {
            string = string + "PKCS #7:\r\n";
            string = string + this.contentInfo;
        } else {
            string = string + ": ContentInfo or CertificationRequest object not set.";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

