/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PublicKeyAndChallenge;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;

public final class SignedPublicKeyAndChallenge
extends PKCSDerObject {
    private PublicKeyAndChallenge pkac;
    private AlgorithmId signatureAlgorithm;
    private byte[] signature;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.SignedPublicKeyAndChallenge";
    private volatile int cachedHashVal = 0;

    public SignedPublicKeyAndChallenge(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignedPublicKeyAndChallenge", (Object)byArray);
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    public SignedPublicKeyAndChallenge(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "SignedPublicKeyAndChallenge", byArray, string);
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    public SignedPublicKeyAndChallenge(PublicKeyAndChallenge publicKeyAndChallenge, String string, PrivateKey privateKey) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (debug != null) {
            Object[] objectArray = new Object[]{publicKeyAndChallenge, string, privateKey};
            debug.entry(16384L, (Object)className, "SignedPublicKeyAndChallenge", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "signatureAlgorithm not specified.");
            }
            throw new IllegalArgumentException("signatureAlgorithm not specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "privateKey not specified.");
            }
            throw new IllegalArgumentException("privateKey not specified.");
        }
        this.pkac = publicKeyAndChallenge;
        this.setSignatureAlgorithm(string);
        this.sign(privateKey);
        if (debug != null) {
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    public SignedPublicKeyAndChallenge(PublicKeyAndChallenge publicKeyAndChallenge, String string, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{publicKeyAndChallenge, string, privateKey, string2};
            debug.entry(16384L, (Object)className, "SignedPublicKeyAndChallenge", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "signatureAlgorithm not specified.");
            }
            throw new IllegalArgumentException("signatureAlgorithm not specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignedPublicKeyAndChallenge", "privateKey not specified.");
            }
            throw new IllegalArgumentException("privateKey not specified.");
        }
        this.pkac = publicKeyAndChallenge;
        this.setSignatureAlgorithm(string);
        this.sign(privateKey);
        if (debug != null) {
            debug.exit(16384L, className, "SignedPublicKeyAndChallenge");
        }
    }

    private void setSignatureAlgorithm(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureAlgorithm", string);
        }
        this.signatureAlgorithm = AlgorithmId.get(string);
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureAlgorithm");
        }
    }

    public AlgorithmId getSignatureAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithm");
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignatureAlgorithm_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm_2", new AlgorithmId(this.signatureAlgorithm.getOID(), this.signatureAlgorithm.getParameters(), this.provider));
        }
        return new AlgorithmId(this.signatureAlgorithm.getOID(), this.signatureAlgorithm.getParameters(), this.provider);
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature_2", (byte[])this.signature.clone());
        }
        return (byte[])this.signature.clone();
    }

    public PublicKeyAndChallenge getPublicKeyAndChallenge() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKeyAndChallenge");
            debug.exit(16384L, (Object)className, "getPublicKeyAndChallenge", this.pkac);
        }
        return this.pkac;
    }

    private void sign(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "sign", privateKey);
        }
        Signature signature = Signature.getInstance(this.signatureAlgorithm.getOID().toString());
        signature.initSign(privateKey);
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.pkac.encode(derOutputStream);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(8192L, className, "sign", iOException);
            }
            throw new SignatureException("Could not encode the PublicKeyAndChallenge for signing.");
        }
        signature.update(derOutputStream.toByteArray());
        this.signature = signature.sign();
        if (debug != null) {
            debug.exit(8192L, className, "sign");
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "verify");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_1", false);
            }
            return false;
        }
        Signature signature = Signature.getInstance(this.signatureAlgorithm.getOID().toString());
        signature.initVerify(this.pkac.getSubjectPublicKeyInfo());
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.pkac.encode(derOutputStream);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", iOException);
            }
            throw new SignatureException("Could not encode the PublicKeyAndChallenge.");
        }
        signature.update(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify_2", signature.verify(this.signature));
        }
        return signature.verify(this.signature);
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.pkac.encode(derOutputStream);
        this.signatureAlgorithm.encode(derOutputStream);
        if (this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "signature not generated");
            }
            throw new IOException("signature not generated");
        }
        derOutputStream.putBitString(this.signature);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, not a SEQUENCE");
            }
            throw new IOException("parsing error, not a SEQUENCE");
        }
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing PublicKeyAndChallenge data");
            }
            throw new IOException("parsing error, missing PublicKeyAndChallenge data");
        }
        this.pkac = new PublicKeyAndChallenge(derValue.getData().getDerValue().toByteArray(), this.provider);
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "missing signature algorithm data");
            }
            throw new IOException("missing signature algorithm data");
        }
        this.signatureAlgorithm = new AlgorithmId(derValue.getData().getDerValue(), this.provider);
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing signature data");
            }
            throw new IOException("parsing error, missing signature data");
        }
        this.signature = derValue.getData().getBitString();
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, data overrun");
            }
            throw new IOException("parsing error, data overrun");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        if (!(object instanceof SignedPublicKeyAndChallenge)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((SignedPublicKeyAndChallenge)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        String string = "SignedPublicKeyAndChallenge:";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.pkac != null) {
            string = string + "\r\n\t" + this.pkac.toString();
        }
        if (this.signatureAlgorithm != null) {
            string = string + "\r\n\tsignatureAlgorithm: " + this.signatureAlgorithm.toString();
        }
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        if (this.signature != null) {
            string = string + "\r\n\tsignature: " + hexDumpEncoder.encodeBuffer(this.signature);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            this.encode(derOutputStream);
            SignedPublicKeyAndChallenge signedPublicKeyAndChallenge = new SignedPublicKeyAndChallenge(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", signedPublicKeyAndChallenge);
            }
            return signedPublicKeyAndChallenge;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone_2", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }
}

