/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.io.OutputStream;

class ESSCertID {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ESSCertID";
    private static BASE64Encoder b64Encoder = new BASE64Encoder();
    private byte[] certHash;
    private GeneralNames issuer;
    private CertificateSerialNumber serialNumber;

    public ESSCertID(DerValue derValue) throws IOException {
        this.certHash = derValue.getData().getDerValue().getOctetString();
        if (derValue.getData().available() > 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            try {
                this.issuer = new GeneralNames(derValue2.getData().getDerValue());
            }
            catch (GeneralNamesException generalNamesException) {
                throw new IOException(generalNamesException.getMessage());
            }
            this.serialNumber = new CertificateSerialNumber(derValue2.getData().getDerValue());
        }
    }

    public ESSCertID(byte[] byArray, SerialNumber serialNumber, GeneralNames generalNames) {
        this.certHash = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.certHash, 0, byArray.length);
        if (serialNumber != null && generalNames != null) {
            this.serialNumber = new CertificateSerialNumber(serialNumber.getNumber());
            this.issuer = new GeneralNames();
            this.issuer.addAll(generalNames);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.certHash == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "certHash object not specified.");
            }
            throw new IOException("certHash object not specified.");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.certHash);
        if (this.issuer != null && this.serialNumber != null) {
            derOutputStream = new DerOutputStream();
            try {
                this.issuer.encode(derOutputStream);
            }
            catch (GeneralNamesException generalNamesException) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "encode", outputStream);
                }
                throw new IOException(generalNamesException.getMessage());
            }
            this.serialNumber.encode(derOutputStream);
            derOutputStream2.write((byte)48, derOutputStream);
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", outputStream);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n\tCertificate hash (SHA-1):\n");
        stringBuffer.append(b64Encoder.encode(this.certHash));
        if (this.issuer != null && this.serialNumber != null) {
            stringBuffer.append("\n\tIssuer: " + this.issuer + "\n");
            stringBuffer.append("\t" + this.serialNumber);
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public SerialNumber getSerialNumber() throws IOException {
        return (SerialNumber)this.serialNumber.get("number");
    }
}

