/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UserKeyingMaterial
extends PKCSDerObject
implements Cloneable {
    private AlgorithmId algorithm;
    private byte[] ukm;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.UserKeyingMaterial";
    private volatile int cachedHashVal = 0;

    public UserKeyingMaterial(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UserKeyingMaterial", (Object)byArray);
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", byArray, string);
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(AlgorithmId algorithmId, byte[] byArray) {
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", algorithmId, byArray);
        }
        this.algorithm = algorithmId;
        this.ukm = byArray;
        if (debug != null) {
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(AlgorithmId algorithmId, byte[] byArray, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", byArray, string);
        }
        this.algorithm = algorithmId;
        this.ukm = byArray;
        if (debug != null) {
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "UserKeyingMaterial", string, new Boolean(bl));
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public UserKeyingMaterial(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "UserKeyingMaterial", objectArray);
            debug.exit(16384L, className, "UserKeyingMaterial");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.algorithm.encode(derOutputStream);
        derOutputStream.putOctetString(this.ukm);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "UserKeyingMaterial parsing error");
            }
            throw new IOException("UserKeyingMaterial parsing error");
        }
        this.algorithm = AlgorithmId.parse(derValue.getData().getDerValue());
        this.ukm = derValue.getData().getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public AlgorithmId getKeyEncryptionAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyEncryptionAlgorithm");
        }
        if (this.algorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyEncryptionAlgorithm", null);
            }
            return null;
        }
        AlgorithmId algorithmId = new AlgorithmId(this.algorithm.getOID(), this.algorithm.getParameters());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getKeyEncryptionAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    public byte[] getUserKeyringMaterial() {
        if (debug != null) {
            debug.entry(16384L, className, "getUserKeyringMaterial");
        }
        if (this.ukm == null || this.ukm.length == 0) {
            debug.exit(16384L, (Object)className, "getUserKeyringMaterial", null);
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUserKeyringMaterial", this.ukm.clone());
        }
        return (byte[])this.ukm.clone();
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof UserKeyingMaterial)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((UserKeyingMaterial)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            UserKeyingMaterial userKeyingMaterial = new UserKeyingMaterial(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", userKeyingMaterial);
            }
            return userKeyingMaterial;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "";
        string = string + "\talgorithm: " + this.algorithm;
        string = string + "\r\n\tukm: \r\n" + hexDumpEncoder.encodeBuffer(this.ukm) + "\r\n";
        return string;
    }
}

