/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.RecipientInfo;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class SignedAndEnvelopedData
extends Content
implements Cloneable {
    private static final byte TAG_CERTS = 0;
    private static final byte TAG_CRLS = 1;
    private BigInteger version;
    private RecipientInfo[] recipientInfos;
    private AlgorithmId[] digestAlgorithms;
    private EncryptedContentInfo encryptedContentInfo;
    private Certificate[] certs;
    private CRL[] crls;
    private SignerInfo[] signers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignedAndEnvelopedData";
    private volatile int cachedHashVal = 0;

    public SignedAndEnvelopedData(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", (Object)byArray);
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "SignedAndEnvelopedData", byArray, string);
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(RecipientInfo[] recipientInfoArray, AlgorithmId[] algorithmIdArray, EncryptedContentInfo encryptedContentInfo, X509Certificate[] x509CertificateArray, X509CRL[] x509CRLArray, SignerInfo[] signerInfoArray) {
        if (debug != null) {
            Object[] objectArray = new Object[]{recipientInfoArray, algorithmIdArray, encryptedContentInfo, x509CertificateArray, x509CRLArray, signerInfoArray};
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", objectArray);
        }
        this.recipientInfos = recipientInfoArray;
        this.digestAlgorithms = algorithmIdArray;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certs = x509CertificateArray;
        this.crls = x509CRLArray;
        this.signers = signerInfoArray;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(RecipientInfo[] recipientInfoArray, AlgorithmId[] algorithmIdArray, EncryptedContentInfo encryptedContentInfo, X509Certificate[] x509CertificateArray, X509CRL[] x509CRLArray, SignerInfo[] signerInfoArray, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{recipientInfoArray, algorithmIdArray, encryptedContentInfo, x509CertificateArray, x509CRLArray, signerInfoArray, string};
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", objectArray);
        }
        this.recipientInfos = recipientInfoArray;
        this.digestAlgorithms = algorithmIdArray;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certs = x509CertificateArray;
        this.crls = x509CRLArray;
        this.signers = signerInfoArray;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SignedAndEnvelopedData", string, new Boolean(bl));
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public SignedAndEnvelopedData(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SignedAndEnvelopedData", objectArray);
            debug.exit(16384L, className, "SignedAndEnvelopedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SignedAndEnvelopedData signedAndEnvelopedData = new SignedAndEnvelopedData(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", signedAndEnvelopedData);
            }
            return signedAndEnvelopedData;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID);
        }
        return PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public RecipientInfo[] getRecipientInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfos");
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfos", null);
            }
            return null;
        }
        RecipientInfo[] recipientInfoArray = (RecipientInfo[])this.recipientInfos.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfos", recipientInfoArray);
        }
        return recipientInfoArray;
    }

    public AlgorithmId[] getDigestAlgorithms() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithms");
        }
        if (this.digestAlgorithms == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithms", null);
            }
            return null;
        }
        AlgorithmId[] algorithmIdArray = (AlgorithmId[])this.digestAlgorithms.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithms", algorithmIdArray);
        }
        return algorithmIdArray;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContentInfo");
        }
        if (this.encryptedContentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptedContentInfo", null);
            }
            return null;
        }
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)this.encryptedContentInfo.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedContentInfo", encryptedContentInfo);
        }
        return encryptedContentInfo;
    }

    public Certificate[] getCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificates");
        }
        if (this.certs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates", null);
            }
            return null;
        }
        Certificate[] certificateArray = (Certificate[])this.certs.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates", certificateArray);
        }
        return certificateArray;
    }

    public CRL[] getCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCRLs");
        }
        if (this.crls == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs", null);
            }
            return null;
        }
        CRL[] cRLArray = (CRL[])this.crls.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs", cRLArray);
        }
        return cRLArray;
    }

    public SignerInfo[] getSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerInfos");
        }
        SignerInfo[] signerInfoArray = null;
        if (this.signers != null) {
            signerInfoArray = (SignerInfo[])this.signers.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfos", signerInfoArray);
        }
        return signerInfoArray;
    }

    public SignerInfo getSignerInfo(Certificate certificate) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignerInfo", certificate);
        }
        if (this.signers == null || certificate == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignerInfo_1", null);
            }
            return null;
        }
        for (int i = 0; i < this.signers.length; ++i) {
            if (!this.signers[i].hasCertificate(certificate)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignerInfo_2", this.signers[i].clone());
            }
            return (SignerInfo)this.signers[i].clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerInfo", null);
        }
        return null;
    }

    public Certificate getCertificate(IssuerAndSerialNumber issuerAndSerialNumber) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertificate", issuerAndSerialNumber);
        }
        if (this.certs == null || issuerAndSerialNumber == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificate_1", null);
            }
            return null;
        }
        for (int i = 0; i < this.certs.length; ++i) {
            BigInteger bigInteger;
            X509Certificate x509Certificate = (X509Certificate)this.certs[i];
            Principal principal = x509Certificate.getIssuerDN();
            X500Name x500Name = new X500Name(principal.getName());
            if (!x500Name.equals(issuerAndSerialNumber.getIssuer()) || (bigInteger = x509Certificate.getSerialNumber()).equals(issuerAndSerialNumber.getSerialNumber())) continue;
            try {
                byte[] byArray = this.certs[i].getEncoded();
                X509CertImpl x509CertImpl = new X509CertImpl(byArray);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getCertificate_1", x509CertImpl);
                }
                return x509CertImpl;
            }
            catch (CertificateException certificateException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getCertificate", certificateException);
                }
                throw new IOException(certificateException.toString());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificate", null);
        }
        return null;
    }

    public boolean hasCertificate(Certificate certificate) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasCertificate", certificate);
        }
        boolean bl = false;
        if (this.certs != null && certificate != null) {
            for (int i = 0; i < this.certs.length; ++i) {
                if (!certificate.equals(this.certs[i])) continue;
                bl = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificate", bl);
        }
        return bl;
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n;
        DerEncoder[] derEncoderArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        if (this.recipientInfos != null && this.recipientInfos.length > 0) {
            derEncoderArray = new DerOutputStream[this.recipientInfos.length];
            for (n = 0; n < this.recipientInfos.length; ++n) {
                derEncoderArray[n] = new DerOutputStream();
                this.recipientInfos[n].encode((OutputStream)((Object)derEncoderArray[n]));
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding recipientInfos.");
            }
            throw new IOException("Error encoding recipientInfos.");
        }
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        if (this.digestAlgorithms != null && this.digestAlgorithms.length > 0) {
            derEncoderArray = new DerOutputStream[this.digestAlgorithms.length];
            for (n = 0; n < this.digestAlgorithms.length; ++n) {
                derEncoderArray[n] = new DerOutputStream();
                this.digestAlgorithms[n].encode((DerOutputStream)derEncoderArray[n]);
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding digest algorithms.");
            }
            throw new IOException("Error encoding digest algorithms.");
        }
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        this.encryptedContentInfo.encode(derOutputStream);
        try {
            if (this.certs != null && this.certs.length > 0) {
                derEncoderArray = new DerOutputStream[this.certs.length];
                for (n = 0; n < this.certs.length; ++n) {
                    if (!(this.certs[n] instanceof X509Certificate)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element certs[" + n + "] has a type of " + this.certs[n].getClass().getName() + ".  Only instances of java.security.cert.X509Certificate are supported.");
                        }
                        throw new IOException("Element certs[" + n + "] has a type of " + this.certs[n].getClass().getName() + ".  Only instances of java.security.cert.X509Certificate are supported.");
                    }
                    derEncoderArray[n] = new DerOutputStream();
                    ((OutputStream)((Object)derEncoderArray[n])).write(this.certs[n].getEncoded());
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putOrderedSetOf((byte)49, derEncoderArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding certificates.  " + certificateEncodingException.toString());
            }
            throw new IOException("Error encoding certificates.  " + certificateEncodingException.toString());
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                derEncoderArray = new DerOutputStream[this.crls.length];
                for (int i = 0; i < this.crls.length; ++i) {
                    if (!(this.crls[i] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of java.security.cert.X509CRL are supported.");
                    }
                    derEncoderArray[i] = new DerOutputStream();
                    X509CRL x509CRL = (X509CRL)this.crls[i];
                    ((OutputStream)((Object)derEncoderArray[i])).write(x509CRL.getEncoded());
                }
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.putOrderedSetOf((byte)49, derEncoderArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream4);
            }
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding crls.  " + cRLException.toString());
            }
            throw new IOException("Error encoding crls.  " + cRLException.toString());
        }
        if (this.signers != null && this.signers.length > 0) {
            derEncoderArray = new DerOutputStream[this.signers.length];
            for (int i = 0; i < this.signers.length; ++i) {
                derEncoderArray[i] = new DerOutputStream();
                this.signers[i].encode((OutputStream)((Object)derEncoderArray[i]));
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding signer information");
            }
            throw new IOException("error encoding signer information");
        }
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        if (SignedAndEnvelopedData.debug != null) {
            SignedAndEnvelopedData.debug.entry(16384L, (Object)SignedAndEnvelopedData.className, "decode", var1_1);
        }
        if (var1_1.getTag() != 48) {
            if (SignedAndEnvelopedData.debug != null) {
                SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "SignedData parsing error");
            }
            throw new IOException("SignedData parsing error");
        }
        this.version = var1_1.getData().getInteger();
        var3_2 = var1_1.getData().getSet(1);
        this.recipientInfos = new RecipientInfo[var3_2.length];
        for (var4_3 = 0; var4_3 < var3_2.length; ++var4_3) {
            this.recipientInfos[var4_3] = new RecipientInfo(var3_2[var4_3].toByteArray(), this.provider);
        }
        var4_4 = var1_1.getData().getSet(1);
        this.digestAlgorithms = new AlgorithmId[var4_4.length];
        for (var5_5 = 0; var5_5 < var4_4.length; ++var5_5) {
            this.digestAlgorithms[var5_5] = AlgorithmId.parse(var4_4[var5_5]);
        }
        var2_11 = var1_1.getData().getDerValue();
        this.encryptedContentInfo = new EncryptedContentInfo(var2_11.toByteArray(), this.provider);
lbl20:
        // 3 sources

        try {
            while (var1_1.getData().available() != 0) {
                block17: {
                    block16: {
                        var2_11 = var1_1.getData().getDerValue();
                        if (!var2_11.isContextSpecific((byte)0) || !var2_11.isConstructed()) break block16;
                        var5_6 = new DerInputStream(var2_11.toByteArray());
                        var4_4 = var5_6.getSet(1, true);
                        this.certs = new X509Certificate[var4_4.length];
                        for (var6_12 = 0; var6_12 < var4_4.length; ++var6_12) {
                            this.certs[var6_12] = new X509CertImpl(var4_4[var6_12].toByteArray());
                        }
                        ** GOTO lbl20
                    }
                    if (!var2_11.isContextSpecific((byte)1) || !var2_11.isConstructed()) break block17;
                    var5_7 = new DerInputStream(var2_11.toByteArray());
                    var4_4 = var5_7.getSet(1, true);
                    this.crls = new X509CRL[var4_4.length];
                    for (var6_12 = 0; var6_12 < var4_4.length; ++var6_12) {
                        this.crls[var6_12] = new X509CRLImpl(var4_4[var6_12].toByteArray());
                    }
                    ** GOTO lbl20
                }
                if (var2_11.getTag() == 49) break;
                if (SignedAndEnvelopedData.debug != null) {
                    SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "error decoding SignedData");
                }
                throw new IOException("error decoding SignedData");
            }
        }
        catch (CertificateException var5_8) {
            if (SignedAndEnvelopedData.debug != null) {
                SignedAndEnvelopedData.debug.exception(16384L, SignedAndEnvelopedData.className, "decode", var5_8);
                SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "error decoding certificates");
            }
            throw new IOException("error decoding certificates");
        }
        catch (CRLException var5_9) {
            if (SignedAndEnvelopedData.debug != null) {
                SignedAndEnvelopedData.debug.exception(16384L, SignedAndEnvelopedData.className, "decode", var5_9);
                SignedAndEnvelopedData.debug.text(16384L, SignedAndEnvelopedData.className, "decode", "error decoding crls");
            }
            throw new IOException("error decoding crls");
        }
        var5_10 = new DerInputStream(var2_11.toByteArray());
        var4_4 = var5_10.getSet(1, true);
        this.signers = new SignerInfo[var4_4.length];
        for (var6_12 = 0; var6_12 < var4_4.length; ++var6_12) {
            this.signers[var6_12] = new SignerInfo(var4_4[var6_12].toByteArray(), this.provider);
        }
        if (SignedAndEnvelopedData.debug != null) {
            SignedAndEnvelopedData.debug.exit(16384L, SignedAndEnvelopedData.className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof SignedAndEnvelopedData)) {
            boolean bl = this.equals((SignedAndEnvelopedData)object);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(bl));
            }
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((SignedAndEnvelopedData)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        int n;
        String string = "";
        string = string + "\tversion; " + this.version.intValue();
        string = string + "\r\n\trecipientInfos: ";
        for (n = 0; n < this.recipientInfos.length; ++n) {
            string = string + "\r\n\t" + this.recipientInfos[n];
        }
        string = string + "\r\n\tdigestAlgorithms: ";
        for (n = 0; n < this.digestAlgorithms.length; ++n) {
            string = string + "\r\n\t" + this.digestAlgorithms[n];
        }
        string = string + "\r\n\tencrypted content info: \n";
        string = string + this.encryptedContentInfo;
        string = string + "\tcertificates: ";
        if (this.certs == null || this.certs.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.certs.length; ++n) {
                string = string + "\r\n\t" + this.certs[n];
            }
        }
        string = string + "\r\n\tcertificate revocation lists: ";
        if (this.crls == null || this.crls.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.crls.length; ++n) {
                string = string + "\r\n\t" + this.crls[n];
            }
        }
        string = string + "\r\n\tsigners: ";
        for (n = 0; n < this.signers.length; ++n) {
            string = string + "\r\n\t" + this.signers[n];
        }
        return string;
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ONE;
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }
}

