/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class EncryptedData
extends Content
implements Cloneable {
    private BigInteger version;
    private EncryptedContentInfo encryptedContent;
    private PKCSAttributes unprotectedAttrs;
    private SmudgedBytes contentEncryptionKey;
    private static final byte TAG_UNPROTECTED_ATTRS = 1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EncryptedData";
    private volatile int cachedHashVal = 0;

    public EncryptedData(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncryptedData", (Object)byArray);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedData", byArray, string);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo, PKCSAttributes pKCSAttributes) {
        this(encryptedContentInfo, pKCSAttributes, null);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedData", encryptedContentInfo, pKCSAttributes);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo, PKCSAttributes pKCSAttributes, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{encryptedContentInfo, pKCSAttributes, string};
            debug.entry(16384L, (Object)className, "EncryptedData", objectArray);
        }
        this.encryptedContent = encryptedContentInfo;
        this.unprotectedAttrs = pKCSAttributes;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "EncryptedData", objectArray);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public EncryptedData(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "EncryptedData", objectArray);
            debug.exit(16384L, className, "EncryptedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            EncryptedData encryptedData = new EncryptedData(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", encryptedData);
            }
            return encryptedData;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        this.encryptedContent.encode(derOutputStream);
        if (this.unprotectedAttrs != null && this.unprotectedAttrs.size() > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.unprotectedAttrs.encode(derOutputStream3);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedData parsing error");
            }
            throw new IOException("EncryptedData parsing error");
        }
        this.version = derValue.getData().getInteger();
        if (this.version.intValue() != 0 && this.version.intValue() != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Version number must be 0 or 2");
            }
            throw new IllegalArgumentException("Version number must be 0 or 2");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.encryptedContent = new EncryptedContentInfo(derValue2.toByteArray(), this.provider);
        if (derValue.getData().available() != 0) {
            derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                DerInputStream derInputStream = new DerInputStream(derValue2.toByteArray());
                this.unprotectedAttrs = new PKCSAttributes(derInputStream, this.provider);
            } else {
                this.unprotectedAttrs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof EncryptedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((EncryptedData)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    private void addUnprotectedAttribute(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnprotectedAttribute", pKCSAttributes);
        }
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnprotectedAttribute");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs == null ? (PKCSAttributes)pKCSAttributes.clone() : this.unprotectedAttrs.addAttributes(pKCSAttributes);
        if (debug != null) {
            debug.exit(8192L, className, "addUnprotectedAttribute_1");
        }
    }

    private void addUnprotectedAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnprotectedAttribute", this.unprotectedAttrs);
        }
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnprotectedAttribute_1");
            }
            return;
        }
        if (this.unprotectedAttrs == null) {
            PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
            this.unprotectedAttrs = new PKCSAttributes(pKCSAttributeArray, this.provider);
        } else {
            this.unprotectedAttrs = this.unprotectedAttrs.addAttribute(pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addUnprotectedAttribute");
        }
    }

    private void removeUnprotectedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "removeUnprotectedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(8192L, className, "removeUnprotectedAttribute_1");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs.deleteAttribute(objectIdentifier);
        if (debug != null) {
            debug.exit(8192L, className, "removeUnprotectedAttribute");
        }
    }

    public PKCSAttribute getUnprotectedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnprotectedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.unprotectedAttrs.getAttribute(objectIdentifier);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttribute", pKCSAttribute);
        }
        return pKCSAttribute;
    }

    public PKCSAttributes getUnprotectedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnprotectedAttributes");
        }
        if (this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttributes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttributes_2", this.unprotectedAttrs);
        }
        return this.unprotectedAttrs;
    }

    private void encryptContent(ContentInfo contentInfo, String string, int n) throws PKCSException, IOException {
        AlgorithmId algorithmId;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{contentInfo, string, new Integer(n)};
            debug.entry(8192L, (Object)className, "encryptContent", objectArray);
        }
        objectArray = EncryptedContentInfo.getAlgorithm(string);
        try {
            algorithmId = AlgorithmId.get((String)objectArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "encryptContent", noSuchAlgorithmException);
            }
            throw new IllegalArgumentException("Unsupported encryption algorithm: " + (String)objectArray + ".  Must be one of AES, DES, DESede or RC2.");
        }
        if (this.encryptedContent != null) {
            AlgorithmId algorithmId2 = this.encryptedContent.getContentEncryptionAlgorithm();
            if (!algorithmId2.equals(algorithmId) && debug != null) {
                debug.text(8192L, className, "encryptContent", "Input content encryption algorithm differs from existing algorithm");
            }
            throw new IllegalArgumentException("Input content encryption algorithm differs from existing algorithm");
        }
        this.encryptedContent = new EncryptedContentInfo(contentInfo, string, n);
        this.setContentEncryptionKey(this.encryptedContent.getEncryptionKey());
        if (debug != null) {
            debug.exit(8192L, className, "encryptContent");
        }
    }

    private void encryptContent(ContentInfo contentInfo, String string, byte[] byArray) throws PKCSException, IOException {
        AlgorithmId algorithmId;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{contentInfo, string, byArray};
            debug.entry(8192L, (Object)className, "encryptContent", objectArray);
        }
        objectArray = EncryptedContentInfo.getAlgorithm(string);
        try {
            algorithmId = AlgorithmId.get((String)objectArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "encryptContent", noSuchAlgorithmException);
            }
            throw new IllegalArgumentException("Unsupported encryption algorithm: " + (String)objectArray + ".  Must be one of AES, DES, DESede or RC2.");
        }
        if (this.encryptedContent != null) {
            AlgorithmId algorithmId2 = this.encryptedContent.getContentEncryptionAlgorithm();
            if (!algorithmId2.equals(algorithmId) && debug != null) {
                debug.text(8192L, className, "encryptContent", "Input content encryption algorithm differs from existing algorithm");
            }
            throw new IllegalArgumentException("Input content encryption algorithm differs from existing algorithm");
        }
        this.encryptedContent = new EncryptedContentInfo(contentInfo, string, byArray, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "encryptContent");
        }
        this.setContentEncryptionKey(byArray);
    }

    public byte[] getEncryptionKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionKey");
        }
        if (this.encryptedContent == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptionKey", null);
            }
            return null;
        }
        byte[] byArray = this.encryptedContent.getEncryptionKey();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptionKey", byArray);
        }
        return byArray;
    }

    public ContentInfo decrypt(byte[] byArray) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)byArray);
        }
        String string = this.encryptedContent.getContentEncryptionAlgorithm().getName();
        ObjectIdentifier objectIdentifier = this.encryptedContent.getContentEncryptionAlgorithm().getOID();
        if (!(objectIdentifier.equals(AlgorithmId.DESCBC_oid) || objectIdentifier.equals(AlgorithmId.tripleDESCBC_oid) || objectIdentifier.equals(AlgorithmId.RC2CBC_oid) || objectIdentifier.equals(AlgorithmId.AES128CBC_oid) || objectIdentifier.equals(AlgorithmId.AES192CBC_oid) || objectIdentifier.equals(AlgorithmId.AES256CBC_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Unsupported decryption algorithm: " + string);
            }
            throw new PKCSException("Unsupported decryption algorithm: " + string);
        }
        ContentInfo contentInfo = this.encryptedContent.decrypt(byArray);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", contentInfo);
        }
        return contentInfo;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.ENCRYPTED_DATA_OID);
        }
        return PKCSOID.ENCRYPTED_DATA_OID;
    }

    public EncryptedContentInfo getEncryptedContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContent");
            debug.exit(16384L, (Object)className, "getEncryptedContent", this.encryptedContent);
        }
        return this.encryptedContent;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public String toString() {
        String string = "PKCS7 EncryptedData:\r\n";
        string = string + "\tversion: " + this.version.intValue();
        string = string + "\r\n\tencryptedContentInfo: " + this.encryptedContent;
        if (this.unprotectedAttrs != null) {
            string = string + "\r\n\tunprotectedAttrs (" + this.unprotectedAttrs.size() + "): \r\n";
            string = string + this.unprotectedAttrs + "\r\n";
        } else {
            string = string + "\tunprotectedAttrs: null\r\n";
        }
        return string;
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.encryptedContent == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "EncryptedData missing encryptedContentInfo value.");
            }
            throw new IOException("EncryptedData missing encryptedContentInfo value.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ZERO;
        if (this.unprotectedAttrs != null) {
            this.version = BigInteger.valueOf(2L);
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }

    private void setContentEncryptionKey(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentEncryptionKey", (Object)byArray);
        }
        this.contentEncryptionKey = new SmudgedBytes(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "setContentEncryptionKey");
        }
    }

    private byte[] getContentEncryptionKey() {
        if (debug != null) {
            debug.entry(8192L, className, "setContentEncryptionKey");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "setContentEncryptionKey", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "setContentEncryptionKey", this.contentEncryptionKey.getClearText());
        }
        return this.contentEncryptionKey.getClearText();
    }

    protected void finalize() {
        this.contentEncryptionKey = null;
    }
}

