/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;

public final class PKCS12Utils {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12Utils";

    private PKCS12Utils() {
    }

    public static byte[] ascii2bmp(char[] cArray) {
        byte[] byArray = new byte[]{};
        if (debug != null) {
            debug.entry(49152L, (Object)className, "ascii2bmp", (Object)cArray);
        }
        if (cArray == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "ascii2bmp_1", byArray);
            }
            return byArray;
        }
        if (cArray.length > 0) {
            byArray = new byte[(cArray.length + 1) * 2];
        }
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray[n2] = (byte)(cArray[n] >>> 8 & 0xFF);
            byArray[n2 + 1] = (byte)(cArray[n] & 0xFF);
            ++n;
            n2 += 2;
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "ascii2bmp_2", byArray);
        }
        return byArray;
    }

    public static String bmp2string(byte[] byArray) {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "bmp2string", (Object)byArray);
        }
        if (byArray.length % 2 != 0) {
            if (debug != null) {
                debug.text(49152L, className, "bmp2string", "Invalid BMP array.");
            }
            throw new IllegalArgumentException("Invalid BMP array.");
        }
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            byte by = byArray[n++];
            byte by2 = byArray[n++];
            cArray[n2] = (char)((by << 8) + by2);
            ++n2;
        }
        String string = new String(cArray);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "bmp2string", string.trim());
        }
        return string.trim();
    }
}

