/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport.tcp;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.transport.MessageHeader;
import com.ibm.keymanager.transport.TransportMessage;
import com.ibm.keymanager.transport.TransportSpi;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class TCPTransport
extends TransportSpi {
    private Socket socket;
    private BufferedInputStream bis;
    private BufferedOutputStream bos;
    private Config config;
    private boolean isClosed;
    private KMSDebug debug = KMSDebug.getInstance();
    private TransportMessage firstMsg;
    private boolean getFirstMsg;

    public TCPTransport(Object connection) {
        if (connection instanceof Socket) {
            this.socket = (Socket)connection;
        }
    }

    public void open() throws KeyManagerException {
        int timeout;
        String value = (String)this.config.get("TransportListener.tcp.timeout");
        if (value == null) {
            value = (String)this.config.get("TransportListener.tcp.timeout".substring("TransportListener.tcp.timeout".indexOf(".") + 1));
            if (value == null) {
                this.debug.trace("transport", this.getClass().getName(), "open", "TransportListener.tcp.timeout value can not be found in config");
            } else {
                this.debug.trace("transport", this.getClass().getName(), "init", "TransportListener.tcp.timeout=" + value);
            }
        }
        if (value != null) {
            try {
                timeout = new Integer(value) * 60 * 1000;
            }
            catch (NumberFormatException ex) {
                this.debug.trace("transport", "TCPTransport", "open", ex);
                timeout = 600000;
            }
        } else {
            timeout = 600000;
        }
        try {
            this.debug.trace("transport", "TCPTransport", "open", "set time out=" + timeout);
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException ex) {
            this.debug.trace("transport", "TCPTransport", "open", ex);
        }
        try {
            this.bis = new BufferedInputStream(this.socket.getInputStream());
            this.bos = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (IOException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
    }

    public void init(Config config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receive(int size) throws IOException {
        BufferedInputStream bufferedInputStream = this.bis;
        synchronized (bufferedInputStream) {
            this.debug.entry("transport", "TCPTransport", "receive(int)");
            byte[] result = new byte[size];
            if (this.socket.isClosed()) {
                this.debug.trace("transport", "TCPTransport", "received(int)", "socket is closed");
                throw new IOException("Socket is closed");
            }
            this.bis.read(result);
            this.debug.trace("transport", "TCPTransport", "receive(int)", result);
            return result;
        }
    }

    public int available() {
        try {
            return this.bis.available();
        }
        catch (IOException ex) {
            this.debug.trace("transport", "TCPTransport", "available", ex);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportMessage receive() throws KeyManagerException, IOException {
        TransportMessage result = null;
        if (this.firstMsg != null) {
            result = this.firstMsg;
            this.firstMsg = null;
            return result;
        }
        BufferedInputStream bufferedInputStream = this.bis;
        synchronized (bufferedInputStream) {
            MessageHeader mh = new MessageHeader(this.receive(5));
            byte[] length = this.receive(4);
            int size = (length[0] & 0xFF) << 24 | (length[1] & 0xFF) << 16 | (length[2] & 0xFF) << 8 | length[3] & 0xFF;
            if (mh.getMajorType() == 1 && size > 10000) {
                throw new KeyManagerException("invalid length");
            }
            byte[] data = this.receive(size);
            result = new TransportMessage(mh, length, data);
        }
        if (!this.getFirstMsg) {
            this.getFirstMsg = true;
            this.firstMsg = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TransportMessage message) throws IOException {
        this.debug.entry("transport", "TCPTransport", "send");
        BufferedOutputStream bufferedOutputStream = this.bos;
        synchronized (bufferedOutputStream) {
            byte[] data = message.getMessage();
            this.bos.write(data);
            this.bos.flush();
            this.debug.trace("transport", "TCPTransport", "send", "flush data out");
            this.debug.trace("transport", "TCPTransport", "send", data);
        }
    }

    public void close() throws IOException {
        this.bis.close();
        this.bos.close();
        this.socket.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getType() {
        return "TCP";
    }

    public int getPort() {
        return this.socket.getPort();
    }
}

