/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.transport.MessageHeader;

public class TransportMessage {
    private MessageHeader header;
    private byte[] message;

    public TransportMessage(byte[] data) throws KeyManagerException {
        this.message = (byte[])data.clone();
        this.header = new MessageHeader(data);
    }

    public TransportMessage(MessageHeader header, byte[] messageBody) {
        this.header = header;
        byte[] headerData = header.getHeader();
        this.message = new byte[headerData.length + messageBody.length];
        System.arraycopy(headerData, 0, this.message, 0, headerData.length);
        System.arraycopy(messageBody, 0, this.message, headerData.length, messageBody.length);
    }

    public TransportMessage(MessageHeader header, byte[] length, byte[] data) {
        this.header = header;
        byte[] headerData = header.getHeader();
        this.message = new byte[headerData.length + data.length + length.length];
        System.arraycopy(headerData, 0, this.message, 0, headerData.length);
        System.arraycopy(length, 0, this.message, headerData.length, length.length);
        System.arraycopy(data, 0, this.message, headerData.length + length.length, data.length);
    }

    public MessageHeader getMessageHeader() {
        return this.header;
    }

    public byte[] getMessageBody() {
        byte[] headerData = this.header.getHeader();
        byte[] result = new byte[this.message.length - headerData.length];
        System.arraycopy(this.message, headerData.length, result, 0, result.length);
        return result;
    }

    public byte[] getMessage() {
        return this.message;
    }
}

