/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Logic;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class UKI {
    byte[] structType = new byte[2];
    BigInteger structLen;
    String keyLabel = null;
    byte[] SKI;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "UKI.class";

    public UKI(String label, byte[] hash) throws KeyManagerException {
        this.debug.entry("logic", className, "UKI-Create");
        if (label != null) {
            this.structType[0] = 25;
            this.structType[1] = 16;
            this.keyLabel = label;
            this.structLen = new BigInteger("" + label.length());
            int len = 4 + label.length();
            this.msglen = new BigInteger("" + len);
            this.origMsg = new byte[len];
            System.arraycopy(this.structType, 0, this.origMsg, 0, this.structType.length);
            int pos = 2;
            System.arraycopy(Logic.IntToByteArray(this.structLen.intValue(), 2), 0, this.origMsg, pos, 2);
            pos += 2;
            try {
                System.arraycopy(label.getBytes("UTF-8"), 0, this.origMsg, pos, label.length());
            }
            catch (UnsupportedEncodingException e) {
                System.arraycopy(label.getBytes(), 0, this.origMsg, pos, label.length());
            }
        } else {
            this.structType[0] = 25;
            this.structType[1] = 18;
            this.SKI = hash;
            this.structLen = new BigInteger("" + hash.length);
            int len = 4 + hash.length;
            this.msglen = new BigInteger("" + len);
            this.origMsg = new byte[len];
            System.arraycopy(this.structType, 0, this.origMsg, 0, this.structType.length);
            int pos = 2;
            System.arraycopy(Logic.IntToByteArray(this.structLen.intValue(), 2), 0, this.origMsg, pos, 2);
            System.arraycopy(hash, 0, this.origMsg, pos += 2, hash.length);
        }
        this.debug.exit("logic", className, "UKI-Create");
    }

    public UKI(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "UKI-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "UKI-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "parse");
        int pos = offset;
        System.arraycopy(msg, pos, this.structType, 0, this.structType.length);
        pos += this.structType.length;
        if (this.structType[0] != 25 && this.structType[1] != 16 && this.structType[1] != 18 && this.structType[1] != 20) {
            this.debug.exit("logic", className, "parse", "Exception: Invalid structure type.");
            throw new KeyManagerException(2, 1, "Invalid structure type.");
        }
        byte[] tmp = new byte[]{msg[pos], msg[++pos]};
        ++pos;
        this.structLen = new BigInteger(tmp);
        this.msglen = this.structLen.add(new BigInteger("4"));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        if (this.structLen.intValue() > 0) {
            if (this.structType[1] == 16 || this.structType[1] == 20) {
                try {
                    this.keyLabel = new String(msg, pos, this.structLen.intValue(), "8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    this.debug.exit("logic", className, "parse-1", "Exception: " + e.getMessage());
                    throw new KeyManagerException(2, 99, e.getMessage());
                }
            } else if (this.structType[1] == 18) {
                this.SKI = new byte[this.structLen.intValue()];
                System.arraycopy(msg, pos, this.SKI, 0, this.SKI.length);
            }
        }
        this.debug.exit("logic", className, "parse");
    }

    String getEncKeyLabel() {
        this.debug.entry("logic", className, "getEncKeyLabel");
        this.debug.exit("logic", className, "getEncKeyLabel");
        return this.keyLabel;
    }

    byte[] getSubjectKeyId() {
        this.debug.entry("logic", className, "getSubjectKeyId");
        this.debug.exit("logic", className, "getSubjectKeyId");
        return this.SKI;
    }

    byte[] getStructType() {
        this.debug.entry("logic", className, "getStructType");
        this.debug.exit("logic", className, "getStructType");
        return this.structType;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

