/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.logic.ProxyRoutingInfo;
import java.math.BigInteger;

public class MsgHeader {
    BigInteger encMsgLen;
    BigInteger signedMsgLen;
    ProxyRoutingInfo pri = null;
    byte[] origMsg;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "MsgHeader.class";

    MsgHeader(ProxyRoutingInfo priInfo, int enclen, int signmsglen) throws KeyManagerException {
        this.debug.entry("logic", className, "MsgHeader-Create");
        int pos = 0;
        byte[] encLenA = Logic.IntToByteArray(enclen, 4);
        byte[] signmsglenA = Logic.IntToByteArray(signmsglen, 4);
        this.pri = priInfo;
        this.origMsg = new byte[priInfo.getMsgLen() + 8];
        System.arraycopy(encLenA, 0, this.origMsg, pos, encLenA.length);
        System.arraycopy(signmsglenA, 0, this.origMsg, pos += encLenA.length, signmsglenA.length);
        System.arraycopy(priInfo.getMessage(), 0, this.origMsg, pos += signmsglenA.length, priInfo.getMsgLen());
        this.pri = priInfo;
        this.debug.exit("logic", className, "MsgHeader-Create");
    }

    MsgHeader(byte[] msg) throws KeyManagerException {
        this.debug.entry("logic", className, "MsgHeader-Parse");
        this.origMsg = new byte[msg.length];
        System.arraycopy(msg, 0, this.origMsg, 0, msg.length);
        this.parse(msg);
        this.debug.exit("logic", className, "MsgHeader-Parse");
    }

    void parse(byte[] msg) throws KeyManagerException {
        this.debug.entry("logic", className, "parse");
        byte[] tmp = new byte[4];
        System.arraycopy(msg, 0, tmp, 0, 4);
        this.encMsgLen = new BigInteger(tmp);
        System.arraycopy(msg, 4, tmp, 0, 4);
        this.signedMsgLen = new BigInteger(tmp);
        this.pri = new ProxyRoutingInfo(msg, 8);
        this.debug.exit("logic", className, "parse");
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.entry("logic", className, "getMessage");
        return this.origMsg;
    }

    ProxyRoutingInfo getProxyRoutingInfo() {
        this.debug.entry("logic", className, "getProxyRoutingInfo");
        this.debug.entry("logic", className, "getProxyRoutingInfo");
        return this.pri;
    }

    BigInteger getEncMsgLen() {
        this.debug.entry("logic", className, "getEncMsgLen");
        this.debug.entry("logic", className, "getEncMsgLen");
        return this.encMsgLen;
    }

    BigInteger getSignedMsgLen() {
        this.debug.entry("logic", className, "getSignedMsgLen");
        this.debug.entry("logic", className, "getSignedMsgLen");
        return this.signedMsgLen;
    }

    int getHeaderLen() {
        this.debug.entry("logic", className, "getHeaderLen");
        this.debug.entry("logic", className, "getHeaderLen");
        return this.pri.getMsgLen() + 8;
    }
}

