/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import java.math.BigInteger;

class MediumInfo {
    BigInteger mediumLen;
    byte mediumType;
    byte denistyCode;
    byte[] mediumID = new byte[2];
    byte formatID;
    byte volLabelFlags;
    byte[] volLabelCartType = new byte[2];
    byte[] volLabel = new byte[6];
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "MediumInfo.class";

    MediumInfo(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "MediumInfo");
        if (msg[offset] != 13 || msg[offset + 1] != 0) {
            this.debug.exit("logic", className, "MediumInfo-1", "Exception: Message type not X0D00");
            throw new KeyManagerException(2, 1, "Message type not X0D00");
        }
        byte[] tmp = new byte[]{msg[offset + 2], msg[offset + 3]};
        this.mediumLen = new BigInteger(tmp);
        this.msglen = new BigInteger("" + (this.mediumLen.intValue() + 4));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        if (this.mediumLen.intValue() == 0) {
            return;
        }
        if (this.mediumLen.intValue() != 16) {
            this.debug.exit("logic", className, "MediumInfo-2", "Exception: Medium len is not 16.");
            throw new KeyManagerException(2, 14, "Medium len is not 16.");
        }
        this.parse(msg, offset);
        this.debug.exit("logic", className, "MediumInfo");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = offset + 4;
        this.debug.entry("logic", className, "parse");
        this.mediumType = msg[pos];
        this.denistyCode = msg[++pos];
        ++pos;
        System.arraycopy(msg, pos += 2, this.mediumID, 0, 2);
        this.formatID = msg[pos += 2];
        this.volLabelFlags = msg[++pos];
        System.arraycopy(msg, ++pos, this.volLabelCartType, 0, this.volLabelCartType.length);
        System.arraycopy(msg, pos += 2, this.volLabel, 0, this.volLabel.length);
        this.debug.exit("logic", className, "parse");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }

    byte getMediumType() {
        this.debug.entry("logic", className, "getMediumType");
        this.debug.exit("logic", className, "getMediumType");
        return this.mediumType;
    }

    byte getDenistyCode() {
        this.debug.entry("logic", className, "getDenistyCode");
        this.debug.exit("logic", className, "getDenistyCode");
        return this.denistyCode;
    }

    byte[] getMediumID() {
        this.debug.entry("logic", className, "getMediumID");
        this.debug.exit("logic", className, "getMediumID");
        return this.mediumID;
    }

    byte getFormatID() {
        this.debug.entry("logic", className, "getFormatID");
        this.debug.exit("logic", className, "getFormatID");
        return this.formatID;
    }

    byte getVolLabelFlags() {
        this.debug.entry("logic", className, "getVolLabelFlags");
        this.debug.exit("logic", className, "getVolLabelFlags");
        return this.volLabelFlags;
    }

    byte[] getVolLabelCartType() {
        this.debug.entry("logic", className, "getVolLabelCartType");
        this.debug.exit("logic", className, "getVolLabelCartType");
        return this.volLabelCartType;
    }

    byte[] getVolLabel() {
        this.debug.entry("logic", className, "getVolLabel");
        this.debug.exit("logic", className, "getVolLabel");
        return this.volLabel;
    }
}

