/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ServerParameters;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.audit.Runtime_Event;
import com.ibm.keymanager.drivetable.DriveTableEntry;
import com.ibm.keymanager.logic.Crypto;
import com.ibm.keymanager.logic.EncSubPageStatusWrapper;
import com.ibm.keymanager.logic.MediumInfo;
import com.ibm.keymanager.logic.MessageProcessor;
import com.ibm.keymanager.logic.MsgHeader;
import com.ibm.keymanager.logic.ProxyRoutingInfo;
import com.ibm.keymanager.logic.RoutingInfo;
import com.ibm.keymanager.transport.MessageHeader;
import com.ibm.keymanager.transport.Transport;
import com.ibm.keymanager.transport.TransportMessage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Logic
extends Thread {
    Audit audit = null;
    Transport trans;
    ServerParameters params;
    Hashtable table = new Hashtable(10);
    boolean run = true;
    Crypto crypto = null;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "Logic.class";

    public Logic(Transport transport, ServerParameters sparams) {
        this.audit = Audit.getInstance();
        this.debug.entry("logic", className, "Logic");
        this.trans = transport;
        this.params = sparams;
        try {
            this.crypto = new Crypto(sparams);
        }
        catch (Exception e) {
            this.debug.trace("logic", className, "Logic", e);
            this.crypto = null;
        }
        this.debug.exit("logic", className, "Logic");
    }

    public void run() {
        this.debug.entry("logic", className, "run");
        this.LogicProcessMsg();
        this.debug.exit("logic", className, "run");
    }

    public void dispose() {
        this.debug.entry("logic", className, "dispose");
        Enumeration e = this.table.elements();
        while (e.hasMoreElements()) {
            MessageProcessor mp = (MessageProcessor)e.nextElement();
            mp.dispose();
        }
        this.run = false;
        this.debug.exit("logic", className, "dispose");
    }

    void LogicProcessMsg() {
        block30: {
            this.debug.entry("logic", className, "LogicProcessMsg");
            try {
                MessageProcessor mp;
                if (this.audit.isOn("runtime", "success")) {
                    Runtime_Event re = new Runtime_Event((Object)this, "start", new String("Process Message"), true);
                    this.audit.record(re);
                }
                byte[] tmsg = this.trans.receive().getMessageBody();
                if (this.debug.isOn("logic")) {
                    this.debug.trace("logic", className, "LogicProcessMsg", tmsg);
                }
                MsgHeader msg = new MsgHeader(tmsg);
                if (this.crypto == null) {
                    this.statusMessage(tmsg, (byte)-18, (byte)46);
                    return;
                }
                ProxyRoutingInfo pri = msg.getProxyRoutingInfo();
                byte[] wwn = pri.getWWDN();
                byte[] dsn = pri.getDriveSerialNumber();
                String tid = new String(wwn, "UTF-8") + new String(dsn, "UTF-8");
                DriveTableEntry dte = this.params.getDriveTable().fetchDriveEntry(dsn, null);
                if (dte == null) {
                    this.debug.trace("logic", className, "LogicProcessMsg", "Drive not found.");
                    this.statusMessage(tmsg, (byte)-17, (byte)1);
                    break block30;
                }
                if (dte.getWWName() == null) {
                    dte.setWWName(wwn);
                }
                if ((mp = (MessageProcessor)this.table.get(tid)) == null) {
                    mp = new MessageProcessor(this.trans, this.params, this);
                    this.table.put(tid, mp);
                    mp.start();
                }
                mp.getQueue().addLast(tmsg);
                while (this.run) {
                    try {
                        tmsg = this.trans.receive().getMessageBody();
                    }
                    catch (KeyManagerException kme) {
                        Enumeration e = this.table.elements();
                        while (e.hasMoreElements()) {
                            mp = (MessageProcessor)e.nextElement();
                            mp.dispose();
                        }
                        try {
                            this.trans.close();
                        }
                        catch (IOException ioe2) {
                            this.debug.exit("logic", className, "LogicProcessMsg", "Socket Close Error: " + ioe2.getMessage());
                        }
                        this.debug.exit("logic", className, "LogicProcessMsg", "KeyManagerException: " + kme.getMessage());
                        return;
                    }
                    msg = new MsgHeader(tmsg);
                    pri = msg.getProxyRoutingInfo();
                    wwn = pri.getWWDN();
                    dsn = pri.getDriveSerialNumber();
                    tid = new String(wwn, "UTF-8") + new String(dsn, "UTF-8");
                    dte = this.params.getDriveTable().fetchDriveEntry(dsn, null);
                    if (dte == null) {
                        this.debug.trace("logic", className, "LogicProcessMsg", "Drive not found.");
                        this.statusMessage(tmsg, (byte)-17, (byte)1);
                        continue;
                    }
                    if (dte.getWWName() == null) {
                        dte.setWWName(wwn);
                    }
                    if ((mp = (MessageProcessor)this.table.get(tid)) == null) {
                        mp = new MessageProcessor(this.trans, this.params, this);
                        this.table.put(tid, mp);
                        mp.start();
                    }
                    mp.getQueue().addLast(tmsg);
                }
            }
            catch (KeyManagerException kme) {
                Enumeration e = this.table.elements();
                while (e.hasMoreElements()) {
                    MessageProcessor mp = (MessageProcessor)e.nextElement();
                    mp.dispose();
                }
                try {
                    if (this.audit.isOn("runtime", "success")) {
                        Runtime_Event re = new Runtime_Event((Object)this, "start", new String("Process Message failed"), true);
                        this.audit.record(re);
                    }
                }
                catch (KeyManagerException kme2) {
                    // empty catch block
                }
                try {
                    this.trans.close();
                }
                catch (IOException ioe2) {
                    this.debug.exit("logic", className, "LogicProcessMsg", "Socket Close Error: " + ioe2.getMessage());
                }
                this.debug.exit("logic", className, "LogicProcessMsg", "KeyManagerException: " + kme.getMessage());
                return;
            }
            catch (IOException ioe) {
                Enumeration e = this.table.elements();
                while (e.hasMoreElements()) {
                    MessageProcessor mp = (MessageProcessor)e.nextElement();
                    mp.dispose();
                }
                try {
                    if (this.audit.isOn("runtime", "success")) {
                        Runtime_Event re = new Runtime_Event((Object)this, "start", new String("Process Message failed"), true);
                        this.audit.record(re);
                    }
                }
                catch (KeyManagerException kme3) {
                    // empty catch block
                }
                try {
                    this.trans.close();
                }
                catch (IOException ioe2) {
                    this.debug.trace("logic", className, "LogicProcessMsg", "Socket Close Error: " + ioe2.getMessage());
                }
                this.debug.exit("logic", className, "LogicProcessMsg", "IOException: " + ioe.getMessage());
                return;
            }
        }
        this.debug.exit("logic", className, "LogicProcessMsg");
    }

    void statusMessage(byte[] message, byte asc, byte ascq) {
        this.debug.entry("logic", className, "statusMessage");
        MediumInfo medInfo = null;
        ProxyRoutingInfo pri = null;
        RoutingInfo ri = null;
        try {
            MsgHeader header = new MsgHeader(message);
            pri = header.getProxyRoutingInfo();
            int pos = header.getHeaderLen();
            if (message[pos] == 33 & message[pos + 1] == 0) {
                pos += 12;
            }
            if (message[pos] == 33 & message[pos + 1] == 254) {
                pos += 4;
            }
            if (message[pos] == 32 & message[pos + 1] == 32) {
                pos += 32;
            }
            ri = new RoutingInfo(message, pos += 12);
            medInfo = new MediumInfo(message, pos += ri.getMsgLen());
        }
        catch (Exception e) {
            this.debug.trace("logic", className, "statusMessage", "Exception: " + e.getMessage());
            this.debug.exit("logic", className, "statusMessage", "Could not create status message to send.");
            return;
        }
        EncSubPageStatusWrapper espswResp = null;
        try {
            espswResp = new EncSubPageStatusWrapper(pri, ri, medInfo, -2, 112, 5, asc, ascq, this.crypto);
        }
        catch (KeyManagerException e) {
            this.debug.trace("logic", className, "statusMessage", "Exception: " + e.getMessage());
            this.debug.exit("logic", className, "statusMessage", "Could not create status message to send.");
            return;
        }
        this.sendMsg(espswResp.getMessage());
        this.debug.exit("logic", className, "statusMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMsg(byte[] message) {
        this.debug.entry("logic", className, "sendMsg");
        MessageHeader mh = new MessageHeader(1, 1, 0);
        TransportMessage tm = new TransportMessage(mh, message);
        Transport transport = this.trans;
        synchronized (transport) {
            try {
                this.trans.send(tm);
            }
            catch (IOException ioe) {
                this.debug.exit("logic", className, "sendMsg", ioe.getMessage());
                return;
            }
        }
        this.debug.exit("logic", className, "sendMsg");
    }

    static byte[] IntToByteArray(int i, int size) throws KeyManagerException {
        byte[] b = new byte[size];
        String s = Integer.toHexString(i);
        if (s.length() % 2 == 1) {
            s = "0" + s;
        }
        if (s.length() / 2 > size) {
            throw new KeyManagerException(2, 99, "value too big to put into array.");
        }
        int startpos = size - s.length() / 2;
        for (int x = 0; x < s.length(); ++x) {
            b[startpos + x / 2] = (byte)(Character.digit(s.charAt(x), 16) << 4 | Character.digit(s.charAt(++x), 16));
        }
        return b;
    }
}

