/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.DSK;
import java.math.BigInteger;

public class EncryptionSubPageQuerydSK {
    BigInteger dSKCount;
    DSK[] dSKs;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionSubPageQuerydSK.class";

    EncryptionSubPageQuerydSK(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageQuerydSK-Create");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EncryptionSubPageQuerydSK-Create");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "parse");
        int len = 4;
        int pos = offset;
        byte[] tmp = new byte[]{msg[pos += 2], msg[++pos]};
        ++pos;
        this.dSKCount = new BigInteger(tmp);
        this.dSKs = new DSK[this.dSKCount.intValue()];
        for (int i = 0; i < this.dSKCount.intValue(); ++i) {
            this.dSKs[i] = new DSK(msg, pos);
            pos += this.dSKs[i].getMsgLen();
            len += this.dSKs[i].getMsgLen();
        }
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.debug.exit("logic", className, "parse");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    int getdSKCount() {
        this.debug.entry("logic", className, "getDSKCount");
        this.debug.exit("logic", className, "getDSKCount");
        return this.dSKCount.intValue();
    }

    DSK[] getdSKs() {
        this.debug.entry("logic", className, "getdSKs");
        this.debug.exit("logic", className, "getdSKs");
        return this.dSKs;
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

