/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.DKxEEDKUKI;
import com.ibm.keymanager.logic.SEDK;
import java.math.BigInteger;

class EncryptionSubPageAlterEEDKs {
    byte action;
    byte[] origMsg;
    BigInteger sedkCnt;
    BigInteger msglen;
    SEDK sedk;
    DKxEEDKUKI priorEEDKs;
    DKxEEDKUKI eedks;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionSubPageAlterEEDKs.class";

    EncryptionSubPageAlterEEDKs(String[] labels, byte[][] skis, byte[][] edks, DKxEEDKUKI oldEEDKs, byte action, int keyType, byte[] sedk, byte[] publicKeyHash) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageAlterEEDKs-Create");
        this.action = action;
        this.priorEEDKs = oldEEDKs;
        this.sedkCnt = new BigInteger("1");
        this.sedk = new SEDK(sedk, 2, 0, null, publicKeyHash, oldEEDKs.getDKX().getDKi());
        byte[] bsedk = this.sedk.encode();
        this.eedks = new DKxEEDKUKI(labels, skis, edks, oldEEDKs.getDKX().getDKi(), keyType);
        int len = 4 + bsedk.length + this.eedks.getMsgLen() + this.priorEEDKs.getMsgLen();
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[len];
        int pos = 0;
        this.origMsg[pos] = action;
        this.origMsg[pos += 2] = 0;
        this.origMsg[++pos] = 1;
        System.arraycopy(bsedk, 0, this.origMsg, ++pos, bsedk.length);
        System.arraycopy(this.priorEEDKs.getMessage(), 0, this.origMsg, pos += bsedk.length, this.priorEEDKs.getMsgLen());
        System.arraycopy(this.eedks.getMessage(), 0, this.origMsg, pos += this.priorEEDKs.getMsgLen(), this.eedks.getMsgLen());
        this.debug.exit("logic", className, "EncryptionSubPageAlterEEDKs-Create");
    }

    EncryptionSubPageAlterEEDKs(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageAlterEEDKs-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EncryptionSubPageAlterEEDKs-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = 0;
        this.debug.entry("logic", className, "parse");
        pos = offset;
        byte tmp = msg[pos];
        tmp = (byte)(msg[pos] << 6);
        this.action = (byte)(tmp >> 6);
        byte[] tmp1 = new byte[]{msg[++pos], msg[++pos]};
        this.sedkCnt = new BigInteger(tmp1);
        this.sedk = new SEDK(msg, ++pos);
        this.priorEEDKs = new DKxEEDKUKI(msg, pos += this.sedk.getLength());
        this.eedks = new DKxEEDKUKI(msg, pos += this.priorEEDKs.getMsgLen());
        int len = 4 + this.sedk.getLength() + this.eedks.getMsgLen() + this.priorEEDKs.getMsgLen();
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[len];
        System.arraycopy(msg, offset, this.origMsg, 0, len);
        this.debug.exit("logic", className, "parse");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }

    int getSEDKCount() {
        this.debug.entry("logic", className, "getSEDKCount");
        this.debug.exit("logic", className, "getSEDKCount");
        return this.sedkCnt.intValue();
    }

    SEDK getSEDK() {
        this.debug.entry("logic", className, "getSEDK");
        this.debug.exit("logic", className, "getSEDK");
        return this.sedk;
    }

    DKxEEDKUKI getDKxEEDKUKI() {
        this.debug.entry("logic", className, "getDKxEEDKUKI");
        this.debug.exit("logic", className, "getDKxEEDKUKI");
        return this.eedks;
    }

    DKxEEDKUKI getPriorDKxEEDKUKI() {
        this.debug.entry("logic", className, "getPriorDKxEEDKUKI");
        this.debug.exit("logic", className, "getPriorDKxEEDKUKI");
        return this.priorEEDKs;
    }

    byte getAction() {
        this.debug.entry("logic", className, "getAction");
        this.debug.exit("logic", className, "getAction");
        return this.action;
    }
}

