/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import java.math.BigInteger;

class EncryptionSubPage {
    byte[] structType = new byte[2];
    BigInteger structLen;
    byte responseCode;
    byte senseKey;
    byte[] info = new byte[4];
    BigInteger addSenseLen;
    byte addSenseCode;
    byte addSenseCodeQual;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionSubPage.class";

    EncryptionSubPage(byte respCode, byte senKey, byte asc, byte ascq) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPage-Create");
        this.structLen = new BigInteger("18");
        this.addSenseLen = new BigInteger("10");
        this.msglen = new BigInteger("" + (this.structLen.intValue() + 6));
        this.origMsg = new byte[this.msglen.intValue()];
        this.structType[0] = 34;
        this.structType[1] = 0;
        this.responseCode = respCode;
        this.addSenseCode = asc;
        this.addSenseCodeQual = ascq;
        this.senseKey = senKey;
        int pos = 2;
        System.arraycopy(this.structType, 0, this.origMsg, pos, this.structType.length);
        this.origMsg[pos += this.structType.length] = 0;
        this.origMsg[++pos] = 18;
        this.origMsg[++pos] = respCode;
        ++pos;
        this.origMsg[++pos] = this.senseKey;
        ++pos;
        this.origMsg[pos += 4] = 10;
        ++pos;
        this.origMsg[pos += 4] = this.addSenseCode;
        this.origMsg[++pos] = this.addSenseCodeQual;
        this.debug.exit("logic", className, "EncryptionSubPage-Create");
    }

    EncryptionSubPage(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPage-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EncryptionSubPage-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = 0;
        this.debug.entry("logic", className, "parse");
        pos = offset;
        System.arraycopy(msg, pos += 2, this.structType, 0, 2);
        pos += 2;
        if (this.structType[0] != 34 || this.structType[1] != 0) {
            this.debug.exit("logic", className, "parse", "Message type not X2200");
            throw new KeyManagerException(2, 1, "Message type not X2200");
        }
        byte[] tmp = new byte[]{msg[pos], msg[++pos]};
        ++pos;
        this.structLen = new BigInteger(tmp);
        if (this.structLen.intValue() < 18) {
            this.debug.exit("logic", className, "parse", "Structure length incorrect.");
            throw new KeyManagerException(2, 14, "Structure length incorrect.");
        }
        this.responseCode = msg[pos];
        if (this.responseCode == 64) {
            this.debug.exit("logic", className, "parse", "Response code incorrect");
            throw new KeyManagerException(2, 21, "Response code incorrect.");
        }
        ++pos;
        byte tmp1 = (byte)(msg[++pos] << 4);
        this.senseKey = (byte)(tmp1 >> 4);
        System.arraycopy(msg, ++pos, this.info, 0, 4);
        tmp = new byte[]{msg[pos += 4]};
        ++pos;
        this.addSenseLen = new BigInteger(tmp);
        if (this.addSenseLen.intValue() < 10) {
            this.debug.trace("logic", className, "parse", "Additional Sense Length wrong size");
            throw new KeyManagerException(2, 21, "Additional Sense Length wrong size");
        }
        this.addSenseCode = msg[pos += 4];
        this.addSenseCodeQual = msg[++pos];
        ++pos;
        this.msglen = new BigInteger("" + (this.structLen.intValue() + 6));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.debug.exit("logic", className, "parse");
    }

    byte getResponseCode() {
        this.debug.entry("logic", className, "getResponseCode");
        this.debug.exit("logic", className, "getResponseCode");
        return this.responseCode;
    }

    byte getSenseKey() {
        this.debug.entry("logic", className, "getSenseKey");
        this.debug.exit("logic", className, "getSenseKey");
        return this.senseKey;
    }

    byte[] getInformation() {
        this.debug.entry("logic", className, "getInformation");
        this.debug.exit("logic", className, "getInformation");
        return this.info;
    }

    byte getAdditionalSenseCode() {
        this.debug.entry("logic", className, "getAdditionalSenseCode");
        this.debug.exit("logic", className, "getAdditionalSenseCode");
        return this.addSenseCode;
    }

    byte getAdditionalSenseCodeQualifier() {
        this.debug.entry("logic", className, "getAdditionalSenseCodeQualifier");
        this.debug.exit("logic", className, "getAdditionalSenseCodeQualifier");
        return this.addSenseCodeQual;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

