/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Logic;
import java.math.BigInteger;

public class EncryptionCBDIssue {
    byte OpCode;
    byte values;
    BigInteger paramListLen;
    byte ctrlByte;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionCBDIssue.class";

    EncryptionCBDIssue(byte[] msg, int offset, int len) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionCBDIssue-Parse");
        this.parse(msg, offset, len);
        this.debug.exit("logic", className, "EncryptionCBDIssue-Parse");
    }

    EncryptionCBDIssue(int pll) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionCBDIssue-Create");
        this.paramListLen = new BigInteger("" + pll);
        this.OpCode = (byte)85;
        this.values = (byte)16;
        this.ctrlByte = 0;
        this.msglen = new BigInteger("16");
        this.origMsg = new byte[this.msglen.intValue()];
        int pos = 0;
        this.origMsg[pos] = this.OpCode;
        this.origMsg[++pos] = this.values;
        ++pos;
        System.arraycopy(Logic.IntToByteArray(pll, 2), 0, this.origMsg, pos += 5, 2);
        this.origMsg[pos += 2] = this.ctrlByte;
        ++pos;
        this.debug.exit("logic", className, "EncryptionCBDIssue-Create");
    }

    void parse(byte[] msg, int offset, int len) throws KeyManagerException {
        int pos = 0;
        this.debug.entry("logic", className, "parse");
        this.OpCode = msg[offset];
        this.msglen = new BigInteger("" + len);
        pos = offset;
        if (msg[offset] != 85) {
            this.debug.exit("logic", className, "parse", "opertation code not X55");
            throw new KeyManagerException(2, 1, "opertation code not X55");
        }
        this.origMsg = new byte[len];
        System.arraycopy(msg, offset, this.origMsg, 0, len);
        this.values = msg[++pos];
        ++pos;
        byte[] tmp = new byte[]{msg[pos += 5], msg[++pos]};
        this.paramListLen = new BigInteger(tmp);
        this.ctrlByte = msg[++pos];
        ++pos;
        this.debug.exit("logic", className, "parse");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }

    byte getOperationCode() {
        this.debug.entry("logic", className, "getOperationCode");
        this.debug.exit("logic", className, "getOperationCode");
        return this.OpCode;
    }

    int getParameterListLength() {
        this.debug.entry("logic", className, "getParameterListLength");
        this.debug.exit("logic", className, "getParameterListLength");
        return this.paramListLen.intValue();
    }

    byte getControlByte() {
        this.debug.entry("logic", className, "getControlByte");
        this.debug.exit("logic", className, "getControlByte");
        return this.ctrlByte;
    }
}

