/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.EEDK;
import com.ibm.keymanager.logic.UKI;
import java.math.BigInteger;

public class EEDKUKI {
    EEDK eedk;
    UKI uki;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EEDKUKI.class";

    EEDKUKI(String label, byte[] ski, byte[] edk, int keyType) throws KeyManagerException {
        this.debug.entry("logic", className, "EEDKUKI-Create");
        this.eedk = new EEDK(label, ski, edk, keyType);
        this.uki = new UKI(label, ski);
        this.origMsg = new byte[this.eedk.getMsgLen() + this.uki.getMsgLen()];
        System.arraycopy(this.eedk.getMessage(), 0, this.origMsg, 0, this.eedk.getMsgLen());
        System.arraycopy(this.uki.getMessage(), 0, this.origMsg, this.eedk.getMsgLen(), this.uki.getMsgLen());
        this.debug.exit("logic", className, "EEDKUKI-Create");
    }

    EEDKUKI(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EEDKUKI-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EEDKUKI-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = offset;
        this.debug.entry("logic", className, "parse");
        this.eedk = new EEDK(msg, pos);
        this.uki = new UKI(msg, pos += this.eedk.getMsgLen());
        this.origMsg = new byte[this.eedk.getMsgLen() + this.uki.getMsgLen()];
        System.arraycopy(this.eedk.getMessage(), 0, this.origMsg, 0, this.eedk.getMsgLen());
        System.arraycopy(this.uki.getMessage(), 0, this.origMsg, this.eedk.getMsgLen(), this.uki.getMsgLen());
        this.debug.exit("logic", className, "parse");
    }

    EEDK getEEDK() {
        this.debug.entry("logic", className, "getEEDK");
        this.debug.exit("logic", className, "getEEDK");
        return this.eedk;
    }

    UKI getUKI() {
        this.debug.entry("logic", className, "getUKI");
        this.debug.exit("logic", className, "getUKI");
        return this.uki;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.uki.getMsgLen() + this.eedk.getMsgLen();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

