/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import java.math.BigInteger;

class DKx {
    byte indirectDKi;
    byte prevDKi;
    byte transDKi;
    byte copyDKi;
    byte encMethod;
    byte[] dkiType = new byte[2];
    BigInteger dkiLen;
    byte[] dki;
    byte[] dkvType = new byte[2];
    BigInteger dkvLen;
    byte[] dkv;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "DKx.class";

    DKx(byte[] dki, byte[] dkv, byte indirectDKi, byte prevDKi, byte transDKi, byte copyDKi, byte encMethod) throws KeyManagerException {
        this.debug.entry("logic", className, "DKx-Create");
        if (dki != null && dki.length != 12) {
            this.debug.exit("logic", className, "DKx-Create", "Dki wrong Length");
            throw new KeyManagerException(2, 3, "Dki wrong Length");
        }
        if (dkv != null && dkv.length != 16) {
            this.debug.exit("logic", className, "DKx-Create", "Dkv wrong Length");
            throw new KeyManagerException(2, 4, "Dkv wrong Length");
        }
        this.dki = dki;
        this.dkv = dkv;
        this.indirectDKi = indirectDKi;
        this.prevDKi = prevDKi;
        this.transDKi = transDKi;
        this.copyDKi = copyDKi;
        this.encMethod = encMethod;
        this.dkiType[0] = 26;
        this.dkiType[1] = 0;
        int len = 8;
        if (dki == null) {
            this.dkiLen = BigInteger.ZERO;
        } else {
            this.dkiLen = new BigInteger("" + dki.length);
            len += dki.length;
        }
        len += 4;
        if (dkv == null) {
            this.dkvLen = BigInteger.ZERO;
        } else {
            this.dkvLen = new BigInteger("" + dkv.length);
            len += dkv.length;
        }
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[this.msglen.intValue()];
        int pos = 0;
        this.origMsg[pos] = (byte)(indirectDKi << 7 | prevDKi << 6 | transDKi << 5 | copyDKi << 4);
        this.origMsg[++pos] = encMethod;
        ++pos;
        System.arraycopy(this.dkiType, 0, this.origMsg, pos += 2, this.dkiType.length);
        pos += this.dkiType.length;
        if (dki != null) {
            this.origMsg[pos] = 0;
            this.origMsg[++pos] = 12;
            System.arraycopy(dki, 0, this.origMsg, ++pos, dki.length);
            pos += dki.length;
        } else {
            this.origMsg[pos] = 0;
            this.origMsg[++pos] = 0;
            ++pos;
        }
        this.dkvType[0] = 27;
        this.dkvType[1] = 0;
        System.arraycopy(this.dkvType, 0, this.origMsg, pos, this.dkvType.length);
        pos += this.dkvType.length;
        if (dkv != null) {
            this.origMsg[pos] = 0;
            this.origMsg[++pos] = 16;
            System.arraycopy(dkv, 0, this.origMsg, ++pos, dkv.length);
        } else {
            this.origMsg[pos] = 0;
            this.origMsg[++pos] = 0;
            ++pos;
        }
        this.debug.exit("logic", className, "DKx-Create");
    }

    DKx(byte[] msg, int offset, int len) throws KeyManagerException {
        this.debug.entry("logic", className, "DKx-Parse");
        this.parse(msg, offset, len);
        this.debug.exit("logic", className, "DKx-Parse");
    }

    void parse(byte[] msg, int offset, int len) throws KeyManagerException {
        int pos = offset;
        this.debug.entry("logic", className, "parse");
        this.indirectDKi = (byte)(msg[pos] >> 7);
        this.prevDKi = (byte)(msg[pos] << 1 >> 7);
        this.transDKi = (byte)(msg[pos] << 2 >> 7);
        this.copyDKi = (byte)(msg[pos] << 3 >> 7);
        this.encMethod = msg[++pos];
        ++pos;
        System.arraycopy(msg, pos += 2, this.dkiType, 0, this.dkiType.length);
        pos += this.dkiType.length;
        if (this.dkiType[0] != 26 || this.dkiType[1] != 0) {
            this.debug.exit("logic", className, "parse", "Message type not X1A00");
            throw new KeyManagerException(2, 1, "Message type not X1A00");
        }
        byte[] tmp = new byte[]{msg[pos], msg[++pos]};
        ++pos;
        this.dkiLen = new BigInteger(tmp);
        this.dki = new byte[this.dkiLen.intValue()];
        if (this.dkiLen.intValue() != 0) {
            System.arraycopy(msg, pos, this.dki, 0, this.dki.length);
        }
        if (len > (pos += this.dkiLen.intValue()) + 1) {
            System.arraycopy(msg, pos, this.dkvType, 0, this.dkvType.length);
            pos += this.dkvType.length;
            if (this.dkvType[0] != 27 || this.dkiType[1] != 0) {
                this.debug.exit("logic", className, "parse", "Message type not X1B00");
                throw new KeyManagerException(2, 1, "Message type not X1B00");
            }
            tmp = new byte[]{msg[pos], msg[++pos]};
            ++pos;
            this.dkvLen = new BigInteger(tmp);
            this.dkv = new byte[this.dkvLen.intValue()];
            if (this.dkvLen.intValue() != 0) {
                System.arraycopy(msg, pos, this.dkv, 0, this.dkv.length);
            }
        }
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.debug.exit("logic", className, "parse");
    }

    byte getIndirectDKiMethod() {
        this.debug.entry("logic", className, "getIndirectDKiMethod");
        this.debug.exit("logic", className, "getIndirectDKiMethod");
        return this.indirectDKi;
    }

    byte getPreviousDKi() {
        this.debug.entry("logic", className, "getIndirectDKiMethod");
        this.debug.exit("logic", className, "getIndirectDKiMethod");
        return this.prevDKi;
    }

    byte getTranslatedDKi() {
        this.debug.entry("logic", className, "getPreviousDKi");
        this.debug.exit("logic", className, "getPreviousDKi");
        return this.transDKi;
    }

    byte getCopiedDKi() {
        this.debug.entry("logic", className, "getCopiedDKi");
        this.debug.exit("logic", className, "getCopiedDKi");
        return this.copyDKi;
    }

    byte[] getDKiType() {
        this.debug.entry("logic", className, "getDKiType");
        this.debug.exit("logic", className, "getDKiType");
        return this.dkiType;
    }

    int getDKiLen() {
        this.debug.entry("logic", className, "getDKiLen");
        this.debug.exit("logic", className, "getDKiLen");
        return this.dkiLen.intValue();
    }

    byte[] getDKi() {
        this.debug.entry("logic", className, "getDKi");
        this.debug.exit("logic", className, "getDKi");
        return this.dki;
    }

    byte[] getDKvType() {
        this.debug.entry("logic", className, "getDKvType");
        this.debug.exit("logic", className, "getDKvType");
        return this.dkvType;
    }

    int getDKvLen() {
        this.debug.entry("logic", className, "getDKvLen");
        this.debug.exit("logic", className, "getDKvLen");
        return this.dkvLen.intValue();
    }

    byte[] getDKv() {
        this.debug.entry("logic", className, "getDKv");
        this.debug.exit("logic", className, "getDKv");
        return this.dkv;
    }

    byte getEncryptionMethod() {
        this.debug.entry("logic", className, "getEncryptionMethod");
        this.debug.exit("logic", className, "getEncryptionMethod");
        return this.encMethod;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

