/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.keystore;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.audit.ResourceMgmt_Event;
import com.ibm.keymanager.config.Config;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeyStoreLoader {
    private static KeyStoreLoader instance;
    private HashMap ksList = new HashMap(3);
    private HashMap tsList = new HashMap(3);
    private HashMap tmList = new HashMap(1);
    private HashMap kmList = new HashMap(1);
    private Config config;
    private KMSDebug dbg;
    private Audit audit = Audit.getInstance();
    public static final String ADMIN_KEYSTORE = "AdminKS";
    public static final String LISTENER_KEYSTORE = "ListKS";
    public static final String TAPEDRIVE_KEYSTORE = "TapeKS";
    static final String ADMIN_KS_NAME = "Admin.ssl.keystore.name";
    static final String ADMIN_KS_TYPE = "Admin.ssl.keystore.type";
    static final String ADMIN_KS_PASSWORD = "Admin.ssl.keystore.password";
    static final String ADMIN_TS_NAME = "Admin.ssl.truststore.name";
    static final String ADMIN_TS_TYPE = "Admin.ssl.truststore.type";
    static final String TRANSPORT_KS_NAME = "TransportListener.ssl.keystore.name";
    static final String TRANSPORT_KS_TYPE = "TransportListener.ssl.keystore.type";
    static final String TRANSPORT_KS_PASSWORD = "TransportListener.ssl.keystore.password";
    static final String TRANSPORT_TS_NAME = "TransportListener.ssl.truststore.name";
    static final String TRANSPORT_TS_TYPE = "TransportListener.ssl.truststore.type";
    static final String TAPE_KS_PROVIDER = "config.keystore.provider";
    static final String TAPE_KS_TYPE = "config.keystore.type";
    static final String TAPE_KS_FILE = "config.keystore.file";
    static final String TAPE_KS_PASSWORD = "config.keystore.password";

    private KeyStoreLoader(Config conf, KMSDebug debug) {
        this.config = conf;
        this.dbg = debug;
    }

    public static KeyStoreLoader getInstance(Config conf, KMSDebug debug) throws KeyManagerException {
        if (conf == null) {
            throw new KeyManagerException("Null config object");
        }
        if (debug == null) {
            throw new KeyManagerException("Null Debug object");
        }
        if (instance != null) {
            return instance;
        }
        instance = new KeyStoreLoader(conf, debug);
        return instance;
    }

    public static KeyStoreLoader getInstance() {
        if (instance != null) {
            return instance;
        }
        return null;
    }

    public KeyManager[] loadKeyManagers(String target, char[] pwd) throws KeyManagerException {
        Object obj = this.kmList.get(target);
        if (obj != null) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyManagers", "found " + target);
            return (KeyManager[])obj;
        }
        if (pwd == null) {
            return null;
        }
        this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyManagers", "load " + target);
        KeyStore keyStore = this.loadKeyStore(target, pwd);
        KeyManagerFactory kmf = null;
        try {
            kmf = KeyManagerFactory.getInstance("IbmX509", "IBMJSSE2");
            kmf.init(keyStore, pwd);
        }
        catch (Exception ex) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyManagers", ex);
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        KeyManager[] kms = kmf.getKeyManagers();
        if (kms != null) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyManagers", "Initialize key managers, put in list");
        }
        this.kmList.put(target, kms);
        return kms;
    }

    public TrustManager[] loadTrustManagers(String target) throws KeyManagerException {
        Object obj = this.tmList.get(target);
        if (obj != null) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustManagers", "found " + target);
            return (TrustManager[])obj;
        }
        this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustManagers", "load " + target);
        KeyStore trustStore = this.loadTrustStore(target);
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance("IbmX509", "IBMJSSE2");
            tmf.init(trustStore);
        }
        catch (Exception ex) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustManagers", ex);
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        TrustManager[] tms = tmf.getTrustManagers();
        this.tmList.put(target, tms);
        return tms;
    }

    public KeyStore loadTrustStore(String target) throws KeyManagerException {
        Object ts = null;
        if (target.equalsIgnoreCase(ADMIN_KEYSTORE)) {
            return this.loadTrustStore(ADMIN_TS_NAME, ADMIN_TS_TYPE);
        }
        if (target.equalsIgnoreCase(LISTENER_KEYSTORE)) {
            return this.loadTrustStore(TRANSPORT_TS_NAME, TRANSPORT_TS_TYPE);
        }
        throw new KeyManagerException("Unexpected target");
    }

    private KeyStore loadTrustStore(String name_key, String type_key) throws KeyManagerException {
        this.dbg.entry("keystore", "KeyStoreLoader", "loadTrustStore");
        KeyStore ts = null;
        String ts_name = this.initProp(name_key);
        if (ts_name == null) {
            throw new KeyManagerException("Must specify trust store name");
        }
        String ts_type = this.initProp(type_key);
        if (ts_type == null) {
            ts_type = "jks";
        }
        if ((ts = (KeyStore)this.ksList.get(ts_name)) != null) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustStore", "found " + ts_name + " from key store list");
            return ts;
        }
        ts = (KeyStore)this.tsList.get(ts_name);
        if (ts != null) {
            if (ts_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                throw new KeyManagerException("You can use hardware crypto keystore for client side SSL connection or server side SSL connection, but not both");
            }
            this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustStore", "found " + ts_name + " from trust store list");
            return ts;
        }
        try {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustStore", "load " + ts_name);
            if (ts_type.equalsIgnoreCase("PKCS11IMPLS")) {
                ts = this.loadHWKeyStore(ts_name, null);
            } else {
                ts = KeyStore.getInstance(ts_type);
                ts.load(new FileInputStream(ts_name), null);
            }
        }
        catch (Exception ex) {
            try {
                if (this.audit.isOn("resource_management", "failure")) {
                    ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "retrieve", ts_name, "KMSAdmin", false);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex2) {
                this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustStore", ex2);
            }
            this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustStore", ex);
            throw (KeyManagerException)new KeyManagerException(ex.getMessage()).initCause(ex);
        }
        try {
            if (this.audit.isOn("resource_management", "success")) {
                ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "retrieve", ts_name, "KMSAdmin", true);
                this.audit.record(event);
            }
        }
        catch (KeyManagerException ex) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadTrustStore", ex);
        }
        this.tsList.put(ts_name, ts);
        return ts;
    }

    public KeyStore loadKeyStore(String target, char[] password) throws KeyManagerException {
        if (target.equalsIgnoreCase(ADMIN_KEYSTORE)) {
            return this.loadKeyStore(ADMIN_KS_NAME, ADMIN_KS_TYPE, password);
        }
        if (target.equalsIgnoreCase(LISTENER_KEYSTORE)) {
            return this.loadKeyStore(TRANSPORT_KS_NAME, TRANSPORT_KS_TYPE, password);
        }
        if (target.equalsIgnoreCase(TAPEDRIVE_KEYSTORE)) {
            return this.loadKeyStore(TAPE_KS_FILE, TAPE_KS_TYPE, password);
        }
        throw new KeyManagerException("Unexpected target");
    }

    private KeyStore loadHWKeyStore(String ks_name, char[] pwd) throws KeyManagerException {
        IBMPKCS11Impl p1 = null;
        Class<?> cls = null;
        if (Security.getProviders("KeyStore.PKCS11IMPLKS") == null) {
            try {
                cls = Class.forName("com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl");
            }
            catch (Exception e) {
                throw new KeyManagerException(e.toString());
            }
            Preferences prefs = Preferences.userNodeForPackage(cls);
            prefs.put("IBMPKCSImpl DLL", ks_name);
            prefs.put("IBMPKCSImpl password", new String(pwd));
            p1 = new IBMPKCS11Impl();
            try {
                prefs.remove("IBMPKCSImpl DLL");
                prefs.remove("IBMPKCSImpl password");
            }
            catch (Exception e) {
                this.dbg.trace("keystore", "KeyStoreLoader", "loadHWKeyStore", e);
            }
            Security.addProvider((Provider)p1);
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS11IMPLKS");
            ks.load(null, pwd);
            return ks;
        }
        catch (Exception ex) {
            throw new KeyManagerException(ex.toString());
        }
    }

    private KeyStore loadKeyStore(String name_key, String type_key, char[] pwdchars) throws KeyManagerException {
        KeyStore ks = null;
        String ks_name = this.initProp(name_key);
        if (ks_name == null) {
            throw new KeyManagerException("Must specify key store name");
        }
        ks = (KeyStore)this.ksList.get(ks_name);
        String ks_type = this.initProp(type_key);
        if (ks_type == null) {
            ks_type = "jks";
        }
        if (ks != null) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyStore", "found " + ks_name);
            return ks;
        }
        try {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyStore", "load " + ks_name);
            if (ks_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                ks = this.loadHWKeyStore(ks_name, pwdchars);
            } else {
                ks = KeyStore.getInstance(ks_type);
                ks.load(new FileInputStream(ks_name), pwdchars);
            }
        }
        catch (Exception ex) {
            try {
                if (this.audit.isOn("resource_management", "failure")) {
                    ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "retrieve", ks_name, "KMSAdmin", false);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex2) {
                this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyStore", ex2);
            }
            this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyStore", ex);
            throw (KeyManagerException)new KeyManagerException(ex.getMessage()).initCause(ex);
        }
        try {
            if (this.audit.isOn("resource_management", "success")) {
                ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "retrieve", ks_name, "KMSAdmin", true);
                this.audit.record(event);
            }
        }
        catch (KeyManagerException ex) {
            this.dbg.trace("keystore", "KeyStoreLoader", "loadKeyStore", ex);
        }
        this.ksList.put(ks_name, ks);
        return ks;
    }

    private String initProp(String key) {
        String value = null;
        try {
            value = (String)this.config.get(key);
        }
        catch (KeyManagerException ex) {
            // empty catch block
        }
        if (value == null) {
            try {
                value = (String)this.config.get(key.substring(key.indexOf(".") + 1));
            }
            catch (KeyManagerException keyManagerException) {
                // empty catch block
            }
        }
        return value;
    }

    public void removeAll() {
        this.kmList.clear();
        this.tmList.clear();
        this.ksList.clear();
        this.tsList.clear();
        instance = null;
    }
}

