/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.drivetable.file;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.drivetable.DriveTableEntrySpi;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TapeDriveTableEntry
extends DriveTableEntrySpi {
    public HashMap entryMap;
    public Date TimeStamp = new Date();
    public boolean updated;
    public boolean deleted;
    public static final String TAPEDRIVE_SN = "SerialNumber";
    public static final String TAPEDRIVE_WWN = "WorldWideName";
    public static final String TAPEDRIVE_CALIAS = "CertAlias";
    public static final String TAPEDRIVE_ADDR = "HostAddress";
    public static final String TAPEDRIVE_ALIAS1 = "AliasOne";
    public static final String TAPEDRIVE_ALIAS2 = "AliasTwo";
    public static final String TAPEDRIVE_DRIVECERT = "DriveCert";
    public static final String TAPEDRIVE_DAK = "dAK";
    public static final String TAPEDRIVE_DSK = "dSK";
    public static final String TAPEDRIVE_HMAC = "HMACMethod";
    public static final String TAPEDRIVE_HMAC_SECRET = "HMACSecret";
    public static final String TAPEDRIVE_EXTRA_INFO = "ExtraInformation";
    public static final int TAPEDRIVE_SIZE = 12;
    private String className = "com.ibm.keymanager.drivetable.file.TapeDriveTableEntry";
    private KMSDebug debug;

    public void init(byte[] WorldWideName, byte[] DriveSN, Map mapObjects) throws KeyManagerException {
        this.debug = KMSDebug.getInstance();
        if (DriveSN == null) {
            throw new KeyManagerException("Null tape drive Serial Number");
        }
        this.entryMap = new HashMap(12);
        this.setSN(DriveSN);
        if (WorldWideName != null) {
            this.setWWName(WorldWideName);
        }
        if (mapObjects != null) {
            this.setObjects(mapObjects);
        }
        this.updated = false;
    }

    public void init(byte[] encoding) throws KeyManagerException {
        this.debug = KMSDebug.getInstance();
        if (encoding == null) {
            throw new KeyManagerException("Null encoding not supported");
        }
        this.importData(encoding);
    }

    public void setObjects(Map mapObjects) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " setObjects");
        }
        if (mapObjects == null) {
            throw new KeyManagerException("Null objects not supported");
        }
        Set temp = mapObjects.keySet();
        String itr = null;
        Iterator entry = temp.iterator();
        while (entry.hasNext()) {
            try {
                itr = (String)entry.next();
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (!this.isValidEntryType(itr)) continue;
            Object obj = mapObjects.get(itr);
            this.entryMap.put(itr, obj);
            this.TimeStamp = new Date();
            this.updated = true;
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " setObjects");
        }
    }

    public byte[] getWWName() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " getWWName");
        }
        if (this.entryMap.containsKey(TAPEDRIVE_WWN)) {
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, " getWWName");
            }
            return (byte[])this.entryMap.get(TAPEDRIVE_WWN);
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " getWWName");
        }
        return null;
    }

    public void setWWName(byte[] WorldWideName) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " setWWName");
        }
        if (WorldWideName == null) {
            throw new KeyManagerException("null tape drive world wide number");
        }
        this.entryMap.put(TAPEDRIVE_WWN, WorldWideName);
        this.TimeStamp = new Date();
        this.updated = true;
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " setWWName");
        }
    }

    public byte[] getSN() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " getSN");
        }
        if (this.entryMap.containsKey(TAPEDRIVE_SN)) {
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, " getSN");
            }
            return (byte[])this.entryMap.get(TAPEDRIVE_SN);
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " getSN");
        }
        return null;
    }

    public void setSN(byte[] SerialNumber) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " setSN");
        }
        if (SerialNumber == null) {
            throw new KeyManagerException("null tape drive serial number");
        }
        this.entryMap.put(TAPEDRIVE_SN, SerialNumber);
        this.TimeStamp = new Date();
        this.updated = true;
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " setSN");
        }
    }

    public boolean isUpdated() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "isUpdated");
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "isUpdated");
        }
        return this.updated;
    }

    public boolean isDeleted() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "isDeleted");
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "isDeleted");
        }
        return this.deleted;
    }

    public void setDeleted() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "setDeleted");
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "setDeleted");
        }
        this.deleted = true;
    }

    public void setUpdated() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "setUpdated");
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "setUpdated");
        }
        this.TimeStamp = new Date();
        this.updated = true;
    }

    public boolean equalsEntry(String tableEntry, Object object) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "equalsEntry");
        }
        if (tableEntry == null && object == null) {
            return false;
        }
        if (this.isValidEntryType(tableEntry)) {
            if (this.entryMap.containsKey(tableEntry)) {
                if (this.debug.isOn("drivetable")) {
                    this.debug.exit("drivetable", this.className, "equalsEntry");
                }
                return this.entryMap.containsValue(object);
            }
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, "equalsEntry");
            }
            return false;
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "equalsEntry");
        }
        return false;
    }

    public Object getObject(String tableType) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "getObject");
        }
        if (tableType == null) {
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, "getObject");
            }
            return null;
        }
        if (this.isValidEntryType(tableType)) {
            if (this.entryMap.containsKey(tableType)) {
                if (this.debug.isOn("drivetable")) {
                    this.debug.exit("drivetable", this.className, "getObject");
                }
                return this.entryMap.get(tableType);
            }
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, "getObject");
            }
            return null;
        }
        throw new KeyManagerException("not valid table type");
    }

    public void setObject(String tableType, Object tableObject) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "setObject");
        }
        if (tableType == null) {
            throw new KeyManagerException("null table type");
        }
        if (this.isValidEntryType(tableType)) {
            if (tableObject == null) {
                throw new KeyManagerException("null object input");
            }
        } else {
            throw new KeyManagerException("invalid table entry label");
        }
        this.entryMap.put(tableType, tableObject);
        this.TimeStamp = new Date();
        this.updated = true;
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "setObject");
        }
    }

    public Date getTimeStamp() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "getTimeStamp");
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "getTimeStamp");
        }
        return this.TimeStamp;
    }

    public String toEntryString() {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "toEntryString");
        }
        String output = "-----------------------------------------------\n";
        Set keys = this.entryMap.keySet();
        Iterator keySet = keys.iterator();
        while (keySet.hasNext()) {
            output = output + "\n";
            String nextKey = keySet.next().toString();
            output = output + "Entry Key:  " + nextKey + " = ";
            Object test = this.entryMap.get(nextKey);
            String ent = test instanceof byte[] ? new String((byte[])test) : (String)test;
            output = output + ent;
            output = output + "\n";
        }
        try {
            output = output + " Deleted : " + this.isDeleted() + "\n";
            output = output + " Updated : " + this.isUpdated() + "\n";
            output = output + " TimeStamp : " + this.getTimeStamp() + "\n";
        }
        catch (Exception exc) {
            // empty catch block
        }
        output = output + "\n";
        output = output + "-----------------------------------------------\n";
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "toEntryString");
        }
        return output;
    }

    public boolean isValidEntryType(String type) {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "isValidEntryType");
        }
        if (type != null) {
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, "isValidEntryType");
            }
            return type.equalsIgnoreCase(TAPEDRIVE_SN) || type.equalsIgnoreCase(TAPEDRIVE_WWN) || type.equalsIgnoreCase(TAPEDRIVE_CALIAS) || type.equalsIgnoreCase(TAPEDRIVE_ADDR) || type.equalsIgnoreCase(TAPEDRIVE_ALIAS1) || type.equalsIgnoreCase(TAPEDRIVE_ALIAS2) || type.equalsIgnoreCase(TAPEDRIVE_DRIVECERT) || type.equalsIgnoreCase(TAPEDRIVE_DAK) || type.equalsIgnoreCase(TAPEDRIVE_DSK) || type.equalsIgnoreCase(TAPEDRIVE_HMAC) || type.equalsIgnoreCase(TAPEDRIVE_HMAC_SECRET) || type.equalsIgnoreCase(TAPEDRIVE_EXTRA_INFO);
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "isValidEntryType");
        }
        return false;
    }

    private void importData(byte[] data) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "importData");
        }
        if (data == null) {
            throw new KeyManagerException("Null input data");
        }
        try {
            DerValue dataInput = new DerValue(data);
            if (dataInput.getTag() != 48) {
                throw new KeyManagerException("bad encoding");
            }
            DerValue subDer = dataInput.getData().getDerValue();
            byte tag = subDer.getTag();
            if ((tag & 0x1F) == 0) {
                byte[] driveSN = subDer.getData().getOctetString();
                if (driveSN == null) {
                    throw new KeyManagerException("Null tape drive Serial Number");
                }
                this.entryMap = new HashMap(12);
                this.setSN(driveSN);
            } else {
                throw new KeyManagerException("Null tape drive Serial Number tag");
            }
            subDer = dataInput.getData().getDerValue();
            tag = subDer.getTag();
            if ((tag & 0x1F) == 1) {
                byte[] driveWWN = subDer.getData().getOctetString();
                if (driveWWN != null) {
                    this.setWWName(driveWWN);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 2) {
                String certAlias = subDer.getData().getGeneralString();
                if (certAlias != null) {
                    this.setObject(TAPEDRIVE_CALIAS, certAlias);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 3) {
                String hostAddress = subDer.getData().getGeneralString();
                if (hostAddress != null) {
                    this.setObject(TAPEDRIVE_ADDR, hostAddress);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 4) {
                String aliasOne = subDer.getData().getGeneralString();
                if (aliasOne != null) {
                    this.setObject(TAPEDRIVE_ALIAS1, aliasOne);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 5) {
                String aliasTwo = subDer.getData().getGeneralString();
                if (aliasTwo != null) {
                    this.setObject(TAPEDRIVE_ALIAS2, aliasTwo);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 6) {
                subDer.getData().getNull();
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 7) {
                byte[] driveDak = subDer.getData().getOctetString();
                if (driveDak != null) {
                    this.setObject(TAPEDRIVE_DAK, driveDak);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 8) {
                byte[] driveDsk = subDer.getData().getOctetString();
                if (driveDsk != null) {
                    this.setObject(TAPEDRIVE_DAK, driveDsk);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 9) {
                String HMACAlgo = subDer.getData().getGeneralString();
                if (HMACAlgo != null) {
                    this.setObject(TAPEDRIVE_HMAC, HMACAlgo);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 16) {
                byte[] HMACSecret = subDer.getData().getOctetString();
                if (HMACSecret != null) {
                    this.setObject(TAPEDRIVE_HMAC_SECRET, HMACSecret);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 17) {
                byte[] driveExtraInfo = subDer.getData().getOctetString();
                if (driveExtraInfo != null) {
                    this.setObject(TAPEDRIVE_EXTRA_INFO, driveExtraInfo);
                }
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 18) {
                this.TimeStamp = subDer.getData().getUTCTime();
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 19) {
                this.updated = subDer.getData().getDerValue().getBoolean();
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) == 20) {
                this.deleted = subDer.getData().getDerValue().getBoolean();
                subDer = dataInput.getData().getDerValue();
                tag = subDer.getTag();
            }
            if ((tag & 0x1F) != 21) {
                throw new KeyManagerException("Imported Data not Terminated");
            }
            subDer.getData().getNull();
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc);
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, "importData");
        }
    }

    public byte[] exportData() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, "exportData");
        }
        try {
            DerOutputStream tapDriveEntryDER = new DerOutputStream();
            DerOutputStream tapDriveEntryDataDER = new DerOutputStream();
            DerOutputStream dataDer = new DerOutputStream();
            if (!this.entryMap.containsKey(TAPEDRIVE_SN)) {
                throw new KeyManagerException("Encoding must contain Drive SN");
            }
            byte[] driveSN = (byte[])this.entryMap.get(TAPEDRIVE_SN);
            dataDer.putOctetString(driveSN);
            tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), dataDer);
            if (this.entryMap.containsKey(TAPEDRIVE_WWN)) {
                dataDer = new DerOutputStream();
                byte[] driveWWN = (byte[])this.entryMap.get(TAPEDRIVE_WWN);
                dataDer.putOctetString(driveWWN);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_CALIAS)) {
                dataDer = new DerOutputStream();
                String cAlias = (String)this.entryMap.get(TAPEDRIVE_CALIAS);
                dataDer.putGeneralString(cAlias);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_ADDR)) {
                dataDer = new DerOutputStream();
                String tAddr = (String)this.entryMap.get(TAPEDRIVE_ADDR);
                dataDer.putGeneralString(tAddr);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_ALIAS1)) {
                dataDer = new DerOutputStream();
                String tAliasOne = (String)this.entryMap.get(TAPEDRIVE_ALIAS1);
                dataDer.putGeneralString(tAliasOne);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_ALIAS2)) {
                dataDer = new DerOutputStream();
                String tAliasTwo = (String)this.entryMap.get(TAPEDRIVE_ALIAS2);
                dataDer.putGeneralString(tAliasTwo);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_DRIVECERT)) {
                dataDer = new DerOutputStream();
                dataDer.putNull();
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_DAK)) {
                dataDer = new DerOutputStream();
                byte[] tDak = (byte[])this.entryMap.get(TAPEDRIVE_DAK);
                dataDer.putOctetString(tDak);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_DSK)) {
                dataDer = new DerOutputStream();
                byte[] tDsk = (byte[])this.entryMap.get(TAPEDRIVE_DSK);
                dataDer.putOctetString(tDsk);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_HMAC)) {
                dataDer = new DerOutputStream();
                String tHmacAlgo = (String)this.entryMap.get(TAPEDRIVE_HMAC);
                dataDer.putGeneralString(tHmacAlgo);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_HMAC_SECRET)) {
                dataDer = new DerOutputStream();
                byte[] tHmacSecret = (byte[])this.entryMap.get(TAPEDRIVE_HMAC_SECRET);
                dataDer.putOctetString(tHmacSecret);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)16), dataDer);
            }
            if (this.entryMap.containsKey(TAPEDRIVE_EXTRA_INFO)) {
                dataDer = new DerOutputStream();
                byte[] tExtraInfo = (byte[])this.entryMap.get(TAPEDRIVE_EXTRA_INFO);
                dataDer.putOctetString(tExtraInfo);
                tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)17), dataDer);
            }
            dataDer = new DerOutputStream();
            dataDer.putUTCTime(this.TimeStamp);
            tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)18), dataDer);
            dataDer = new DerOutputStream();
            dataDer.putBoolean(this.updated);
            tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)19), dataDer);
            dataDer = new DerOutputStream();
            dataDer.putBoolean(this.deleted);
            tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)20), dataDer);
            dataDer = new DerOutputStream();
            dataDer.putNull();
            tapDriveEntryDataDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)21), dataDer);
            tapDriveEntryDER.write((byte)48, tapDriveEntryDataDER);
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, "exportData");
            }
            return tapDriveEntryDER.toByteArray();
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc);
        }
    }
}

