/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.ResourceInfo;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import java.util.Date;

public class ResourceMgmt_Event
implements Security_Event {
    private Object source;
    private String action;
    private ResourceInfo resource;
    private UserInfo user;
    private AuditOutcomeType outcome;
    private String message;
    private Date timestamp;

    public ResourceMgmt_Event(Object source, String action, ResourceInfo resource, UserInfo user, AuditOutcomeType outcome) {
        this.source = source;
        this.action = action;
        this.user = user;
        this.outcome = outcome;
        this.timestamp = new Date();
    }

    public ResourceMgmt_Event(Object source, String action, String resource, String user, boolean outcome) {
        this.source = source;
        this.action = action;
        this.resource = new ResourceInfo(resource);
        this.user = new UserInfo(user);
        this.outcome = new AuditOutcomeType(outcome);
        this.timestamp = new Date();
    }

    public String getAction() {
        return this.action;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public ResourceInfo getResource() {
        return this.resource;
    }

    public void setAuditMsg(String msg) {
        this.message = msg;
    }

    public String getAuditMsg() {
        return this.message;
    }

    public String getEventType() {
        return "SECURITY_MGMT_RESOURCE";
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getEventSource() {
        return this.source;
    }

    public AuditOutcomeType getOutcome() {
        return this.outcome;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Resource management event:[");
        sb.append("\n  timestamp=" + this.timestamp);
        sb.append("\n  event source=" + this.source.getClass().getName());
        sb.append("\n  outcome=" + this.outcome.toString());
        sb.append("\n  event type=SECURITY_MGMT_RESOURCE");
        if (this.message != null) {
            sb.append("\n  message=" + this.message);
        }
        sb.append("\n  action=" + this.action);
        sb.append("\n  user=" + this.user);
        sb.append("\n  resource=" + this.resource);
        sb.append("\n  ]\n");
        return sb.toString();
    }
}

