/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ResourceInfo {
    public static final String TYPE_APPLICATION = "application";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_USER = "user";
    public static final String NAME_DRIVETABLE = "TKMS drive table";
    public static final String NAME_CONFIGFILE = "TKMS configuration file";
    private String nameInApp;
    private String nameInPolicy = "Not Available";
    private String type = "file";
    private Long uuid;
    private HashMap attributes;

    public ResourceInfo(String nameInApp) {
        this.nameInApp = nameInApp;
    }

    public ResourceInfo(String nameInApp, String type) {
        this.nameInApp = nameInApp;
        this.type = type;
    }

    public ResourceInfo(String nameInApp, String nameInPolicy, String type) {
        this.nameInApp = nameInApp;
        this.nameInPolicy = nameInPolicy;
        this.type = type;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Set getAttributeNames() {
        if (this.attributes != null) {
            return Collections.unmodifiableSet(this.attributes.keySet());
        }
        return null;
    }

    public String getAttribute(String name) {
        if (this.attributes != null) {
            return (String)this.attributes.get(name);
        }
        return null;
    }

    public void setUniqueId(Long uuid) {
        this.uuid = uuid;
    }

    public Long getUniqueId() {
        return this.uuid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("name=" + this.nameInApp);
        if (this.nameInPolicy != "Not Available") {
            sb.append(";name in policy=" + this.nameInPolicy);
        }
        sb.append(";type=" + this.type);
        if (this.uuid != null) {
            sb.append(";uuid=" + this.uuid.toString());
        }
        if (this.attributes != null) {
            Set keyset = this.attributes.keySet();
            Iterator it = keyset.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.attributes.get(key);
                sb.append(";" + key + "=" + value);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

