/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.ResourceInfo;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import java.util.Date;

public class DataSync_Event
implements Security_Event {
    public static final String ACTION_RECONCILE = "reconcile";
    public static final String ACTION_UNSOLICITED_NOTIFICATION = "unsolicitedNotification";
    private Object source;
    private Date timestamp = new Date();
    private String message;
    private String action = "reconcile";
    private ResourceInfo resource;
    private AuditOutcomeType outcome;
    private UserInfo user;

    public DataSync_Event(Object source, String action, ResourceInfo resource, AuditOutcomeType outcome) {
        this.source = source;
        this.action = action;
        this.resource = resource;
        this.outcome = outcome;
    }

    public DataSync_Event(Object source, String action, ResourceInfo resource, UserInfo user, AuditOutcomeType outcome) {
        this.source = source;
        this.action = action;
        this.resource = resource;
        this.user = user;
        this.outcome = outcome;
    }

    public DataSync_Event(Object source, String resource, boolean outcome) {
        this.source = source;
        this.resource = new ResourceInfo(resource);
        this.outcome = new AuditOutcomeType(outcome);
    }

    public DataSync_Event(Object source, String resource, String user, boolean outcome) {
        this.source = source;
        this.resource = new ResourceInfo(resource);
        this.user = new UserInfo(user);
        this.outcome = new AuditOutcomeType(outcome);
    }

    public String getAction() {
        return this.action;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public ResourceInfo getResource() {
        return this.resource;
    }

    public void setAuditMsg(String msg) {
        this.message = msg;
    }

    public String getAuditMsg() {
        return this.message;
    }

    public String getEventType() {
        return "SECURITY_DATA_SYNC";
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getEventSource() {
        return this.source;
    }

    public AuditOutcomeType getOutcome() {
        return this.outcome;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Data synchronization event:[");
        sb.append("\n  timestamp=" + this.timestamp);
        sb.append("\n  event source=" + this.source.getClass().getName());
        sb.append("\n  outcome=" + this.outcome.toString());
        sb.append("\n  event type=SECURITY_DATA_SYNC");
        if (this.message != null) {
            sb.append("\n  message=" + this.message);
        }
        sb.append("\n  action=" + this.action);
        sb.append("\n  resource=" + this.resource);
        if (this.user != null) {
            sb.append("\n  user=" + this.user);
        }
        sb.append("\n  ]\n");
        return sb.toString();
    }
}

