/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.ResourceInfo;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import java.util.Date;

public class Authz_Event
implements Security_Event {
    public static final String ACCESS_DENIED = "denied";
    public static final String ACCESS_PERMITTED = "permitted";
    public static final String ACCESS_PERMITTED_WARNING = "permittedWarning";
    public static final String ACCESS_UNKNOWN = "unknown";
    public static final String AUTHN_LEVEL_UNAUTHORIZED = "authnLevelUnauthorized";
    public static final String AUTHN_RULE_UNAUTHORIZED = "authzRuleUnauthorized";
    public static final String DELEGATE_UNAUTHORIZED = "delegateUnauthorized";
    public static final String QOP_UNAUTHORIZED = "qopUnauthorized";
    private UserInfo[] users;
    private String accessDecision;
    private String accessDecisionReason;
    private String message;
    private Date timestamp;
    private ResourceInfo resource;
    private Object source;
    private AuditOutcomeType outcome;
    private String[] checkedPermissionTypes;

    public Authz_Event(Object source, String accessDecision, String[] checkedPermissionTypes, UserInfo[] users, ResourceInfo resource, AuditOutcomeType outcome) throws KeyManagerException {
        this.source = source;
        this.accessDecisionReason = accessDecision;
        this.checkedPermissionTypes = checkedPermissionTypes;
        this.users = users;
        this.resource = resource;
        this.outcome = outcome;
        this.timestamp = new Date();
    }

    public Authz_Event(Object source, String accessDecision, String[] checkedPermissionTypes, String username, String resource, boolean outcome) {
        this.source = source;
        this.accessDecision = accessDecision;
        this.checkedPermissionTypes = checkedPermissionTypes;
        this.users = new UserInfo[]{new UserInfo(username)};
        this.resource = new ResourceInfo(resource);
        this.outcome = new AuditOutcomeType(outcome);
        this.timestamp = new Date();
    }

    public String getAccessDecision() {
        return this.accessDecision;
    }

    public String[] getCheckedPermissionTypes() {
        return this.checkedPermissionTypes;
    }

    public UserInfo[] getUsers() {
        return this.users;
    }

    public ResourceInfo getResource() {
        return this.resource;
    }

    public void setAccessDecisionReason(String reason) {
        this.accessDecisionReason = reason;
    }

    public String getAccessDecisionReason() {
        return this.accessDecisionReason;
    }

    public void setAuditMsg(String msg) {
        this.message = msg;
    }

    public String getAuditMsg() {
        return this.message;
    }

    public String getEventType() {
        return "SECURITY_AUTNZ";
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getEventSource() {
        return this.source;
    }

    public AuditOutcomeType getOutcome() {
        return this.outcome;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Authorization event:[");
        sb.append("\n  timestamp=" + this.timestamp);
        sb.append("\n  event source=" + this.source.getClass().getName());
        sb.append("\n  outcome=" + this.outcome.toString());
        sb.append("\n  event type=SECURITY_AUTNZ");
        if (this.message != null) {
            sb.append("\n  message=" + this.message);
        }
        sb.append("\n  access decision=" + this.accessDecision);
        if (this.accessDecisionReason != null) {
            sb.append("\n  access decision reason=" + this.accessDecisionReason);
        }
        String permissions = this.checkedPermissionTypes[0];
        for (int i = 1; i < this.checkedPermissionTypes.length; ++i) {
            permissions = permissions + "," + this.checkedPermissionTypes[i];
        }
        sb.append("\n  checked permissions=" + permissions);
        sb.append("\n  resource=" + this.resource);
        String users = this.users[0].toString();
        for (int i = 1; i < this.users.length; ++i) {
            users = users + "," + this.users[i].toString();
        }
        sb.append("\n  users=" + users);
        sb.append("\n  ]\n");
        return sb.toString();
    }
}

