/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagementServer;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.drivetable.DriveTable;
import com.ibm.keymanager.keystore.KeyStoreLoader;
import java.security.KeyStore;

public class ServerParameters {
    public static Audit audit = null;
    public static Config conf = null;
    public static DriveTable dt = null;
    public static KeyStore ks = null;
    public static KMSDebug dbg = null;
    private static KeyManagementServer serv = null;
    private static ServerParameters instance;
    private static String ksPassword;
    private KeyStoreLoader kls;

    private ServerParameters(KeyManagementServer serv, String configFile) throws KeyManagerException {
        try {
            conf = Config.getInstance("com.ibm.keymanager.config.ConfigImpl");
            conf.init(configFile);
            audit = Audit.getInstance();
            audit.init(conf);
            dbg = KMSDebug.getInstance();
            dbg.init(conf);
            dt = DriveTable.getInstance(conf, audit, null);
            this.kls = KeyStoreLoader.getInstance(conf, dbg);
            ks = this.kls.loadKeyStore("TapeKS", ksPassword.toCharArray());
            if (serv == null) {
                throw new KeyManagerException("null server");
            }
            ServerParameters.serv = serv;
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }

    public static ServerParameters getInstance(KeyManagementServer serv, String configFile, String keyStorePassword) throws KeyManagerException {
        if (instance != null) {
            return instance;
        }
        ksPassword = keyStorePassword;
        instance = new ServerParameters(serv, configFile);
        return instance;
    }

    public static ServerParameters getInstance() throws KeyManagerException {
        if (instance != null) {
            return instance;
        }
        throw new KeyManagerException("Server Paramters not Initialized");
    }

    public Config getConfig() {
        if (conf != null) {
            return conf;
        }
        return null;
    }

    public char[] getKSPassword() {
        return ksPassword.toCharArray();
    }

    public Audit getAudit() {
        if (audit != null) {
            return audit;
        }
        return null;
    }

    public DriveTable getDriveTable() {
        if (dt != null) {
            return dt;
        }
        return null;
    }

    public KMSDebug getDebug() {
        if (dbg != null) {
            return dbg;
        }
        return null;
    }

    public KeyStore getKeyStore() {
        if (ks != null) {
            return ks;
        }
        return null;
    }

    public void setConfig(Config conf) {
        if (conf != null) {
            ServerParameters.conf = conf;
        }
    }

    public void setAudit(Audit audit) {
        if (audit != null) {
            ServerParameters.audit = audit;
        }
    }

    public void setDriveTable(DriveTable dt) {
        if (dt != null) {
            ServerParameters.dt = dt;
        }
    }

    public void setDebug(KMSDebug db) {
        if (db != null) {
            dbg = db;
        }
    }

    public void setKeyStore(KeyStore keystore) {
        if (keystore != null) {
            ks = keystore;
        }
    }

    public void refreshAll() throws KeyManagerException {
        try {
            conf.reload();
            conf = Config.getInstance("com.ibm.keymanager.config.ConfigImpl");
            dbg.refresh(conf);
            dbg = KMSDebug.getInstance();
            dbg.init(conf);
            audit.refresh(conf);
            audit = Audit.getInstance();
            dt.refresh(conf, audit);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }

    public void shutdownAll() throws KeyManagerException {
        try {
            dbg.trace("server", "com.ibm.keymanager.ServerParameters", "shutdownAll", "Shutdown drivetable");
            dt.shutdown();
            dbg.trace("server", "com.ibm.keymanager.ServerParameters", "shutdownAll", "Shutdown config");
            conf.shutdown();
            dbg.trace("server", "com.ibm.keymanager.ServerParameters", "shutdownAll", "Shutdown audit");
            audit.shutdown();
            dbg.trace("server", "com.ibm.keymanager.ServerParameters", "shutdownAll", "Shutdown server");
            serv.shutdown();
            instance = null;
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }
}

