/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ThreadManager;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.transport.TransportListener;

public class ListenerThread {
    private Config config;
    private ThreadManager threadManager;
    private TransportListener listener;
    private Thread thread;

    ListenerThread(ThreadManager threadManager, String providerClass) throws KeyManagerException {
        if (threadManager == null) {
            throw new KeyManagerException("No thread manager");
        }
        this.threadManager = threadManager;
        try {
            this.listener = TransportListener.getInstance(providerClass);
            this.listener.init(this.config);
            this.listener.register(threadManager);
            this.thread = new Thread(threadManager.getListenerThreadGroup(), this.listener);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }

    ListenerThread(ThreadManager threadManager, String providerClass, Config config) throws KeyManagerException {
        this.setConfig(config);
        if (threadManager == null) {
            throw new KeyManagerException("No thread manager");
        }
        this.threadManager = threadManager;
        try {
            this.listener = TransportListener.getInstance(providerClass);
            this.listener.init(this.config);
            this.listener.register(threadManager);
            this.thread = new Thread(threadManager.getListenerThreadGroup(), this.listener);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }

    Thread getThread() {
        return this.thread;
    }

    TransportListener getListener() {
        return this.listener;
    }

    void setConfig(Config properties) {
        this.config = properties;
    }
}

