/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.i18n.PropertyResource;

public class KeyManagerException
extends Exception {
    private static final long serialVersionUID = 4891645721626733452L;
    public static final PropertyResource epr = PropertyResource.getExceptionInstance();
    private static final String[] majorMessageKeys = new String[]{"", "TestMessage", "LogicComponentError"};
    public static final int TEST_MESSAGE = 1;
    public static final int LOGIC_COMPONENT_ERR = 2;
    private static final int LAST_MAJOR_CODE = 200;
    private Throwable exc;
    private int major = 1;
    private int minor;
    private String minorMessage;
    private String majorString;

    public KeyManagerException() {
    }

    public KeyManagerException(int major) {
        if (major > 0 && major <= 200) {
            this.major = major;
        }
        this.setMajorString();
    }

    public KeyManagerException(int major, int minor, String extraInfo) {
        super(extraInfo);
        if (major > 0 && major <= 200) {
            this.major = major;
        }
        this.minor = minor;
        this.minorMessage = extraInfo;
        this.setMajorString();
    }

    public KeyManagerException(String extraInfo) {
        super(extraInfo);
    }

    public KeyManagerException(String message, boolean nls) {
        super(nls ? epr.getString(message) : message);
    }

    public KeyManagerException(byte[] extraInfo, String encoding) {
    }

    public KeyManagerException(String extraInfo, Throwable cause) {
        super(extraInfo);
        if (cause != null) {
            this.initCause(cause);
        }
    }

    public KeyManagerException(Throwable cause) {
        this.initCause(cause);
    }

    public int getMajor() {
        return this.major;
    }

    public String getMajorString() {
        return this.majorString;
    }

    public int getMinor() {
        return this.minor;
    }

    private void setMajorString() {
        this.majorString = this.getString(this.major);
    }

    private String getString(int majorInt) {
        return epr.getString(majorMessageKeys[majorInt]);
    }

    public void setMinor(int minor, String extraInfo) {
        this.minor = minor;
        this.minorMessage = extraInfo;
    }

    public Throwable getCause() {
        return this.exc;
    }

    public Throwable initCause(Throwable cause) {
        super.initCause(cause);
        this.exc = cause;
        return this;
    }

    public String toString() {
        String answer = super.toString();
        if (this.exc != null && this.exc != this) {
            answer = answer + " [Caused by " + this.exc.toString() + "]";
        }
        return answer;
    }
}

