/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import com.ibm.misc.HexDumpEncoder;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class KMSDebug {
    static final String TYPE_CONSOLE = "console";
    static final String TYPE_SIMPLE_FILE = "simple_file";
    static final String HANDLER_TYPE = "debug.output";
    static final String HANDLER_FILE = "debug.output.file";
    public static final String AUDIT = "audit";
    public static final String SERVER = "server";
    public static final String DRIVETABLE = "drivetable";
    public static final String CONFIG = "config";
    public static final String ADMIN = "admin";
    public static final String TRANSPORT = "transport";
    public static final String LOGIC = "logic";
    public static final String KEYSTORE = "keystore";
    public static final String ALL = "all";
    public static final String CONSOLE = "console";
    public static final String NONE = "none";
    static final String DEBUG = "debug";
    private static List args = new ArrayList();
    private static KMSDebug debug;
    private Logger logger = Logger.getLogger("keymanager");
    private Handler handler = new ConsoleHandler();
    private boolean inited;
    private static boolean runtimeSet;

    protected KMSDebug() {
        this.handler.setLevel(Level.ALL);
        this.logger.addHandler(this.handler);
        this.logger.setLevel(Level.ALL);
    }

    public static KMSDebug getInstance() {
        if (debug == null) {
            debug = new KMSDebug();
        }
        return debug;
    }

    public void init(Config config) throws KeyManagerException {
        if (!this.inited && this.logger != null) {
            this.inited = true;
            if (!runtimeSet) {
                String debugSt = null;
                try {
                    debugSt = (String)config.get(DEBUG);
                }
                catch (KeyManagerException ex) {
                    debugSt = null;
                }
                if (debugSt == null) {
                    debug.trace(ALL, this.getClass().getName(), "init", "Unable to initialize KMSDebug, no configuration");
                    args.add("console");
                } else {
                    debugSt = debugSt.toLowerCase();
                    String delim = ",";
                    if (debugSt.indexOf(";") > 0) {
                        delim = ";";
                    }
                    StringTokenizer st = new StringTokenizer(debugSt, delim);
                    while (st.hasMoreTokens()) {
                        String temp = st.nextToken().trim();
                        args.add(temp);
                    }
                    if (!args.contains("console")) {
                        args.add("console");
                    }
                }
            }
            String handlerType = null;
            String handlerFile = null;
            try {
                handlerType = (String)config.get(HANDLER_TYPE);
            }
            catch (KeyManagerException ex) {
                handlerType = null;
            }
            if (handlerType != null) {
                if (handlerType.equalsIgnoreCase(TYPE_SIMPLE_FILE)) {
                    this.logger.removeHandler(this.handler);
                    handlerFile = (String)config.get(HANDLER_FILE);
                    if (handlerFile == null) {
                        throw new KeyManagerException("Must specify the debug output file");
                    }
                    try {
                        this.handler = new FileHandler(handlerFile, true);
                    }
                    catch (IOException ex) {
                        throw (KeyManagerException)new KeyManagerException().initCause(ex);
                    }
                    this.handler.setLevel(Level.ALL);
                    this.handler.setFormatter(new SimpleFormatter());
                    this.logger.addHandler(this.handler);
                } else if (!handlerType.equalsIgnoreCase("console")) {
                    throw new KeyManagerException("Unsupported output type");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOn(String option) {
        option = option.toLowerCase();
        List list = args;
        synchronized (list) {
            if (args == null) {
                return false;
            }
            if (option.equals(NONE)) {
                return false;
            }
            if (args.contains(option)) {
                return true;
            }
            if (args.contains(ALL)) {
                return true;
            }
            if (((Object)args).equals("console")) {
                return true;
            }
            if (args.contains(NONE)) {
                return false;
            }
            return false;
        }
    }

    public void trace(String category, String className, String methodName, String message) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.logp(Level.ALL, className, methodName, message);
        }
    }

    public void trace(String category, String className, String methodName, String message, Object[] params) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.logp(Level.ALL, className, methodName, message, params);
        }
    }

    public void trace(String category, String className, String methodName, byte[] data) {
        if (this.isOn(category) && this.logger != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            String datamsg = encoder.encode(data);
            this.logger.logp(Level.ALL, className, methodName, datamsg);
        }
    }

    public void trace(String category, String className, String methodName, Throwable throwable) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.logp(Level.ALL, className, methodName, "", throwable);
        }
    }

    public void trace(String category, String className, String methodName, String message, Throwable throwable) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.logp(Level.ALL, className, methodName, message, throwable);
        }
    }

    public void entry(String category, String className, String methodName) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.entering(className, methodName);
        }
    }

    public void entry(String category, String className, String methodName, Object[] params) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.entering(className, methodName, params);
        }
    }

    public void exit(String category, String className, String methodName) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.exiting(className, methodName);
        }
    }

    public void exit(String category, String className, String methodName, byte retValue) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.exiting(className, methodName, new Byte(retValue));
        }
    }

    public void exit(String category, String className, String methodName, short retValue) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.exiting(className, methodName, new Short(retValue));
        }
    }

    public void exit(String category, String className, String methodName, int retValue) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.exiting(className, methodName, new Integer(retValue));
        }
    }

    public void exit(String category, String className, String methodName, long retValue) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.exiting(className, methodName, new Long(retValue));
        }
    }

    public void exit(String category, String className, String methodName, boolean retValue) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.exiting(className, methodName, new Boolean(retValue));
        }
    }

    public void exit(String category, String className, String methodName, Object retValue) {
        if (this.isOn(category) && this.logger != null) {
            this.logger.exiting(className, methodName, retValue);
        }
    }

    public static void Help() {
        System.err.println();
        System.err.println("all       turn on all debugging");
        System.err.println("admin     turn on debugging on administrative functions and CLI");
        System.err.println("audit     turn on debugging on auditing functions");
        System.err.println("config    configuration provider");
        System.err.println("drivetable drive table provider");
        System.err.println("keystore turn on debugging on key store");
        System.err.println("logic     decision logic provider");
        System.err.println("server    key manager server main program");
        System.err.println("transport transport provider");
        System.err.println("console  message displayed on console for the end users");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Config config) {
        String debugSt = null;
        try {
            debugSt = (String)config.get(DEBUG);
        }
        catch (KeyManagerException ex) {
            debug.trace(SERVER, this.getClass().getName(), "refresh", ex);
        }
        if (debugSt == null) {
            debug.trace(ALL, this.getClass().getName(), "refresh", "No debug setting in the configuration file, refresh failed");
        } else {
            debugSt = debugSt.toLowerCase();
            String delim = ",";
            if (debugSt.indexOf(";") > 0) {
                delim = ";";
            }
            StringTokenizer st = new StringTokenizer(debugSt, delim);
            List list = args;
            synchronized (list) {
                args = new ArrayList();
                while (st.hasMoreTokens()) {
                    String temp = st.nextToken().trim();
                    args.add(temp);
                }
                if (!args.contains("console")) {
                    args.add("console");
                }
            }
        }
    }

    public void shutdown() throws KeyManagerException {
        this.handler.flush();
        try {
            this.handler.close();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.logger.removeHandler(this.handler);
        this.logger = null;
        this.handler = null;
        this.inited = false;
        debug = null;
    }

    static {
        String argsString = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.keymanager.debug");
            }
        });
        if (argsString != null) {
            if ((argsString = argsString.toLowerCase()).equals("help")) {
                KMSDebug.Help();
            } else {
                String delim = ",";
                if (argsString.indexOf(";") > 0) {
                    delim = ";";
                }
                StringTokenizer st = new StringTokenizer(argsString, delim);
                while (st.hasMoreTokens()) {
                    String temp = st.nextToken().trim();
                    args.add(temp);
                }
            }
            runtimeSet = true;
        }
        if (!args.contains("console")) {
            args.add("console");
        }
    }
}

