/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class EPackageRegistryImpl
extends HashMap
implements EPackage.Registry {
    protected EPackage.Registry delegateRegistry;
    protected static Map classLoaderToRegistryMap = new WeakHashMap();
    private static final ParentClassLoaderGetter PARENT_CLASS_LOADER_GETTER = new ParentClassLoaderGetter();
    private static final PrivilegedAction CONTEXT_CLASS_LOADER_ACTION = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final Map secureClassLoaderToRegistryMap = new WeakHashMap();
    static /* synthetic */ Class class$0;

    public static EPackage.Registry createGlobalRegistry() {
        try {
            String className = System.getProperty("org.eclipse.emf.ecore.EPackage.Registry.INSTANCE");
            if (className == null) {
                if (EcorePlugin.getDefaultRegistryImplementation() != null) {
                    return EcorePlugin.getDefaultRegistryImplementation();
                }
                if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                    try {
                        SecurityManager securityManager = System.getSecurityManager();
                        if (securityManager != null) {
                            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
                        }
                        return new Delegator();
                    }
                    catch (SecurityException secExc) {
                        return new SecureDelegator();
                    }
                }
                return new EPackageRegistryImpl();
            }
            return (EPackage.Registry)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
            return new EPackageRegistryImpl();
        }
    }

    public EPackageRegistryImpl() {
    }

    public EPackageRegistryImpl(EPackage.Registry delegateRegistry) {
        this.delegateRegistry = delegateRegistry;
    }

    public EPackage getEPackage(String nsURI) {
        Object ePackage = this.get(nsURI);
        if (ePackage instanceof EPackage) {
            EPackage result = (EPackage)ePackage;
            if (result.getNsURI() == null) {
                this.initialize(result);
            }
            return result;
        }
        if (ePackage instanceof EPackage.Descriptor) {
            EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
            EPackage result = ePackageDescriptor.getEPackage();
            if (result != null) {
                this.put(nsURI, result);
                this.initialize(result);
            }
            return result;
        }
        return this.delegatedGetEPackage(nsURI);
    }

    public EFactory getEFactory(String nsURI) {
        Object ePackage = this.get(nsURI);
        if (ePackage instanceof EPackage) {
            EPackage result = (EPackage)ePackage;
            if (result.getNsURI() == null) {
                this.initialize(result);
            }
            return result.getEFactoryInstance();
        }
        if (ePackage instanceof EPackage.Descriptor) {
            EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
            EFactory result = ePackageDescriptor.getEFactory();
            return result;
        }
        return this.delegatedGetEFactory(nsURI);
    }

    protected void initialize(EPackage ePackage) {
    }

    protected EPackage delegatedGetEPackage(String nsURI) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getEPackage(nsURI);
        }
        return null;
    }

    protected EFactory delegatedGetEFactory(String nsURI) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getEFactory(nsURI);
        }
        return null;
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.delegateRegistry != null && this.delegateRegistry.containsKey(key);
    }

    public static synchronized EPackage.Registry getRegistry(ClassLoader classLoader) {
        EPackage.Registry result = (EPackage.Registry)classLoaderToRegistryMap.get(classLoader);
        if (result == null) {
            if (classLoader == null) {
                result = null;
            } else {
                result = new EPackageRegistryImpl(EPackageRegistryImpl.getRegistry(classLoader.getParent()));
                classLoaderToRegistryMap.put(classLoader, result);
            }
        }
        return result;
    }

    private static ClassLoader getContextClassLoaderSecurely() {
        return (ClassLoader)AccessController.doPrivileged(CONTEXT_CLASS_LOADER_ACTION);
    }

    private static synchronized EPackage.Registry getRegistrySecurely(ClassLoader classLoader) {
        EPackage.Registry result = (EPackage.Registry)secureClassLoaderToRegistryMap.get(classLoader);
        if (result == null && classLoader != null) {
            result = new EPackageRegistryImpl(EPackageRegistryImpl.getRegistrySecurely(PARENT_CLASS_LOADER_GETTER.getParent(classLoader)));
            secureClassLoaderToRegistryMap.put(classLoader, result);
        }
        return result;
    }

    public static class Delegator
    implements EPackage.Registry {
        protected EPackage.Registry delegateRegistry(ClassLoader classLoader) {
            return EPackageRegistryImpl.getRegistry(classLoader);
        }

        protected EPackage.Registry delegateRegistry() {
            return this.delegateRegistry(this.getContextClassLoader());
        }

        protected ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        protected ClassLoader getParent(ClassLoader classLoader) {
            return classLoader == null ? null : classLoader.getParent();
        }

        public EPackage getEPackage(String key) {
            return this.delegateRegistry().getEPackage(key);
        }

        public EFactory getEFactory(String key) {
            return this.delegateRegistry().getEFactory(key);
        }

        public int size() {
            return this.delegateRegistry().size();
        }

        public boolean isEmpty() {
            return this.delegateRegistry().isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.delegateRegistry().containsKey(key);
        }

        public boolean containsValue(Object value2) {
            return this.delegateRegistry().containsValue(value2);
        }

        public Object get(Object key) {
            return this.delegateRegistry().get(key);
        }

        public Object put(Object key, Object value2) {
            Class<?> valueClass = value2.getClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.impl.EPackageImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueClass == clazz) {
                return this.delegateRegistry().put(key, value2);
            }
            String valueClassName = valueClass.getName();
            ClassLoader result = this.getContextClassLoader();
            ClassLoader classLoader = this.getParent(result);
            while (classLoader != null) {
                try {
                    Class<?> loadedClass = classLoader.loadClass(valueClassName);
                    if (loadedClass != valueClass) break;
                    result = classLoader;
                }
                catch (ClassNotFoundException exception) {
                    break;
                }
                classLoader = this.getParent(classLoader);
            }
            return this.delegateRegistry(result).put(key, value2);
        }

        public Object remove(Object key) {
            return this.delegateRegistry().remove(key);
        }

        public void putAll(Map map) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public void clear() {
            this.delegateRegistry().clear();
        }

        public Set keySet() {
            return this.delegateRegistry().keySet();
        }

        public Collection values() {
            return this.delegateRegistry().values();
        }

        public Set entrySet() {
            return this.delegateRegistry().entrySet();
        }
    }

    private static class ParentClassLoaderGetter
    implements PrivilegedAction {
        private ClassLoader classLoader;

        private ParentClassLoaderGetter() {
        }

        public Object run() {
            if (this.classLoader != null) {
                this.classLoader = this.classLoader.getParent();
            }
            return null;
        }

        public ClassLoader getParent(ClassLoader classLoader) {
            this.classLoader = classLoader;
            AccessController.doPrivileged(this);
            return this.classLoader;
        }
    }

    private static final class SecureDelegator
    extends Delegator {
        private final ParentClassLoaderGetter parentClassLoaderGetter = new ParentClassLoaderGetter();

        private SecureDelegator() {
        }

        protected EPackage.Registry delegateRegistry(ClassLoader classLoader) {
            return EPackageRegistryImpl.getRegistrySecurely(classLoader);
        }

        protected ClassLoader getContextClassLoader() {
            return EPackageRegistryImpl.getContextClassLoaderSecurely();
        }

        protected ClassLoader getParent(ClassLoader classLoader) {
            return this.parentClassLoaderGetter.getParent(classLoader);
        }
    }
}

