/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.xml.validation.SecuritySupport;

class SecuritySupport12
extends SecuritySupport {
    SecuritySupport12() {
    }

    public ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    public String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public Enumeration getResources(final ClassLoader classLoader, final String string) {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(string) : classLoader.getResources(string);
                    return enumeration;
                }
                catch (IOException iOException) {
                    return new Enumeration(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean hasMoreElements() {
                            return false;
                        }

                        public Object nextElement() {
                            throw new NoSuchElementException();
                        }
                    };
                }
            }
        });
    }

    public boolean getFileExists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    public long getLastModified(final File file) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.lastModified());
            }
        });
    }
}

