/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.SecuritySupport;

class SecuritySupport12
extends SecuritySupport {
    SecuritySupport12() {
    }

    public ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    public InputStream getResourceAsStream(final Class c, final String name2) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return c.getResourceAsStream(name2);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public URL[] getResources(final ClassLoader cl, final String name2) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object[] ret = null;
                try {
                    Vector<URL> v = new Vector<URL>();
                    Enumeration<URL> e = cl.getResources(name2);
                    while (e != null && e.hasMoreElements()) {
                        URL url = e.nextElement();
                        if (url == null) continue;
                        v.addElement(url);
                    }
                    if (v.size() > 0) {
                        ret = new URL[v.size()];
                        v.copyInto(ret);
                    }
                }
                catch (IOException ioex) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public URL[] getSystemResources(final String name2) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object[] ret = null;
                try {
                    Vector<URL> v = new Vector<URL>();
                    Enumeration<URL> e = ClassLoader.getSystemResources(name2);
                    while (e != null && e.hasMoreElements()) {
                        URL url = e.nextElement();
                        if (url == null) continue;
                        v.addElement(url);
                    }
                    if (v.size() > 0) {
                        ret = new URL[v.size()];
                        v.copyInto(ret);
                    }
                }
                catch (IOException ioex) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public InputStream openStream(final URL url) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

