/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingDeclReader;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.api.util.encoding.IANACharset;
import com.ibm.xml.xlxp.api.util.encoding.RewindableInputStream;
import com.ibm.xml.xlxp.api.util.encoding.UCSEncodingSupport;
import com.ibm.xml.xlxp.api.util.encoding.UTF8EncodingSupport;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class SimpleParsedEntityFactory
implements ParsedEntityFactory {
    public static final boolean REQUIRE_IANA_ENCODING_NAMES = false;
    private static final int FREE_ENTITY_COUNT = 8;
    private static final int FREE_STREAM_COUNT = 8;
    protected DataBufferFactory fBufferFactory;
    protected XMLStringBuffer fStringBuffer;
    protected String[] fInOutEncodingName;
    private int fFreeEntityCount;
    private ParsedEntity[] fFreeEntities;
    private int fFreeStreamCount;
    private RewindableInputStream[] fFreeStreams;
    private DataSourceFactory fSourceFactory;
    private int fIDCounter;
    private boolean fCheckAvailable;
    private final EncodingSupport fUTF8EncodingSupport;
    private EncodingDeclReader fEncodingDeclReader;

    public SimpleParsedEntityFactory(DataBufferFactory dataBufferFactory) {
        this.fBufferFactory = dataBufferFactory;
        this.fCheckAvailable = Boolean.getBoolean("com.ibm.xml.xlxp.api.util.SimpleParsedEntityFactory.checkAvailable");
        this.fSourceFactory = new DataSourceFactory(dataBufferFactory);
        this.fUTF8EncodingSupport = UTF8EncodingSupport.getInstance();
        this.fFreeEntities = new ParsedEntity[8];
        this.fFreeStreams = new RewindableInputStream[8];
        this.fStringBuffer = new XMLStringBuffer(dataBufferFactory);
        this.fInOutEncodingName = new String[1];
        this.fEncodingDeclReader = new EncodingDeclReader();
    }

    public void setBufferLength(int n) {
        this.fSourceFactory.setBufferLength(n);
    }

    public void reset(boolean bl) {
        this.fStringBuffer.reset(bl);
        if (!bl) {
            while (this.fFreeEntityCount > 0) {
                --this.fFreeEntityCount;
                this.fFreeEntities[this.fFreeEntityCount] = null;
            }
        }
    }

    protected final ParsedEntity getFreeEntity() {
        ParsedEntity parsedEntity;
        if (this.fFreeEntityCount > 0) {
            parsedEntity = this.fFreeEntities[--this.fFreeEntityCount];
            this.fFreeEntities[this.fFreeEntityCount] = null;
        } else {
            parsedEntity = new ParsedEntity(this);
        }
        parsedEntity.id = this.fIDCounter++;
        parsedEntity.setBufferFactory(this.fBufferFactory);
        return parsedEntity;
    }

    public ParsedEntity createParsedEntity(InputStream inputStream, String string) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        try {
            this.setByteStreamSource(parsedEntity, inputStream, string, this.fInOutEncodingName);
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        return parsedEntity;
    }

    public ParsedEntity createParsedEntityFromXMLString(XMLString xMLString, String string) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        parsedEntity.baseURI = string;
        parsedEntity.setContent(xMLString);
        return parsedEntity;
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
        parsedEntity.clear();
        if (this.fFreeEntityCount < 8) {
            int n = 0;
            while (n < this.fFreeEntityCount) {
                if (this.fFreeEntities[n] == parsedEntity) {
                    UntestedCode.needTest("duplicate free entity");
                }
                ++n;
            }
            this.fFreeEntities[this.fFreeEntityCount++] = parsedEntity;
        }
    }

    protected final void setByteStreamSource(ParsedEntity parsedEntity, InputStream inputStream, String string, String[] stringArray) throws IOException {
        if (string == null) {
            this.detectEncodingSetSource(parsedEntity, inputStream, stringArray);
        } else {
            if (stringArray != null) {
                stringArray[0] = string;
            }
            this.fInOutEncodingName[0] = string;
            EncodingSupport encodingSupport = IANACharset.getEncodingSupport(this.fInOutEncodingName);
            if (encodingSupport != null) {
                this.loadFromByteStream(parsedEntity, inputStream, this.fInOutEncodingName[0], true, encodingSupport);
            } else {
                this.convertByteStreamWithUnknownEncoding(parsedEntity, inputStream, this.fInOutEncodingName[0]);
            }
        }
    }

    protected final void setCharacterStreamSource(ParsedEntity parsedEntity, Reader reader) {
        this.loadFromCharacterStream(parsedEntity, reader);
    }

    private void detectEncodingSetSource(ParsedEntity parsedEntity, InputStream inputStream, String[] stringArray) throws IOException {
        String string = null;
        boolean bl = false;
        boolean bl2 = stringArray != null;
        RewindableInputStream rewindableInputStream = this.createRewindableInputStream(inputStream);
        this.fEncodingDeclReader.setSource(rewindableInputStream, bl2);
        int n = this.fEncodingDeclReader.detectEncoding();
        switch (n) {
            default: {
                string = "UTF-8";
                if (bl2) {
                    stringArray[0] = string;
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, string, false, this.fUTF8EncodingSupport);
                return;
            }
            case 2: {
                string = "UTF-16BE";
                if (bl2) {
                    stringArray[0] = "UTF-16";
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, string, false, UCSEncodingSupport.getInstance(0));
                return;
            }
            case 3: {
                string = "UTF-16LE";
                if (bl2) {
                    stringArray[0] = "UTF-16";
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, string, false, UCSEncodingSupport.getInstance(1));
                return;
            }
            case 4: {
                string = "UTF-32BE";
                if (bl2) {
                    stringArray[0] = "UTF-32";
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, string, false, UCSEncodingSupport.getInstance(2));
                return;
            }
            case 5: {
                string = "UTF-32LE";
                if (bl2) {
                    stringArray[0] = "UTF-32";
                }
                this.loadFromByteStream(parsedEntity, rewindableInputStream, string, false, UCSEncodingSupport.getInstance(3));
                return;
            }
            case 6: {
                if (!this.fEncodingDeclReader.getLatinEncoding()) break;
                string = this.fEncodingDeclReader.getEncodingName();
                break;
            }
            case 7: {
                if (!this.fEncodingDeclReader.getEBCDICEncoding()) break;
                string = this.fEncodingDeclReader.getEncodingName();
                break;
            }
            case 8: {
                if (this.fEncodingDeclReader.getUCSEncoding(2, true)) {
                    string = this.fEncodingDeclReader.getEncodingName();
                }
                bl = true;
                break;
            }
            case 9: {
                if (this.fEncodingDeclReader.getUCSEncoding(2, false)) {
                    string = this.fEncodingDeclReader.getEncodingName();
                }
                bl = true;
                break;
            }
            case 10: {
                if (this.fEncodingDeclReader.getUCSEncoding(4, true)) {
                    string = this.fEncodingDeclReader.getEncodingName();
                }
                bl = true;
                break;
            }
            case 11: {
                if (this.fEncodingDeclReader.getUCSEncoding(4, false)) {
                    string = this.fEncodingDeclReader.getEncodingName();
                }
                bl = true;
            }
        }
        rewindableInputStream.rewind();
        if (string == null) {
            string = "UTF-8";
            if (bl2) {
                stringArray[0] = string;
            }
            this.loadFromByteStream(parsedEntity, rewindableInputStream, string, false, this.fUTF8EncodingSupport);
        } else {
            if (bl2) {
                stringArray[0] = string;
            }
            this.fInOutEncodingName[0] = string;
            EncodingSupport encodingSupport = IANACharset.getEncodingSupport(this.fInOutEncodingName);
            string = this.fInOutEncodingName[0];
            if (encodingSupport != null) {
                this.loadFromByteStream(parsedEntity, rewindableInputStream, string, bl, encodingSupport);
            } else {
                this.convertByteStreamWithUnknownEncoding(parsedEntity, rewindableInputStream, string);
            }
        }
    }

    private final void loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, EncodingSupport encodingSupport) {
        encodingSupport.loadFromByteStream(parsedEntity, inputStream, string, bl, this.fCheckAvailable, this.fSourceFactory);
    }

    private final void loadFromCharacterStream(ParsedEntity parsedEntity, Reader reader) {
        CharacterStreamDataSource characterStreamDataSource = this.fSourceFactory.allocateCharacterStreamDataSource();
        characterStreamDataSource.setCharacterStream(reader);
        characterStreamDataSource.load(parsedEntity);
    }

    private final void convertByteStreamWithUnknownEncoding(ParsedEntity parsedEntity, InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        this.loadFromCharacterStream(parsedEntity, inputStreamReader);
    }

    private RewindableInputStream createRewindableInputStream(InputStream inputStream) {
        RewindableInputStream rewindableInputStream;
        if (this.fFreeStreamCount > 0) {
            rewindableInputStream = this.fFreeStreams[--this.fFreeStreamCount];
            rewindableInputStream.setStream(inputStream);
        } else {
            rewindableInputStream = new RewindableInputStream(this, inputStream);
        }
        return rewindableInputStream;
    }

    public void releaseRewindableInputStream(RewindableInputStream rewindableInputStream) {
        if (this.fFreeStreamCount < 8) {
            this.fFreeStreams[this.fFreeStreamCount++] = rewindableInputStream;
        }
    }
}

