/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

abstract class StAXWriter
extends Writer {
    protected OutputStream fStream;
    protected int fNumBytes;
    protected final byte[] fBuffer = new byte[65536];
    public boolean fInUse;
    protected char[] fCharBuffer = new char[128];

    public void reset(OutputStream outputStream) {
        this.fNumBytes = 0;
        this.fStream = outputStream;
    }

    public void write(String string) throws IOException {
        int n = string.length();
        if (this.fCharBuffer.length < n) {
            this.fCharBuffer = new char[n * 2];
        }
        string.getChars(0, n, this.fCharBuffer, 0);
        this.write(this.fCharBuffer, 0, n);
    }

    protected void flushInternal() throws IOException {
        this.fStream.write(this.fBuffer, 0, this.fNumBytes);
        this.fNumBytes = 0;
    }

    public void flush() throws IOException {
        this.flushInternal();
        this.fStream.flush();
    }

    public void close() throws IOException {
        this.fStream.close();
        this.fStream = null;
        this.release();
    }

    protected abstract void release();
}

