/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.xlxp.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.api.util.UnsynchronizedBag;
import java.io.IOException;

public final class SingleByteWriter
extends StAXWriter {
    private static final ThreadLocal fInstances = new ThreadLocal(){

        public Object initialValue() {
            return new UnsynchronizedBag();
        }
    };

    private static final UnsynchronizedBag getPool() {
        return (UnsynchronizedBag)fInstances.get();
    }

    public static final SingleByteWriter getInstance() {
        SingleByteWriter singleByteWriter;
        UnsynchronizedBag unsynchronizedBag = SingleByteWriter.getPool();
        int n = 0;
        while (n < unsynchronizedBag.size) {
            singleByteWriter = (SingleByteWriter)unsynchronizedBag.array[n].get();
            if (singleByteWriter != null) {
                if (!singleByteWriter.fInUse) {
                    singleByteWriter.fInUse = true;
                    return singleByteWriter;
                }
                ++n;
                continue;
            }
            unsynchronizedBag.removeDeadReferences();
        }
        singleByteWriter = new SingleByteWriter();
        singleByteWriter.fInUse = true;
        unsynchronizedBag.add(singleByteWriter);
        return singleByteWriter;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n, n2);
        } else {
            this.flushInternal();
            int n3 = n + n2;
            while (n + this.fBuffer.length < n3) {
                this.encodeAndWrite(cArray, n, this.fBuffer.length);
                n += this.fBuffer.length;
                this.flushInternal();
            }
            this.encodeAndWrite(cArray, n, n3 - n);
        }
    }

    public void write(int n) throws IOException {
        if (this.fNumBytes == this.fBuffer.length) {
            this.flushInternal();
        }
        this.fBuffer[this.fNumBytes++] = (byte)n;
    }

    private void encodeAndWrite(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.fBuffer[this.fNumBytes++] = (byte)cArray[n3];
            ++n3;
        }
    }

    protected void release() {
        this.fInUse = false;
    }
}

