/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.server;

import [Ljava.lang.String;;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.management.ObjectName;

abstract class ServerCommandBase
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ServerCommandBase.class, "ServerCommandBase", "com.ibm.wsspi.management.commands.server");
    private final String implClassName = "com.ibm.ws.management.commands.server.ServerConfigHelper";
    private final String templateConfigHelperClassName = "com.ibm.ws.management.commands.templates.TemplateConfigHelper";
    protected Class implClass = null;
    protected Class templateConfigHelperClass = null;
    protected ManagedObjectMetadataHelper metadataHelper = null;

    public ServerCommandBase(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.initImpl();
    }

    public ServerCommandBase(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateServer", commandData);
        }
        this.initImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateServer");
        }
    }

    private void initImpl() {
        try {
            this.implClass = Class.forName("com.ibm.ws.management.commands.server.ServerConfigHelper");
            this.templateConfigHelperClass = Class.forName("com.ibm.ws.management.commands.templates.TemplateConfigHelper");
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.CreateServer.initImpl", "70");
        }
    }

    protected ManagedObjectMetadataHelper getManagedObjectMetadataHelper() {
        return this.metadataHelper;
    }

    public void setConfigSession(Session session) {
        super.setConfigSession(session);
        try {
            Method method = this.implClass.getMethod("getMetadataHelper", Session.class);
            this.metadataHelper = (ManagedObjectMetadataHelper)method.invoke(null, session);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.ServerCommandBase.setConfigSession", "69");
        }
    }

    protected List getTemplate(ObjectName objectName, String string) {
        List list = null;
        try {
            Session session = ServerCommandBase.getConfigSession(objectName);
            if (session == null) {
                session = this.getConfigSession();
            }
            Method method = this.implClass.getMethod("getTemplate", Session.class, ObjectName.class, String.class);
            list = (List)method.invoke(null, session, objectName, string);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.ServerCommandBase.setConfigSession", "69");
        }
        return list;
    }

    protected List listServerTemplates(String string, String[] stringArray) throws Throwable {
        return this.listServerTemplates(string, stringArray, null);
    }

    protected List listServerTemplates(String string, String[] stringArray, String string2) throws Throwable {
        List list = null;
        try {
            Method method = this.implClass.getMethod("listServerTemplates", ConfigService.class, Session.class, String.class, String;.class, String.class);
            list = (List)method.invoke(null, ConfigServiceFactory.getConfigService(), this.getConfigSession(), string, stringArray, string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.ServerCommandBase.setConfigSession", "69");
        }
        return list;
    }

    protected ObjectName findBestMatchingTemplate(List list) {
        ObjectName objectName = null;
        try {
            Object object;
            Session session = null;
            if (list.size() > 0 && (object = list.get(0)) instanceof ObjectName) {
                ObjectName objectName2 = (ObjectName)object;
                session = ServerCommandBase.getConfigSession(objectName2);
            }
            if (session == null) {
                session = this.getConfigSession();
            }
            object = this.templateConfigHelperClass.getMethod("findBestMatchingTemplate", ConfigService.class, Session.class, List.class);
            objectName = (ObjectName)((Method)object).invoke(null, ConfigServiceFactory.getConfigService(), session, list);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no such method", invocationTargetException);
            }
            FFDCFilter.processException(invocationTargetException, "com.ibm.wsspi.management.commands.server.ServerCommandBase.findBestMatchingTemplate", "69");
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.ServerCommandBase.findBestMatchingTemplate", "69");
        }
        return objectName;
    }

    protected int getMatchCount(ObjectName objectName, String string) {
        Integer n = null;
        Session session = ServerCommandBase.getConfigSession(objectName);
        if (session == null) {
            session = this.getConfigSession();
        }
        try {
            Method method = this.templateConfigHelperClass.getMethod("getMatchCountInteger", ConfigService.class, Session.class, ObjectName.class, String.class);
            n = (Integer)method.invoke(null, ConfigServiceFactory.getConfigService(), session, objectName, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no such method", invocationTargetException);
            }
            FFDCFilter.processException(invocationTargetException, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getMatchCount", "69");
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getMatchCount", "69");
        }
        if (n != null) {
            return n;
        }
        return -1;
    }

    protected int getDefaultTemplateMatchCount(String string, String string2) {
        Integer n = null;
        try {
            Method method = this.templateConfigHelperClass.getMethod("getDefaultTemplateMatchCount", ConfigService.class, Session.class, String.class, String.class);
            n = (Integer)method.invoke(null, ConfigServiceFactory.getConfigService(), this.getConfigSession(), string, string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no such method", invocationTargetException);
            }
            FFDCFilter.processException(invocationTargetException, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getDefaultTemplateMatchCount", "69");
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getDefaultTemplateMatchCount", "69");
        }
        if (n != null) {
            return n;
        }
        return -1;
    }

    private static Session getConfigSession(ObjectName objectName) {
        String string = objectName.getKeyProperty("_WEBSPHERE_CONFIG_SESSION");
        return string == null ? null : new Session(string, true);
    }
}

