/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import com.ibm.wsspi.configarchive.ImportStep;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public abstract class ImportCommand
extends ConfigArchiveCommand {
    private static TraceComponent tc = Tr.register(ImportCommand.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    protected HashMap preImportData = new HashMap();

    public ImportCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    protected void beforeStepsExecuted() {
        TaskCommandResultImpl taskCommandResultImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        if (!(taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult()).isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.collectConfigBeforeImport();
            EList eList = this.getTaskCommandData().getSteps();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                CommandStepData commandStepData = (CommandStepData)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stepData", commandStepData);
                }
                ImportStep importStep = (ImportStep)this.getCommandStep(commandStepData.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "step", importStep);
                }
                importStep.collectConfigBeforeImport();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.wsspi.configarchive.ImportCell.beforeStepsExecuted", "99");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "importCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void createArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArchiveSession");
        }
        try {
            File file = this.getArchiveLocation();
            Method method = this.composerCls.getMethod("loadConfigArchiveSession", File.class, FileAccessor.class);
            Session session = (Session)method.invoke(null, file, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createArchiveSession", session);
            }
            this.setConfigArchiveSession(session);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ConfigArchiveException) {
                FFDCFilter.processException(invocationTargetException, "com.ibm.wsspi.configarchive.ImportCommand.createArchiveSession", "88");
                throw (ConfigArchiveException)throwable;
            }
            FFDCFilter.processException(invocationTargetException, "com.ibm.wsspi.configarchive.ImportCommand.createArchiveSession", "91");
            throw new ConfigArchiveException(throwable, "unexpected exception");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.wsspi.configarchive.ImportCommand.createArchiveSession", "95");
            throw new ConfigArchiveException(throwable, "unexpected exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArchiveSession");
        }
    }

    protected void collectConfigBeforeImport() throws Exception {
    }

    public void setParameter(String string, Object object) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{string, object});
        }
        if (string.equals("archive") && !object.equals("")) {
            try {
                Session session = this.getConfigArchiveSession();
                if (session != null) {
                    this.unload();
                }
                super.setParameter(string, object);
                this.createArchiveSession();
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid parameter value", throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.wsspi.configarchive.ImportCommand.setParameter", "108");
                throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            }
        } else {
            super.setParameter(string, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            if (this.getParameter("archive") == null || this.getConfigArchiveSession() == null) {
                throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalid parameter value", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.configarchive.ImportCommand.validate", "145");
            throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }
}

