/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class FileAccessorOutputStream
extends OutputStream {
    private File tempFile = null;
    private FileAccessor fa = null;
    private FileOutputStream os = null;
    private String uri = null;

    public FileAccessorOutputStream(FileAccessor fileAccessor, String string) {
        this.fa = fileAccessor;
        this.uri = string;
        try {
            this.tempFile = File.createTempFile("configarchive", null);
            this.tempFile.deleteOnExit();
            this.os = new FileOutputStream(this.tempFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    public void write(int n) throws IOException {
        this.os.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
    }

    public FileDescriptor getFD() throws IOException {
        return this.os.getFD();
    }

    public FileChannel getChannel() {
        return this.os.getChannel();
    }

    public void close() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.tempFile);
        if (this.fa.exists(this.uri)) {
            this.fa.save(this.uri, fileInputStream);
        } else {
            String string = this.uri.substring(0, this.uri.lastIndexOf("/"));
            if (!this.fa.exists(string)) {
                this.fa.makeDir(string);
            }
            this.fa.create(this.uri, fileInputStream);
        }
        this.os.close();
        this.tempFile.delete();
    }
}

