/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelTargetRule;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ChannelSelectionCriteria
implements CFEndPointCriteria {
    private static final TraceComponent tc = Tr.register(ChannelSelectionCriteria.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    private final Identity clusterIdentity;
    private final SelectionCriteria criteria;
    private final CFEndPointCriteria cfEndPointCriteria;
    private final String chainName;
    private final Class accessor;
    private final Class[] channelFactories;
    private final boolean sslRequired;
    private String string = null;
    private int equalsTraces = 0;
    private static final int MAX_EQUALS_TRACES = 100;

    public ChannelSelectionCriteria(Identity identity, boolean bl, boolean bl2, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{identity, String.valueOf(bl), String.valueOf(bl2)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        this.criteria = selectionService.getCriteria(identity, bl, bl2, null, null);
        this.cfEndPointCriteria = cFEndPointCriteria;
        this.clusterIdentity = identity;
        this.chainName = cFEndPointCriteria == null ? null : cFEndPointCriteria.getChainName();
        this.accessor = cFEndPointCriteria == null ? null : cFEndPointCriteria.getChannelAccessor();
        this.channelFactories = cFEndPointCriteria == null ? null : cFEndPointCriteria.getOptionalChannelFactories();
        boolean bl3 = this.sslRequired = cFEndPointCriteria == null ? false : cFEndPointCriteria.isSSLRequired();
        if (tc.isEntryEnabled()) {
            this.toStringForce();
            Tr.exit(tc, "<init>", this);
        }
    }

    public ChannelSelectionCriteria(Identity identity, Map map, String string, Class clazz, Class[] classArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{identity, map, string, clazz, String.valueOf(bl)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (map == null) {
            throw new IllegalArgumentException("The context attribute must not be null.");
        }
        this.clusterIdentity = identity;
        this.chainName = string;
        this.accessor = clazz;
        this.channelFactories = classArray;
        this.sslRequired = bl;
        this.cfEndPointCriteria = this;
        this.setChannelTargetRule(this, map);
        this.criteria = selectionService.getCriteria(identity, map);
        if (tc.isEntryEnabled()) {
            this.toStringForce();
            Tr.exit(tc, "<init>", this);
        }
    }

    public ChannelSelectionCriteria(Identity identity, Map hashMap, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{identity, hashMap, cFEndPointCriteria});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        if (cFEndPointCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
        }
        if (hashMap == null) {
            hashMap = new HashMap(3);
        }
        this.setChannelTargetRule(cFEndPointCriteria, hashMap);
        this.criteria = selectionService.getCriteria(identity, hashMap);
        this.clusterIdentity = identity;
        this.chainName = cFEndPointCriteria.getChainName();
        this.accessor = cFEndPointCriteria.getChannelAccessor();
        this.channelFactories = cFEndPointCriteria.getOptionalChannelFactories();
        this.sslRequired = cFEndPointCriteria.isSSLRequired();
        this.cfEndPointCriteria = cFEndPointCriteria;
        if (tc.isEntryEnabled()) {
            this.toStringForce();
            Tr.exit(tc, "<init>", this);
        }
    }

    public CFEndPointCriteria getCFEndPointCriteria() {
        return this.cfEndPointCriteria;
    }

    public String toString() {
        if (this.string == null) {
            this.toStringForce();
        }
        return this.string;
    }

    private String toStringForce() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(super.toString());
        stringBuffer.append(" [clusterIdentity=");
        stringBuffer.append(this.clusterIdentity);
        stringBuffer.append("] [criteria = ");
        stringBuffer.append(this.criteria);
        stringBuffer.append("] [chainName=");
        stringBuffer.append(this.chainName);
        stringBuffer.append("] [sslRequired=");
        stringBuffer.append(this.sslRequired);
        stringBuffer.append("] [accessor=");
        stringBuffer.append(this.accessor);
        stringBuffer.append("] [channelFactories=");
        if (this.channelFactories != null) {
            stringBuffer.append("{");
            for (int i = 0; i < this.channelFactories.length; ++i) {
                stringBuffer.append(this.channelFactories[i]);
                if (i + 1 == this.channelFactories.length) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{null}");
        }
        this.string = stringBuffer.toString();
        return this.string;
    }

    public Identity getIdentity() {
        return this.clusterIdentity;
    }

    public SelectionCriteria getCriteria() {
        return this.criteria;
    }

    public Class getChannelAccessor() {
        return this.accessor;
    }

    public String getChainName() {
        return this.chainName;
    }

    public Class[] getOptionalChannelFactories() {
        return this.channelFactories;
    }

    public boolean isSSLRequired() {
        return this.sslRequired;
    }

    private void setChannelTargetRule(CFEndPointCriteria cFEndPointCriteria, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setChannelTargetRule");
        }
        boolean bl = false;
        SelectionRule[] selectionRuleArray = (SelectionRule[])map.get("rules.restriction");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SelectionRules = ", selectionRuleArray);
        }
        if (selectionRuleArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no restrictive rules in context add channel target rule");
            }
            selectionRuleArray = new SelectionRule[]{new ChannelTargetRule(cFEndPointCriteria)};
            map.put("rules.restriction", selectionRuleArray);
        } else {
            SelectionRule[] selectionRuleArray2 = new SelectionRule[selectionRuleArray.length + 1];
            for (int i = 0; i < selectionRuleArray.length; ++i) {
                if (selectionRuleArray[i] == null) continue;
                if (selectionRuleArray[i] instanceof ChannelTargetRule) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Restrictive rule ChannelTargetRule already in list");
                    }
                    bl = true;
                    break;
                }
                selectionRuleArray2[i] = selectionRuleArray[i];
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not found add channel target rule");
                }
                selectionRuleArray2[selectionRuleArray2.length - 1] = new ChannelTargetRule(cFEndPointCriteria);
                map.put("rules.restriction", selectionRuleArray2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setChannelTargetRule", map);
        }
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean bl) {
        if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "equals");
        }
        if (object == null) {
            if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "passed in object is null, returning false");
            }
            return false;
        }
        if (object == this) {
            if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "passed in object is == this object, returning true");
            }
            return true;
        }
        if (!(object instanceof ChannelSelectionCriteria)) {
            if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "passed in object is not an instance of ChannelSelectionCriteria, returning false");
            }
            return false;
        }
        ChannelSelectionCriteria channelSelectionCriteria = (ChannelSelectionCriteria)object;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(this.accessor != null && channelSelectionCriteria.accessor != null || this.accessor == null && channelSelectionCriteria.accessor == null)) {
            if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "accessors are mismatched, returning false");
            }
            return false;
        }
        if (this.accessor != null && this.accessor.equals(channelSelectionCriteria.accessor) || this.accessor == null) {
            bl2 = true;
        }
        if (!(this.chainName != null && channelSelectionCriteria.chainName != null || this.chainName == null && channelSelectionCriteria.chainName == null)) {
            if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "chainNames are mismatched, returning false");
            }
            return false;
        }
        if (this.chainName != null && this.chainName.equals(channelSelectionCriteria.chainName) || this.chainName == null) {
            bl3 = true;
        }
        if (!(this.channelFactories != null && channelSelectionCriteria.channelFactories != null || this.channelFactories == null && channelSelectionCriteria.channelFactories == null)) {
            if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "channelFactories are mismatched, returning false");
            }
            return false;
        }
        if (this.channelFactories != null && this.channelFactories.length == channelSelectionCriteria.channelFactories.length) {
            bl4 = true;
        } else if (this.channelFactories == null) {
            bl5 = true;
        }
        if (this.criteria.equals(channelSelectionCriteria.criteria) && this.clusterIdentity == channelSelectionCriteria.clusterIdentity && bl3 && bl2 && this.sslRequired == channelSelectionCriteria.sslRequired && (bl4 || bl5)) {
            if (!bl5 && channelSelectionCriteria.channelFactories.length > 0) {
                int n;
                ArrayList<Class> arrayList = new ArrayList<Class>(channelSelectionCriteria.channelFactories.length);
                for (n = 0; n < this.channelFactories.length; ++n) {
                    arrayList.add(channelSelectionCriteria.channelFactories[n]);
                }
                for (n = 0; n < this.channelFactories.length; ++n) {
                    if (arrayList.contains(this.channelFactories[n])) continue;
                    if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "equals", "passed in object's channelFactories array does not contain: " + this.channelFactories[n] + ", returning false");
                    }
                    return false;
                }
            }
            if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", "unexpected - passed in object matches this object, returning true");
            }
            return true;
        }
        if (bl && this.equalsTraces <= 100 && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            ++this.equalsTraces;
            if (this.equalsTraces > 100) {
                Tr.debug(tc, "exceeded MAX_EQUALS_TRACES; no further trace for this object.");
            }
            Tr.debug(tc, "this = " + this);
            Tr.debug(tc, "other = " + channelSelectionCriteria);
            if (!this.criteria.equals(channelSelectionCriteria.criteria)) {
                Tr.exit(tc, "equals", "other object's criteria doesn't match this object's criteria, returning false");
            } else if (this.clusterIdentity != channelSelectionCriteria.clusterIdentity) {
                Tr.exit(tc, "equals", "other object's cluster identity doesn't match this object's cluster identity, returning false");
            } else if (!bl3) {
                Tr.exit(tc, "equals", "other object's chainName doesn't match this object's chainName, returning false");
            } else if (!bl2) {
                Tr.exit(tc, "equals", "other object's accessor doesn't match this object's accessor, returning false");
            } else if (this.sslRequired != channelSelectionCriteria.sslRequired) {
                Tr.exit(tc, "equals", "other object's sslRequired doesn't match this object's sslRequired, returning false");
            } else if (!bl5 && !bl4) {
                Tr.exit(tc, "equals", "other object's channelFactories.length doesn't match this object's channelFactories.length, returning false");
            } else {
                Tr.exit(tc, "equals", "unexpected - don't know what wasn't equal");
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        n = 29 * n + (this.clusterIdentity == null ? 0 : this.clusterIdentity.hashCode());
        n = 29 * n + (this.chainName == null ? 0 : this.chainName.hashCode());
        n = 29 * n + (this.accessor == null ? 0 : this.accessor.hashCode());
        int n2 = 0;
        if (this.channelFactories != null) {
            for (int i = 0; i < this.channelFactories.length; ++i) {
                n2 += this.channelFactories[i].hashCode();
            }
        }
        n = 29 * n + n2;
        n = 29 * n + (this.sslRequired ? 1 : 2);
        n = 29 * n + (this.criteria == null ? 0 : this.criteria.hashCode());
        return n;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.14.1.3 ");
        }
    }
}

