/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap12;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.spi.extensions.soap12.SOAP12Binding;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAP12BindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAP12Binding sOAP12Binding = (SOAP12Binding)extensibilityElement;
        if (sOAP12Binding != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap12/", "binding", definition);
            printWriter.print("    <" + string);
            DOMUtils.printAttribute("style", sOAP12Binding.getStyle(), printWriter);
            DOMUtils.printAttribute("transport", sOAP12Binding.getTransportURI(), printWriter);
            Boolean bl = sOAP12Binding.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAP12Binding sOAP12Binding = (SOAP12Binding)extensionRegistry.createExtension(clazz, qName);
        String string = DOMUtils.getAttribute(element, "transport");
        String string2 = DOMUtils.getAttribute(element, "style");
        String string3 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string != null) {
            sOAP12Binding.setTransportURI(string);
        }
        if (string2 != null) {
            sOAP12Binding.setStyle(string2);
        }
        if (string3 != null) {
            sOAP12Binding.setRequired(new Boolean(string3));
        }
        return sOAP12Binding;
    }
}

