/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.channel.WCChannelFactory;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import java.net.InetAddress;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class CFWHelper {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.CFWHelper";
    private static final TraceComponent _tc = Tr.register(CFWHelper.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final boolean _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private static boolean _initFailed = false;
    private static String _httpPrefix = null;
    private static String _httpsPrefix = null;
    private static boolean _initialised;
    private static boolean _httpFound;
    private static boolean _httpsFound;
    static /* synthetic */ Class class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory;
    static /* synthetic */ Class class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory;

    private static synchronized void initialise() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialise");
        }
        if (_initialised) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialise", "Already initialised");
            }
            return;
        }
        CFWHelper.setPortAndHostFromCFS();
        _initialised = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialise");
        }
    }

    private static void setPortAndHostFromCFS() {
        Object object;
        Object object2;
        block21: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "setPortAndHostFromCFS");
            }
            object2 = null;
            if (_isZOS) {
                if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
                    // empty if block
                }
            } else {
                try {
                    object = null;
                    object = new InitialContext();
                    object2 = object.lookup("services:websphere/ChannelFrameworkService");
                }
                catch (NamingException namingException) {
                    if (!_tc.isDebugEnabled()) break block21;
                    Tr.debug(_tc, "NamingException during lookup of ChannelFrameworkService in GlobalNamespace");
                }
            }
        }
        if (object2 == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No ChannelFrameworkService in Global Namespaces");
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ChannelFrameworkService obtained");
            }
            try {
                object = (ChannelFrameworkService)object2;
                ChainData[] chainDataArray = object.getAllChains(WCChannelFactory.class);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "ChainDataArray size is " + chainDataArray.length);
                }
                int n = chainDataArray.length;
                while (--n >= 0) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Chain [" + n + "] Name is " + chainDataArray[n].getName());
                    }
                    if (!chainDataArray[n].getName().startsWith("WCInboundAdmin")) {
                        ChannelData[] channelDataArray = chainDataArray[n].getChannelList();
                        for (int i = 0; i < channelDataArray.length && (i != 0 || channelDataArray[0].getFactoryType().equals(class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory == null ? CFWHelper.class$("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory") : class$com$ibm$ws$tcp$channel$impl$WSTCPChannelFactory)); ++i) {
                            if (i != 1) continue;
                            if (!_httpsFound && channelDataArray[1].getFactoryType().equals(class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory == null ? CFWHelper.class$("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory") : class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory)) {
                                CFWHelper.processChannelData(channelDataArray[0], true);
                                break;
                            }
                            if (_httpFound || channelDataArray[1].getFactoryType().equals(class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory == null ? CFWHelper.class$("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory") : class$com$ibm$ws$ssl$channel$impl$WSSSLChannelFactory)) continue;
                            CFWHelper.processChannelData(channelDataArray[0], false);
                            break;
                        }
                    }
                    if (!_httpFound || !_httpsFound) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, CLASSNAME, "1:1.4:180");
                Tr.warning(_tc, "setPortAndHostFromCFS", "Exception caught processing the Channel Data.");
            }
        }
        if (!_httpFound && !_httpsFound) {
            _initFailed = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Cannot find WebContainerChannel for HTTP or HTTPS");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setPortAndHostFromCFS");
        }
    }

    private static void processChannelData(ChannelData channelData, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processChannelData", new Object[]{channelData, new Boolean(bl)});
        }
        Map map = channelData.getPropertyBag();
        boolean bl2 = false;
        boolean bl3 = false;
        if (map != null) {
            String string = (String)map.get("port");
            if (string != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found Port " + string);
                }
                bl2 = true;
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Could not find port in channelData");
            }
            String string2 = (String)map.get("hostname");
            if (string2 != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found host " + string2);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Could not find host in channelData");
            }
            if (string2 != null) {
                try {
                    string2 = string2.equals("localhost") || string2.equals("*") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(string2).getHostAddress();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using host " + string2);
                    }
                    bl3 = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, CLASSNAME, "1:1.4:249");
                    Tr.warning(_tc, "processChannelData", "Exception caught converting hostname into an IP address.");
                }
            }
            if (bl2 && bl3) {
                if (bl) {
                    _httpsPrefix = "https://" + string2 + ":" + string;
                    _httpsFound = true;
                } else {
                    _httpPrefix = "http://" + string2 + ":" + string;
                    _httpFound = true;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processChannelData");
        }
    }

    public static boolean getHttpFound() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getHttpFound");
        }
        if (!_initialised) {
            CFWHelper.initialise();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHttpFound " + _httpFound);
        }
        return _httpFound;
    }

    public static boolean getHttpsFound() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getHttpsFound");
        }
        if (!_initialised) {
            CFWHelper.initialise();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHttpsFound " + _httpsFound);
        }
        return _httpsFound;
    }

    public static String getHttpPrefix() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getHttpPrefix");
        }
        if (!_initialised) {
            CFWHelper.initialise();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHttpPrefix", _httpPrefix);
        }
        return _httpPrefix;
    }

    public static String getHttpsPrefix() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getHttpsPrefix");
        }
        if (!_initialised) {
            CFWHelper.initialise();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHttpsPrefix", _httpsPrefix);
        }
        return _httpsPrefix;
    }

    static {
        _httpFound = false;
        _httpsFound = false;
    }
}

