/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.integration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.integration.EndpointMap;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class CombinedEndpointMap
implements EndpointMap {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(CombinedEndpointMap.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final String MULTIPLE_SOAP_ADDRESS_TRACE_STRING = "Multiple mappings found. Cannot determine one soap address for this webServiceName and port pair.";
    private static final String MULTIPLE_SOAP_ADDRESS_EXCEPTION_STRING = "The desired target endpoint has been deployed with multiple addresses. Unable to determine a unique address URI for EndpointReference creation.";
    private static final String MULTIPLE_VIRTUAL_HOST_TRACE_STRING = "Multiple mappings found. Cannot determine one virtual host for this webServiceName and port pair.";
    private static final String MULTIPLE_VIRTUAL_HOST_EXCEPTION_STRING = "The desired target endpoint has been deployed with multiple addresses. Unable to determine a unique virtual host for EndpointReference creation.";
    private static final String MULTIPLE_INTEMEDIARY_INFO_TRACE_STRING = "Multiple mappings found. Cannot determine unique intemediary status for this webServiceName and port pair.";
    private static final String MULTIPLE_INTEMEDIARY_INFO_EXCEPTION_STRING = "The desired target endpoint has been deployed with multiple addresses. Unable to determine a unique intemediary status for EndpointReference creation.";
    ArrayList maps = new ArrayList();

    public URI getSOAPAddressForPort(String string, QName qName) throws URIGenerationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPAddressForPort", new Object[]{string, qName});
        }
        URI uRI = null;
        Iterator iterator = this.maps.iterator();
        while (iterator.hasNext()) {
            EndpointMap endpointMap = (EndpointMap)iterator.next();
            URI uRI2 = endpointMap.getSOAPAddressForPort(string, qName);
            if (uRI2 == null) continue;
            if (uRI == null) {
                uRI = uRI2;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] objectArray = new Object[]{MULTIPLE_SOAP_ADDRESS_TRACE_STRING, string, qName};
                Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", objectArray);
            }
            throw new URIGenerationException(MULTIPLE_SOAP_ADDRESS_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", uRI);
        }
        return uRI;
    }

    public String getVirtualHostForPort(String string, QName qName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForPort", new Object[]{string, qName});
        }
        String string2 = null;
        Iterator iterator = this.maps.iterator();
        while (iterator.hasNext()) {
            EndpointMap endpointMap = (EndpointMap)iterator.next();
            String string3 = endpointMap.getVirtualHostForPort(string, qName);
            if (string3 == null) continue;
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] objectArray = new Object[]{MULTIPLE_VIRTUAL_HOST_TRACE_STRING, string, qName};
                Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", objectArray);
            }
            throw new EndpointReferenceCreationException(MULTIPLE_VIRTUAL_HOST_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", string2);
        }
        return string2;
    }

    public boolean intermediaryConfigured(String string, QName qName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intermediaryConfigured", new Object[]{string, qName});
        }
        boolean bl = false;
        Iterator iterator = this.maps.iterator();
        while (iterator.hasNext()) {
            EndpointMap endpointMap = (EndpointMap)iterator.next();
            boolean bl2 = endpointMap.intermediaryConfigured(string, qName);
            if (!bl2) continue;
            if (!bl) {
                bl = true;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] objectArray = new Object[]{MULTIPLE_INTEMEDIARY_INFO_TRACE_STRING, string, qName};
                Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", objectArray);
            }
            throw new EndpointReferenceCreationException(MULTIPLE_INTEMEDIARY_INFO_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", new Boolean(bl));
        }
        return bl;
    }

    void addEndpointMap(EndpointMap endpointMap) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEndpointMap", endpointMap);
        }
        this.maps.add(endpointMap);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEndpointMap");
        }
    }

    void removeEndpointMap(EndpointMap endpointMap) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeEndpointMap", endpointMap);
        }
        this.maps.remove(endpointMap);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeEndpointMap");
        }
    }

    public boolean workLoadManaged(String string, QName qName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "workLoadManaged", new Object[]{string, qName});
        }
        boolean bl = true;
        Iterator iterator = this.maps.iterator();
        while (iterator.hasNext()) {
            EndpointMap endpointMap = (EndpointMap)iterator.next();
            boolean bl2 = endpointMap.workLoadManaged(string, qName);
            if (bl2) continue;
            if (bl) {
                bl = false;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] objectArray = new Object[]{MULTIPLE_INTEMEDIARY_INFO_TRACE_STRING, string, qName};
                Tr.exit(TRACE_COMPONENT, "workLoadManaged", objectArray);
            }
            throw new EndpointReferenceCreationException(MULTIPLE_INTEMEDIARY_INFO_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "workLoadManaged", new Boolean(bl));
        }
        return bl;
    }
}

