/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

public abstract class WSACommonHandler
implements Handler {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSACommonHandler";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSACommonHandler.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public void init(HandlerInfo handlerInfo) {
        String string;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "init", handlerInfo);
        }
        if ((string = System.getProperty("com.ibm.ws.wsaddressingAndDependentsDisabled")) != null && string.equalsIgnoreCase("true")) {
            this.setAddressingDisabledGlobally(true);
            Tr.warning(TRACE_COMPONENT, "WSAddressing and dependents are disabled. Limited Trace.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "init");
        }
    }

    public void handleClosure(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.info(TRACE_COMPONENT, "handleClosure", messageContext);
        }
    }

    protected abstract boolean addressingDisabledGlobally();

    protected abstract void setAddressingDisabledGlobally(boolean var1);

    protected boolean isAddressingDisabled(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isAddressingDisabled", messageContext);
        }
        boolean bl = false;
        bl = this.addressingDisabledGlobally();
        if (!bl) {
            bl = this.addressingDisabledMessage(messageContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isAddressingDisabled result[" + bl + "]");
        }
        return bl;
    }

    private boolean addressingDisabledMessage(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addressingDisabledMessage", messageContext);
        }
        boolean bl = false;
        Object object = messageContext.getProperty("com.ibm.ws.wsaddressing.disabled");
        if (object != null) {
            if (!(object instanceof Boolean)) {
                if (TRACE_COMPONENT.isErrorEnabled()) {
                    Tr.error(TRACE_COMPONENT, "WSADDRESSING_DISABLED set by application not of type java.lang.Boolean");
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSADDRESSING_DISABLED set by application and is of type java.lang.Boolean");
                }
                bl = (Boolean)object;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addressingDisabledMessage result[" + bl + "]");
        }
        return bl;
    }

    public void destroy() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.info(TRACE_COMPONENT, "destroy");
        }
    }
}

