/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.binders.BinderHelper;
import com.ibm.wsspi.webservices.binding.CustomBinder;
import com.ibm.wsspi.webservices.binding.CustomBindingContext;
import com.ibm.wsspi.wsaddressing.AttributedType;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class AttributedURIBinder
implements CustomBinder {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.binders.AttributedURIBinder";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AttributedURIBinder.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private BinderHelper _binderHelper = new BinderHelper();

    public String getQNameScope() {
        return "complexType";
    }

    public QName getQName() {
        return new QName("http://www.w3.org/2005/08/addressing", "AttributedURI");
    }

    public String getJavaName() {
        return "com.ibm.wsspi.wsaddressing.AttributedURI";
    }

    public SOAPElement serialize(Object object, SOAPElement sOAPElement, CustomBindingContext customBindingContext) throws SOAPException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{object, sOAPElement, customBindingContext};
            Tr.entry(TRACE_COMPONENT, "serialize", objectArray);
        }
        this._binderHelper.validateSerializeMethodParameters(object, sOAPElement, "AttributedURI");
        if (!(object instanceof AttributedURI)) {
            objectArray = this.getJavaName();
            String string = object.getClass().getName();
            String string2 = "AttributedURIBinder";
            String string3 = "The object to be bound passed to " + string2 + " was of incorrect type. Expected class implementing:[" + (String)objectArray + "] but was:[" + string + "]";
            Tr.error(TRACE_COMPONENT, string3);
            throw new SOAPException(string3);
        }
        objectArray = (AttributedURI)object;
        sOAPElement.addTextNode(objectArray.getURI().toString());
        sOAPElement = this._binderHelper.addAttributesToSOAPElementFromAttributedType(sOAPElement, (AttributedType)objectArray);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serialize", sOAPElement);
        }
        return sOAPElement;
    }

    public Object deserialize(SOAPElement sOAPElement, CustomBindingContext customBindingContext) throws SOAPException {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            object = new Object[]{sOAPElement, customBindingContext};
            Tr.entry(TRACE_COMPONENT, "deserialize", object);
        }
        this._binderHelper.checkForNullSOAPElement(sOAPElement, "AttributeURI");
        object = null;
        String string = sOAPElement.getValue();
        if (string != null && string.length() > 0) {
            try {
                object = new URI(string.trim());
            }
            catch (URISyntaxException uRISyntaxException) {
                String string2 = "Check the contents on the SOAPHeader.  The URI " + string.trim() + " cound not be created. " + uRISyntaxException.getMessage();
                Tr.warning(TRACE_COMPONENT, string2);
                FFDCFilter.processException(uRISyntaxException, CLASSNAME, "1:159:1.19");
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Object[] objectArray = new Object[]{object, string};
                    Tr.exit(TRACE_COMPONENT, "deserialize", objectArray);
                }
                return null;
            }
        } else {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] objectArray = new Object[]{object, string};
                Tr.exit(TRACE_COMPONENT, "deserialize", objectArray);
            }
            return null;
        }
        AttributedURI attributedURI = WSAddressingFactory.createAttributedURI((URI)object);
        this._binderHelper.addAttributesToAttributedTypeFromSOAPElement(sOAPElement, attributedURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserialize", attributedURI);
        }
        return attributedURI;
    }
}

