/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaWriter;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.wsdl.Definition;

public class XMLMappingWriter
extends JavaWriter {
    private static final String JAXRPCMAPPINGFILENAME = "_mapping.xml";
    private static final String WSDLFILEEXTENSION = ".wsdl";
    protected Definition definition;
    protected SymbolTable symbolTable;
    protected String INFdir;

    public XMLMappingWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "deploy");
        this.definition = definition;
        this.symbolTable = symbolTable;
        this.INFdir = "";
        if (emitter.getRole() == Role.SERVER || emitter.getRole() == Role.DEVELOP_SERVER) {
            this.INFdir = emitter.getContainer() == Container.EJB ? "META-INF" : "WEB-INF";
        } else if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.DEVELOP_CLIENT) {
            if (emitter.getContainer() == Container.WEB) {
                this.INFdir = "WEB-INF";
            } else if (emitter.getContainer() == Container.EJB || emitter.getContainer() == Container.CLIENT) {
                this.INFdir = "META-INF";
            }
        }
        if (emitter.getOutputDir() != null) {
            this.INFdir = emitter.getOutputDir() + emitter.getToolEnv().getSeparatorChar() + this.INFdir;
        }
    }

    public void generate() throws IOException {
        if ((this.emitter.getRole() == Role.CLIENT || this.emitter.getRole() == Role.SERVER || this.emitter.getRole() == Role.DEVELOP_CLIENT || this.emitter.getRole() == Role.DEVELOP_SERVER) && this.emitter.getContainer() != Container.NONE) {
            super.generate();
        }
        if (this.emitter.getAltOutputMappingFile() != null) {
            this.emitter.outputMMD.write(this.emitter.getAltOutputMappingFile(), this.emitter.getToolEnv());
        }
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.emitter.outputMMD.write(this.getFileName(), this.emitter.getToolEnv());
    }

    protected String getFileName() {
        return this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + this.getMappingFileName(this.emitter);
    }

    private String getMappingFileName(Emitter emitter) {
        String string = emitter.getWSDLURI();
        String string2 = Utils.getName(string);
        if (string2.toLowerCase().endsWith(WSDLFILEEXTENSION)) {
            string2 = string2.substring(0, string2.toLowerCase().lastIndexOf(WSDLFILEEXTENSION));
        }
        return string2 + JAXRPCMAPPINGFILENAME;
    }

    protected PrintWriter getPrintWriter(String string) throws IOException {
        return null;
    }

    protected void closePrintWriter(PrintWriter printWriter) {
    }
}

