/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.FileWriteDenialException;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.toJava.DuplicateFileException;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class JavaWriter
implements Generator {
    protected Emitter emitter;
    protected String type;
    private boolean isDeploy = false;

    protected JavaWriter(Emitter emitter, String string) {
        this.emitter = emitter;
        this.type = string;
    }

    public void generate() throws IOException {
        String string = this.getFileName();
        if (this.isFileGenerated(string)) {
            throw new DuplicateFileException(Messages.getMessage("duplicateFile00", string), string);
        }
        GenCriteria genCriteria = string.endsWith(".java") ? this.emitter.getGenJava() : this.emitter.getGenXML();
        if (Utils.fileShouldBeWritten(string, this.emitter.getToolEnv(), genCriteria, this.isDeployPhaseOnlyWriter())) {
            try {
                String string2;
                PrintWriter printWriter = this.getPrintWriter(string);
                this.registerFile(string);
                if (this.emitter.isVerbose() && (string2 = this.verboseMessage(string)) != null) {
                    this.emitter.getToolEnv().report(string2);
                }
                this.writeFileHeader(printWriter);
                this.writeFileBody(printWriter);
                this.writeFileFooter(printWriter);
                this.closePrintWriter(printWriter);
            }
            catch (FileWriteDenialException fileWriteDenialException) {
                this.emitter.getToolEnv().report(Messages.getMessage("FileWriteDenied", string));
            }
        }
    }

    protected abstract String getFileName();

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean bl) {
        this.isDeploy = bl;
    }

    protected boolean isFileGenerated(String string) {
        return this.emitter.getGeneratedFileNames().contains(string);
    }

    protected void registerFile(String string) {
        this.emitter.getGeneratedFileInfo().add(string, null, this.type);
    }

    protected String verboseMessage(String string) {
        return Messages.getMessage("generating", string);
    }

    protected PrintWriter getPrintWriter(String string) throws IOException {
        return this.emitter.getToolEnv().getPrintWriter(string);
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
    }

    protected abstract void writeFileBody(PrintWriter var1) throws IOException;

    protected void writeFileFooter(PrintWriter printWriter) throws IOException {
    }

    protected void closePrintWriter(PrintWriter printWriter) {
        printWriter.close();
    }

    protected void writeComment(PrintWriter printWriter, Element element) {
        if (element == null) {
            return;
        }
        Node node = element.getFirstChild();
        if (node == null) {
            return;
        }
        String string = node.getNodeValue();
        string = string.replace('\r', ' ');
        if ((string = string.replace('\n', ' ')) != null) {
            int n = 0;
            printWriter.println();
            while (n < string.length()) {
                int n2 = n + 65;
                if (n2 > string.length()) {
                    n2 = string.length();
                }
                while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                printWriter.println("     // " + string.substring(n, n2).trim());
                n = n2 + 1;
            }
        }
    }
}

