/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class JavaEnumTypeWriter
extends JavaClassWriter {
    private Vector enumValues;
    private Type type;

    protected JavaEnumTypeWriter(Emitter emitter, Type type) {
        super(emitter, type.getName(), "enumType");
        this.type = type;
        this.enumValues = type.getChildren();
    }

    protected String getImplementsText() {
        if (this.emitter.isGenImplSer()) {
            return "implements java.io.Serializable ";
        }
        return " ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        int n;
        String string;
        String string2 = this.getClassName();
        String string3 = string = this.type.getRestrictionBase().getName();
        if (string.equals("String")) {
            string3 = "java.lang.String";
        } else if (string.equals("int")) {
            string3 = "java.lang.Integer";
        } else if (string.equals("char")) {
            string3 = "java.lang.Character";
        } else if (string.equals("short")) {
            string3 = "java.lang.Short";
        } else if (string.equals("long")) {
            string3 = "java.lang.Long";
        } else if (string.equals("double")) {
            string3 = "java.lang.Double";
        } else if (string.equals("float")) {
            string3 = "java.lang.Float";
        } else if (string.equals("byte")) {
            string3 = "java.lang.Byte";
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.enumValues.size(); ++n) {
            String string4 = ((ChildEnumValueEntry)this.enumValues.get(n)).getEnumValue();
            if (string3.equals("java.lang.String")) {
                string4 = "\"" + string4 + "\"";
            } else if (string3.equals("java.lang.Character")) {
                string4 = "'" + string4 + "'";
            } else if (string3.equals("java.lang.Float")) {
                if (!string4.endsWith("F") && !string4.endsWith("f")) {
                    string4 = string4 + "F";
                }
            } else if (string3.equals("java.lang.Long")) {
                if (!string4.endsWith("L") && !string4.endsWith("l")) {
                    string4 = string4 + "L";
                }
            } else if (string3.equals(string)) {
                string4 = "new " + string3 + "(\"" + string4 + "\")";
            }
            vector.add(string4);
        }
        printWriter.println("    private " + string + " _value_;");
        printWriter.println("    private static java.util.HashMap _table_ = new java.util.HashMap();");
        printWriter.println("");
        printWriter.println("    // " + Messages.getMessage("ctor00"));
        printWriter.println("    protected " + string2 + "(" + string + " value) {");
        printWriter.println("        _value_ = value;");
        if (string3.equals("java.lang.String") || string3.equals(string)) {
            printWriter.println("        _table_.put(_value_,this);");
        } else {
            printWriter.println("        _table_.put(new " + string3 + "(_value_),this);");
        }
        printWriter.println("    };");
        printWriter.println("");
        for (n = 0; n < this.enumValues.size(); ++n) {
            printWriter.println("    public static final " + string + " _" + ((ChildEnumValueEntry)this.enumValues.get(n)).getName() + " = " + vector.get(n) + ";");
        }
        for (n = 0; n < this.enumValues.size(); ++n) {
            printWriter.println("    public static final " + string2 + " " + ((ChildEnumValueEntry)this.enumValues.get(n)).getName() + " = new " + string2 + "(_" + ((ChildEnumValueEntry)this.enumValues.get(n)).getName() + ");");
        }
        printWriter.println("    public " + string + " getValue() { return _value_;}");
        printWriter.println("    public static " + string2 + " fromValue(" + string + " value)");
        printWriter.println("          throws java.lang.IllegalArgumentException {");
        printWriter.println("        " + string2 + " enumeration = (" + string2 + ")");
        if (string3.equals("java.lang.String") || string3.equals(string)) {
            printWriter.println("            _table_.get(value);");
        } else {
            printWriter.println("            _table_.get(new " + string3 + "(value));");
        }
        printWriter.println("        if (enumeration==null) throw new java.lang.IllegalArgumentException();");
        printWriter.println("        return enumeration;");
        printWriter.println("    }");
        printWriter.println("    public static " + string2 + " fromString(java.lang.String value)");
        printWriter.println("          throws java.lang.IllegalArgumentException {");
        if (string3.equals("java.lang.String")) {
            printWriter.println("        return fromValue(value);");
        } else if (string3.equals(string)) {
            printWriter.println("        try {");
            printWriter.println("            return fromValue(new " + string3 + "(value));");
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("            throw new java.lang.IllegalArgumentException();");
            printWriter.println("        }");
        } else if (string3.equals("java.lang.Character")) {
            printWriter.println("        if (value != null && value.length() == 1);");
            printWriter.println("            return fromValue(value.charAt(0));");
            printWriter.println("        throw new java.lang.IllegalArgumentException();");
        } else if (string3.equals("java.lang.Integer")) {
            printWriter.println("        try {");
            printWriter.println("            return fromValue(java.lang.Integer.parseInt(value));");
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("            throw new java.lang.IllegalArgumentException();");
            printWriter.println("        }");
        } else {
            String string5 = "parse" + string3.substring(string3.lastIndexOf(".") + 1);
            printWriter.println("        try {");
            printWriter.println("            return fromValue(" + string3 + "." + string5 + "(value));");
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("            throw new java.lang.IllegalArgumentException();");
            printWriter.println("        }");
        }
        printWriter.println("    }");
        printWriter.println("    public boolean equals(java.lang.Object obj) {return (obj == this);}");
        printWriter.println("    public int hashCode() { return toString().hashCode();}");
        if (string3.equals("java.lang.String")) {
            printWriter.println("    public java.lang.String toString() { return _value_;}");
        } else if (string3.equals(string)) {
            printWriter.println("    public java.lang.String toString() { return _value_.toString();}");
        } else {
            printWriter.println("    public java.lang.String toString() { return java.lang.String.valueOf(_value_);}");
        }
        printWriter.println();
        if (this.emitter.isGenImplSer()) {
            printWriter.println("    private java.lang.Object readResolve() throws java.io.ObjectStreamException {");
            printWriter.println("        return fromValue(_value_);");
            printWriter.println("    }");
        }
    }
}

