/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBHomeWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBRIWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaInterfaceWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import javax.wsdl.Binding;

public class JavaBindingWriter
implements Generator {
    protected Generator stubWriter = null;
    protected Generator implWriter = null;
    protected Generator interfaceWriter = null;
    protected Emitter emitter;
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected JavaEJBRIWriter ejbRIWriter = null;
    protected JavaEJBHomeWriter ejbHomeWriter = null;
    private boolean isDeploy = false;

    public JavaBindingWriter(Emitter emitter, Binding binding, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.binding = binding;
        this.symbolTable = symbolTable;
    }

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean bl) {
        this.isDeploy = bl;
    }

    protected Generator getJavaInterfaceWriter(Emitter emitter, PortTypeEntry portTypeEntry, BindingEntry bindingEntry, SymbolTable symbolTable) {
        if ((emitter.getRole() == Role.SERVER || emitter.getRole() == Role.DEVELOP_SERVER) && emitter.getContainer() == Container.EJB) {
            this.ejbRIWriter = new JavaEJBRIWriter(emitter, portTypeEntry, bindingEntry, symbolTable);
            this.ejbHomeWriter = new JavaEJBHomeWriter(emitter, portTypeEntry, bindingEntry, symbolTable);
        }
        return new JavaInterfaceWriter(emitter, portTypeEntry, bindingEntry, symbolTable);
    }

    protected Generator getJavaStubWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        StubGenerator stubGenerator = null;
        Binding binding = bindingEntry.getBinding();
        String string = (String)bindingEntry.getDynamicVar(BindingEntry.BINDING_NAMESPACE);
        if (string == null) {
            emitter.getToolEnv().reportWarning(Messages.getMessage("w2j.UnsupportedBindingWarning", string));
        } else {
            ServiceProviderManager serviceProviderManager = new ServiceProviderManager();
            ServiceProvider serviceProvider = serviceProviderManager.getServiceProvider(string);
            if (serviceProvider != null) {
                stubGenerator = serviceProvider.getStubGenerator(emitter, bindingEntry, symbolTable);
            } else if (serviceProvider == null && string.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
                emitter.getToolEnv().reportWarning(Messages.getMessage("w2j.NoStubWriterWarn"));
                stubGenerator = new JavaStubWriter(emitter, bindingEntry, symbolTable);
            }
        }
        return stubGenerator;
    }

    protected Generator getJavaImplWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        if (emitter.getContainer() == Container.EJB) {
            return new JavaEJBImplWriter(emitter, bindingEntry, symbolTable);
        }
        return new JavaImplWriter(emitter, bindingEntry, symbolTable);
    }

    public void generate() throws IOException {
        if (this.emitter.getGenJava() != GenCriteria.NO) {
            this.setGenerators();
            if (this.interfaceWriter != null) {
                this.interfaceWriter.generate();
            }
            if (this.stubWriter != null) {
                this.stubWriter.generate();
            }
            if (this.implWriter != null) {
                this.implWriter.generate();
            }
            if (this.ejbRIWriter != null) {
                this.ejbRIWriter.generate();
            }
            if (this.ejbHomeWriter != null) {
                this.ejbHomeWriter.generate();
            }
        }
    }

    protected void setGenerators() {
        BindingEntry bindingEntry = this.symbolTable.getBindingEntry(this.binding.getQName());
        PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(this.binding.getPortType().getQName());
        if (portTypeEntry.isReferenced()) {
            this.interfaceWriter = this.getJavaInterfaceWriter(this.emitter, portTypeEntry, bindingEntry, this.symbolTable);
        }
        if (bindingEntry.isReferenced() && (bindingEntry.getBindingType() == 0 || bindingEntry.getBindingType() == 4)) {
            if (this.emitter.getRole() == Role.CLIENT || this.emitter.getRole() == Role.DEPLOY_CLIENT) {
                this.stubWriter = this.getJavaStubWriter(this.emitter, bindingEntry, this.symbolTable);
                if (this.stubWriter != null) {
                    this.stubWriter.setDeployPhaseOnly(true);
                }
            }
            if (this.emitter.getRole() == Role.SERVER || this.emitter.getRole() == Role.DEVELOP_SERVER) {
                String string = Utils.getJavaLocalName(bindingEntry.getName()) + "Impl.java";
                String string2 = this.emitter.getNamespaces().getAsDir(this.binding.getQName().getNamespaceURI());
                String string3 = string2 + string;
                if (Utils.fileShouldBeWritten(string3, this.emitter.getToolEnv(), this.emitter.getGenJava(), false)) {
                    this.implWriter = this.getJavaImplWriter(this.emitter, bindingEntry, this.symbolTable);
                }
            }
        }
    }
}

